/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdProtein;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.HashMap;

public class SnpEffCmdCds
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double maxErrorPercentage = 0.01;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String configFile = "snpEff.config";
    String genomeVer = "";
    String cdsFile = "";
    Config config;
    HashMap<String, String> cdsByTrId;

    public SnpEffCmdCds() {
    }

    public SnpEffCmdCds(Config config) {
        this.config = config;
        this.cdsFile = config.getFileNameCds();
    }

    public SnpEffCmdCds(String genomeVer, String configFile, String cdsFile) {
        this.configFile = configFile;
        this.genomeVer = genomeVer;
        this.cdsFile = cdsFile;
    }

    double cdsCompare() {
        int i = 1;
        for (Gene gint : this.config.getGenome().getGenes()) {
            for (Transcript tint : gint) {
                String cds = tint.cds().toUpperCase();
                String mRna = tint.mRna().toUpperCase();
                String cdsReference = this.cdsByTrId.get(tint.getId());
                if (cdsReference != null) {
                    cdsReference = cdsReference.toUpperCase();
                }
                if (cdsReference == null || cds.isEmpty()) {
                    if (this.verbose) {
                        System.err.println("\nWARNING:Cannot find CDS for transcript " + tint.getId());
                    } else {
                        System.out.print('.');
                    }
                    ++this.totalNotFound;
                } else if (cds.equals(cdsReference)) {
                    ++this.totalOk;
                    if (!this.verbose) {
                        System.out.print('+');
                    }
                    if (cds != null && cds.length() >= 3) {
                        String stopCodon;
                        String startCodon;
                        CodonTable ctable = CodonTables.getInstance().getTable(this.config.getGenome(), tint.getChromosomeName());
                        if (!ctable.isStart(startCodon = cds.substring(0, 3))) {
                            if (this.verbose) {
                                System.err.println("\nWARNING: CDS for transcript '" + tint.getId() + "' does not start with a start codon:\t" + startCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                        if (!ctable.isStop(stopCodon = cds.substring(cds.length() - 3, cds.length()))) {
                            if (this.verbose) {
                                System.err.println("\nWARNING: CDS for transcript '" + tint.getId() + "' does not end with a stop codon:\t" + stopCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                    }
                } else if (mRna.equals(cdsReference)) {
                    ++this.totalOk;
                    if (!this.verbose) {
                        System.out.print('-');
                    }
                } else if (mRna.length() < cdsReference.length() && cdsReference.substring(mRna.length()).replace('A', ' ').trim().isEmpty() && cdsReference.substring(0, mRna.length()).equals(mRna)) {
                    ++this.totalOk;
                    if (!this.verbose) {
                        System.out.print('-');
                    }
                } else if (mRna.length() > cdsReference.length() && mRna.substring(cdsReference.length()).replace('A', ' ').trim().isEmpty() && mRna.substring(0, cdsReference.length()).equals(mRna)) {
                    ++this.totalOk;
                    if (!this.verbose) {
                        System.out.print('-');
                    }
                } else {
                    if (this.verbose || onlyOneError) {
                        String diffMrna = SnpEffCmdProtein.diffStr(mRna, cdsReference);
                        int diffMrnaCount = SnpEffCmdProtein.diffCount(mRna, cdsReference);
                        String diffCds = SnpEffCmdProtein.diffStr(cds, cdsReference);
                        int diffCdsCount = SnpEffCmdProtein.diffCount(cds, cdsReference);
                        System.err.println("\nERROR:CDS do not match for transcript " + tint.getId() + "\tStrand:" + tint.getStrand() + "\tExons: " + tint.numChilds());
                        if (diffMrnaCount < diffCdsCount) {
                            System.err.println(String.format("\tsnpEff mRNA (%6d) : '%s'", mRna.length(), mRna.toLowerCase()));
                            System.err.println(String.format("\tdiff        (%6d) : '%s'", diffMrnaCount, diffMrna));
                        } else {
                            System.err.println(String.format("\tsnpEff CDS  (%6d) : '%s'", cds.length(), cds.toLowerCase()));
                            System.err.println(String.format("\tdiff        (%6d) : '%s'", diffCdsCount, diffCds));
                        }
                        System.err.println(String.format("\tReference   (%6d) : '%s'", cdsReference.length(), cdsReference.toLowerCase()));
                        System.err.println("Transcript details:\n" + tint);
                    } else {
                        System.out.print('*');
                    }
                    ++this.totalErrors;
                    if (onlyOneError) {
                        System.err.println("Transcript details:\n" + tint);
                        throw new RuntimeException("DIE");
                    }
                }
                if (!this.verbose && i % 100 == 0) {
                    System.out.print("\n\t");
                }
                ++i;
            }
        }
        double perc = (double)this.totalErrors / (double)(this.totalErrors + this.totalOk);
        System.out.println("\nCDS check:\t" + this.config.getGenome().getVersion() + "\tOK: " + this.totalOk + "\tWarnings: " + this.totalWarnings + "\tNot found: " + this.totalNotFound + "\tErrors: " + this.totalErrors + "\tError percentage: " + 100.0 * perc + "%");
        return perc;
    }

    @Override
    public void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
            } else if (this.cdsFile.isEmpty()) {
                this.cdsFile = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.cdsFile.isEmpty()) {
            this.usage("Missing cds_file parameter");
        }
    }

    void readCdsFile() {
        this.cdsByTrId = new HashMap();
        if (this.cdsFile.endsWith("txt") || this.cdsFile.endsWith("txt.gz")) {
            this.readCdsFileTxt();
        } else {
            this.readCdsFileFasta();
        }
    }

    void readCdsFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.cdsFile);
        for (String seq2 : ffi) {
            String trId = ffi.getName();
            if (this.cdsByTrId.get(trId) != null && !this.cdsByTrId.get(trId).equals(seq2)) {
                System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number: " + ffi.getLineNum() + "\n\tTranscript ID:\t" + trId + "\n\tCDS:\t\t" + this.cdsByTrId.get(trId) + "\n\tCDS (new):\t" + seq2);
            }
            this.cdsByTrId.put(trId, seq2);
        }
    }

    void readCdsFileTxt() {
        String cdsData = Gpr.readFile(this.cdsFile);
        String[] cdsLines = cdsData.split("\n");
        int lineNum = 1;
        String[] stringArray = cdsLines;
        int n = cdsLines.length;
        int n2 = 0;
        while (n2 < n) {
            String cdsLine = stringArray[n2];
            String[] field2 = cdsLine.split("\\s+");
            if (field2.length >= 2) {
                String seq2 = field2[1].trim();
                String trId = field2[0].trim();
                if (this.cdsByTrId.get(trId) != null && !this.cdsByTrId.get(trId).equals(seq2)) {
                    System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number: " + lineNum + "\n\tTranscript ID:\t" + trId + "\n\tCDS:\t\t" + this.cdsByTrId.get(trId) + "\n\tCDS (new):\t" + seq2);
                }
                this.cdsByTrId.put(trId, seq2);
            }
            ++lineNum;
            ++n2;
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Checking database using CDS sequences");
        }
        if (this.config == null) {
            if (this.verbose) {
                Timer.showStdErr("Reading configuration...");
            }
            this.config = new Config(this.genomeVer, this.configFile);
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Reading CDSs from file '" + this.cdsFile + "'...");
        }
        this.readCdsFile();
        if (this.verbose) {
            Timer.showStdErr("done (" + this.cdsByTrId.size() + " CDSs).");
        }
        if (this.config.getSnpEffectPredictor() == null) {
            if (this.verbose) {
                Timer.showStdErr("Reading database...");
            }
            this.config.loadSnpEffectPredictor();
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Comparing CDS...");
        }
        this.cdsCompare();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        return true;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff cds [options] genome_version cds_file");
        System.err.println("\nOptions:");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }
}

