/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import java.util.ArrayList;
import java.util.List;

public class ChangeEffect
implements Cloneable {
    static final boolean COMPATIBLE_v1_8 = true;
    SeqChange seqChange = null;
    EffectType effectType = EffectType.NONE;
    EffectImpact effectImpact = null;
    Marker marker = null;
    Exon exon = null;
    String error = "";
    String warning = "";
    String message = "";
    String codonsOld = "";
    String codonsNew = "";
    String codonsAroundOld = "";
    String codonsAroundNew = "";
    int codonNum = -1;
    int codonIndex = -1;
    int codonDegeneracy = -1;
    String aaOld = "";
    String aaNew = "";
    String aasAroundOld = "";
    String aasAroundNew = "";

    public static List<ChangeEffect> emptyResults() {
        return new ArrayList<ChangeEffect>();
    }

    public ChangeEffect(SeqChange seqChange) {
        this.seqChange = seqChange;
    }

    public void addError(String err2) {
        this.error = String.valueOf(this.error) + (this.error.isEmpty() ? "" : "|") + err2;
    }

    public void addWarning(String warn) {
        this.warning = String.valueOf(this.warning) + (this.warning.isEmpty() ? "" : "|") + warn;
    }

    public ChangeEffect clone() {
        try {
            return (ChangeEffect)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    String codonEffect(boolean showAaChange, boolean showBioType) {
        String codonEffect = "";
        if (this.marker == null || this.codonNum < 0) {
            return codonEffect;
        }
        codonEffect = String.valueOf(codonEffect) + (Object)((Object)this.effectType);
        if (showAaChange) {
            codonEffect = String.valueOf(codonEffect) + "(" + this.getAaChange() + ")";
        }
        return codonEffect;
    }

    public String effect(boolean shortFormat, boolean showAaChange, boolean showBioType) {
        String e = "";
        String codonEffect = this.codonEffect(showAaChange, showBioType);
        e = !codonEffect.isEmpty() ? codonEffect : (this.isRegulation() ? String.valueOf(this.effectType.toString()) + "[" + ((Regulation)this.marker).getName() + "]" : (this.isIntergenic() || this.isIntron() || this.isSpliceSite() ? this.effectType.toString() : (!this.message.isEmpty() ? String.valueOf(this.effectType.toString()) + ": " + this.message : (this.marker == null ? this.effectType.toString() : String.valueOf(this.effectType.toString()) + ": " + this.marker.getId()))));
        if (shortFormat) {
            e = e.split(":")[0];
        }
        return e;
    }

    public String getAaChange() {
        if (this.aaOld.isEmpty() && this.aaNew.isEmpty()) {
            return "";
        }
        if (this.aaOld.equals(this.aaNew)) {
            return this.aaNew;
        }
        return String.valueOf(this.aaOld) + "/" + this.aaNew;
    }

    public String getAaChangeHgvs() {
        if (this.aaOld.isEmpty() && this.aaNew.isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return "";
        }
        if (this.aaOld.equals(this.aaNew)) {
            return String.valueOf(this.aaNew) + (this.codonNum + 1);
        }
        return String.valueOf(this.aaOld) + (this.codonNum + 1) + this.aaNew;
    }

    public int getAaLength() {
        int lenNoStop = Math.max(0, this.getCdsLength() - 3);
        return lenNoStop / 3;
    }

    public String getAaNew() {
        return this.aaNew;
    }

    public String getAaOld() {
        return this.aaOld;
    }

    public int getCdsLength() {
        if (this.marker == null) {
            return -1;
        }
        int cdsSize = -1;
        Transcript tr = this.exon != null ? (Transcript)this.exon.findParent(Transcript.class) : (Transcript)this.marker.findParent(Transcript.class);
        if (tr != null) {
            cdsSize = tr.cds().length();
        }
        if (this.isUpstream() || this.isDownstream() || this.isUtr() || this.isSpliceSite() || this.isStartGained()) {
            cdsSize = -1;
        }
        return cdsSize;
    }

    public String getCodonChange() {
        if (this.codonsOld.isEmpty() && this.codonsNew.isEmpty()) {
            return "";
        }
        if (this.codonsOld.equals(this.codonsNew)) {
            return this.codonsNew;
        }
        return String.valueOf(this.codonsOld) + "/" + this.codonsNew;
    }

    public String getCodonsNew() {
        return this.codonsNew;
    }

    public String getCodonsOld() {
        return this.codonsOld;
    }

    public EffectImpact getEffectImpact() {
        if (this.effectImpact == null) {
            switch (this.effectType) {
                case SPLICE_SITE_ACCEPTOR: 
                case SPLICE_SITE_DONOR: 
                case START_LOST: 
                case EXON_DELETED: 
                case FRAME_SHIFT: 
                case RARE_AMINO_ACID: 
                case STOP_GAINED: 
                case STOP_LOST: {
                    this.effectImpact = EffectImpact.HIGH;
                    break;
                }
                case UTR_5_DELETED: 
                case NON_SYNONYMOUS_CODING: 
                case CODON_CHANGE: 
                case CODON_INSERTION: 
                case CODON_CHANGE_PLUS_CODON_INSERTION: 
                case CODON_DELETION: 
                case CODON_CHANGE_PLUS_CODON_DELETION: 
                case UTR_3_DELETED: {
                    this.effectImpact = EffectImpact.MODERATE;
                    break;
                }
                case START_GAINED: 
                case SYNONYMOUS_START: 
                case NON_SYNONYMOUS_START: 
                case SYNONYMOUS_CODING: 
                case SYNONYMOUS_STOP: 
                case NON_SYNONYMOUS_STOP: {
                    this.effectImpact = EffectImpact.LOW;
                    break;
                }
                case NONE: 
                case CHROMOSOME: 
                case INTERGENIC: 
                case UPSTREAM: 
                case UTR_5_PRIME: 
                case CDS: 
                case GENE: 
                case TRANSCRIPT: 
                case EXON: 
                case INTRON: 
                case UTR_3_PRIME: 
                case DOWNSTREAM: 
                case INTRON_CONSERVED: 
                case INTERGENIC_CONSERVED: 
                case INTRAGENIC: 
                case REGULATION: 
                case CUSTOM: {
                    this.effectImpact = EffectImpact.MODIFIER;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown impact for effect type: '" + (Object)((Object)this.effectType) + "'");
                }
            }
        }
        return this.effectImpact;
    }

    public EffectType getEffectType() {
        return this.effectType;
    }

    public String getError() {
        return this.error;
    }

    public Exon getExon() {
        return this.exon;
    }

    public FunctionalClass getFunctionalClass() {
        if (this.seqChange.isSnp()) {
            if (!this.aaNew.equals(this.aaOld)) {
                CodonTable codonTable = this.marker.codonTable();
                if (codonTable.isStop(this.codonsNew)) {
                    return FunctionalClass.NONSENSE;
                }
                return FunctionalClass.MISSENSE;
            }
            if (!this.codonsNew.equals(this.codonsOld)) {
                return FunctionalClass.SILENT;
            }
        }
        return FunctionalClass.NONE;
    }

    public Gene getGene() {
        if (this.marker == null) {
            return null;
        }
        return (Gene)this.marker.findParent(Gene.class);
    }

    public String getGeneRegion() {
        switch (this.effectType) {
            case NONE: 
            case CHROMOSOME: 
            case CDS: 
            case CUSTOM: {
                return EffectType.NONE.toString();
            }
            case INTERGENIC: 
            case INTERGENIC_CONSERVED: {
                return EffectType.INTERGENIC.toString();
            }
            case UPSTREAM: {
                return EffectType.UPSTREAM.toString();
            }
            case UTR_5_PRIME: 
            case UTR_5_DELETED: 
            case START_GAINED: {
                return EffectType.UTR_5_PRIME.toString();
            }
            case SPLICE_SITE_ACCEPTOR: {
                return EffectType.SPLICE_SITE_ACCEPTOR.toString();
            }
            case SPLICE_SITE_DONOR: {
                return EffectType.SPLICE_SITE_DONOR.toString();
            }
            case START_LOST: 
            case SYNONYMOUS_START: 
            case NON_SYNONYMOUS_START: 
            case GENE: 
            case TRANSCRIPT: 
            case INTRAGENIC: {
                if (this.hasExon()) {
                    return EffectType.EXON.toString();
                }
                return EffectType.NONE.toString();
            }
            case EXON: 
            case EXON_DELETED: 
            case NON_SYNONYMOUS_CODING: 
            case SYNONYMOUS_CODING: 
            case FRAME_SHIFT: 
            case CODON_CHANGE: 
            case CODON_INSERTION: 
            case CODON_CHANGE_PLUS_CODON_INSERTION: 
            case CODON_DELETION: 
            case CODON_CHANGE_PLUS_CODON_DELETION: 
            case RARE_AMINO_ACID: 
            case STOP_GAINED: 
            case SYNONYMOUS_STOP: 
            case NON_SYNONYMOUS_STOP: 
            case STOP_LOST: {
                return EffectType.EXON.toString();
            }
            case INTRON: 
            case INTRON_CONSERVED: {
                return EffectType.INTRON.toString();
            }
            case UTR_3_PRIME: 
            case UTR_3_DELETED: {
                return EffectType.UTR_3_PRIME.toString();
            }
            case DOWNSTREAM: {
                return EffectType.DOWNSTREAM.toString();
            }
            case REGULATION: {
                return EffectType.REGULATION.toString();
            }
        }
        throw new RuntimeException("Unknown gene region for effect type: '" + (Object)((Object)this.effectType) + "'");
    }

    public Marker getMarker() {
        return this.marker;
    }

    public SeqChange getSeqChange() {
        return this.seqChange;
    }

    public Transcript getTranscript() {
        if (this.marker == null) {
            return null;
        }
        return (Transcript)this.marker.findParent(Transcript.class);
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean hasExon() {
        return this.exon != null;
    }

    public boolean hasWarning() {
        return this.warning != null && !this.warning.isEmpty();
    }

    public String header() {
        return "Warnings\tGene_ID\tGene_name\tBio_type\tTrancript_ID\tExon_ID\tExon_Rank\tEffect\told_AA/new_AA\tOld_codon/New_codon\tCodon_Num(CDS)\tCodon_Degeneracy\tCDS_size\tCodons_around\tAAs_around\tCustom_interval_ID";
    }

    public boolean isCustom() {
        return this.effectType == EffectType.CUSTOM;
    }

    public boolean isDownstream() {
        return this.effectType == EffectType.DOWNSTREAM;
    }

    public boolean isExon() {
        return this.hasExon() || this.effectType == EffectType.EXON_DELETED;
    }

    public boolean isFrameShift() {
        return this.effectType == EffectType.FRAME_SHIFT;
    }

    public boolean isIntergenic() {
        return this.effectType == EffectType.INTERGENIC || this.effectType == EffectType.INTERGENIC_CONSERVED;
    }

    public boolean isIntron() {
        return this.effectType == EffectType.INTRON;
    }

    public boolean isRegulation() {
        return this.effectType == EffectType.REGULATION;
    }

    public boolean isSpliceSite() {
        return this.effectType == EffectType.SPLICE_SITE_DONOR || this.effectType == EffectType.SPLICE_SITE_ACCEPTOR;
    }

    public boolean isStartGained() {
        return this.effectType == EffectType.START_GAINED;
    }

    public boolean isUpstream() {
        return this.effectType == EffectType.UPSTREAM || this.effectType == EffectType.START_GAINED;
    }

    public boolean isUtr() {
        return this.effectType == EffectType.UTR_5_PRIME || this.effectType == EffectType.UTR_3_PRIME || this.effectType == EffectType.UTR_5_DELETED || this.effectType == EffectType.UTR_3_DELETED;
    }

    public List<ChangeEffect> newList() {
        ArrayList<ChangeEffect> list2 = new ArrayList<ChangeEffect>();
        list2.add(this.clone());
        return list2;
    }

    public void set(Marker marker, EffectType effectType, String message) {
        this.marker = marker;
        this.effectType = effectType;
        this.message = String.valueOf(this.message) + message;
    }

    public void setCodons(String codonsOld, String codonsNew, int codonNum, int codonIndex) {
        boolean indel;
        if (codonsOld.isEmpty()) {
            codonsOld = "-";
        }
        if (codonsNew.isEmpty()) {
            codonsNew = "-";
        }
        this.codonsOld = codonsOld;
        this.codonsNew = codonsNew;
        this.codonNum = codonNum;
        this.codonIndex = codonIndex;
        CodonTable codonTable = this.marker.codonTable();
        boolean bl = indel = codonsOld.length() != codonsNew.length();
        if (codonsOld.equals("-")) {
            this.aaOld = "-";
            indel = true;
        } else {
            this.aaOld = codonTable.aa(codonsOld);
            this.codonDegeneracy = codonTable.degenerate(codonsOld, codonIndex);
        }
        if (codonsNew.equals("-")) {
            this.aaNew = "-";
            indel = true;
        } else {
            this.aaNew = codonTable.aa(codonsNew);
        }
        if (!indel) {
            this.effectType = this.aaOld.equals(this.aaNew) ? (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.SYNONYMOUS_STOP : EffectType.STOP_LOST) : EffectType.SYNONYMOUS_CODING)) : (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.NON_SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.NON_SYNONYMOUS_STOP : EffectType.STOP_LOST) : (codonTable.isStop(codonsNew) ? EffectType.STOP_GAINED : EffectType.NON_SYNONYMOUS_CODING)));
        } else if (codonNum == 0 && codonTable.isStartFirst(codonsOld) && !codonTable.isStartFirst(codonsNew)) {
            this.effectType = EffectType.START_LOST;
        } else if (codonTable.isStop(codonsOld) && !codonTable.isStop(codonsNew)) {
            this.effectType = EffectType.STOP_LOST;
        } else if (!codonTable.isStop(codonsOld) && codonTable.isStop(codonsNew)) {
            this.effectType = EffectType.STOP_GAINED;
        }
    }

    public void setCodonsAround(String codonsLeft, String codonsRight) {
        this.codonsAroundOld = String.valueOf(codonsLeft.toLowerCase()) + this.codonsOld.toUpperCase() + codonsRight.toLowerCase();
        this.codonsAroundNew = String.valueOf(codonsLeft.toLowerCase()) + this.codonsNew.toUpperCase() + codonsRight.toLowerCase();
        CodonTable codonTable = this.marker.codonTable();
        String aasLeft = codonTable.aa(codonsLeft);
        String aasRigt = codonTable.aa(codonsRight);
        this.aasAroundOld = String.valueOf(aasLeft.toLowerCase()) + this.aaOld.toUpperCase() + aasRigt.toLowerCase();
        this.aasAroundNew = String.valueOf(aasLeft.toLowerCase()) + this.aaNew.toUpperCase() + aasRigt.toLowerCase();
    }

    public void setExon(Exon exon) {
        this.exon = exon;
    }

    public String toString() {
        String geneId = "";
        String geneName = "";
        String bioType = "";
        String transcriptId = "";
        String exonId = "";
        String customId = "";
        int exonRank = -1;
        if (this.marker != null) {
            Gene gene = (Gene)this.marker.findParent(Gene.class);
            Transcript tr = this.exon != null ? (Transcript)this.exon.findParent(Transcript.class) : (Transcript)this.marker.findParent(Transcript.class);
            if (gene != null) {
                geneId = gene.getId();
                geneName = gene.getGeneName();
                String string2 = bioType = tr != null ? tr.getBioType() : "";
                if (bioType.isEmpty() && gene.getGenome().hasCodingInfo()) {
                    String string3 = bioType = gene.isProteinCoding() ? "coding" : "non-coding";
                }
            }
            if (tr != null) {
                transcriptId = tr.getId();
            }
            if (this.exon != null) {
                exonId = this.exon.getId();
                exonRank = this.exon.getRank();
            }
            if (this.isRegulation()) {
                bioType = ((Regulation)this.marker).getCellType();
            }
        }
        if (!this.seqChange.getId().isEmpty()) {
            customId = String.valueOf(customId) + this.seqChange.getId();
        }
        if (this.marker != null && this.marker instanceof Custom) {
            customId = String.valueOf(customId) + (customId.isEmpty() ? "" : ";") + this.marker.getId();
        }
        int cdsSize = this.getCdsLength();
        String errWarn = String.valueOf(this.error) + (this.error.isEmpty() ? "" : "|") + this.warning;
        return String.valueOf(errWarn) + "\t" + geneId + "\t" + geneName + "\t" + bioType + "\t" + transcriptId + "\t" + exonId + "\t" + (exonRank >= 0 ? Integer.valueOf(exonRank) : "") + "\t" + this.effect(false, false, false) + "\t" + (this.aaOld.length() + this.aaNew.length() > 0 ? String.valueOf(this.aaOld) + "/" + this.aaNew : "") + "\t" + (this.codonsOld.length() + this.codonsNew.length() > 0 ? String.valueOf(this.codonsOld) + "/" + this.codonsNew : "") + "\t" + (this.codonNum >= 0 ? Integer.valueOf(this.codonNum + 1) : "") + "\t" + (this.codonDegeneracy >= 0 ? String.valueOf(this.codonDegeneracy) : "") + "\t" + (cdsSize >= 0 ? Integer.valueOf(cdsSize) : "") + "\t" + (this.codonsAroundOld.length() > 0 ? String.valueOf(this.codonsAroundOld) + " / " + this.codonsAroundNew : "") + "\t" + (this.aasAroundOld.length() > 0 ? String.valueOf(this.aasAroundOld) + " / " + this.aasAroundNew : "") + "\t" + customId;
    }

    public String toStringSimple(boolean shortFormat) {
        String eff;
        String transcriptId = "";
        String exonId = "";
        if (this.marker != null) {
            Transcript tr = (Transcript)this.marker.findParent(Transcript.class);
            if (tr != null) {
                transcriptId = tr.getId();
            }
            if (this.exon != null) {
                exonId = this.exon.getId();
            }
        }
        if ((eff = this.effect(shortFormat, true, true)).length() > 0) {
            return eff;
        }
        if (exonId.length() > 0) {
            return exonId;
        }
        if (transcriptId.length() > 0) {
            return transcriptId;
        }
        return "NO EFFECT";
    }

    public static enum Coding {
        CODING,
        NON_CODING;

    }

    public static enum EffectImpact {
        HIGH,
        MODERATE,
        LOW,
        MODIFIER;

    }

    public static enum EffectType {
        NONE,
        CHROMOSOME,
        INTERGENIC,
        UPSTREAM,
        UTR_5_PRIME,
        UTR_5_DELETED,
        START_GAINED,
        SPLICE_SITE_ACCEPTOR,
        SPLICE_SITE_DONOR,
        START_LOST,
        SYNONYMOUS_START,
        NON_SYNONYMOUS_START,
        CDS,
        GENE,
        GENOME,
        TRANSCRIPT,
        EXON,
        EXON_DELETED,
        NON_SYNONYMOUS_CODING,
        SYNONYMOUS_CODING,
        FRAME_SHIFT,
        CODON_CHANGE,
        CODON_INSERTION,
        CODON_CHANGE_PLUS_CODON_INSERTION,
        CODON_DELETION,
        CODON_CHANGE_PLUS_CODON_DELETION,
        RARE_AMINO_ACID,
        STOP_GAINED,
        SYNONYMOUS_STOP,
        NON_SYNONYMOUS_STOP,
        STOP_LOST,
        INTRON,
        UTR_3_PRIME,
        UTR_3_DELETED,
        DOWNSTREAM,
        INTRON_CONSERVED,
        INTERGENIC_CONSERVED,
        INTRAGENIC,
        REGULATION,
        MICRO_RNA,
        CUSTOM;

    }

    public static enum FunctionalClass {
        NONE,
        SILENT,
        MISSENSE,
        NONSENSE;

    }
}

