/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

import flanagan.analysis.Stat;

public class CochranArmitageTest {
    public static final double[] WEIGHT_DOMINANT = new double[]{1.0, 1.0, 0.0};
    public static final double[] WEIGHT_RECESSIVE = new double[]{0.0, 1.0, 1.0};
    public static final double[] WEIGHT_CODOMINANT = new double[]{0.0, 1.0, 2.0};
    private static CochranArmitageTest cochranArmitageTest = new CochranArmitageTest();
    public static double EPSILON = 1.0E-20;

    public static CochranArmitageTest get() {
        return cochranArmitageTest;
    }

    private CochranArmitageTest() {
    }

    public double p(int[] N1, int[] N2, double[] weight) {
        double t2 = this.test(N1, N2, weight);
        if (t2 > 0.0) {
            t2 = -t2;
        }
        double p = Stat.normalCDF(0.0, 1.0, t2);
        return p;
    }

    double t(int[] N1, int[] N2, double[] weight) {
        int R1 = 0;
        int R2 = 0;
        int k = N1.length;
        int i = 0;
        while (i < k) {
            R1 += N1[i];
            R2 += N2[i];
            ++i;
        }
        double t2 = 0.0;
        int i2 = 0;
        while (i2 < N1.length) {
            t2 += weight[i2] * (double)(N1[i2] * R2 - N2[i2] * R1);
            ++i2;
        }
        return t2;
    }

    public double test(int[] N1, int[] N2, double[] weight) {
        if (N1.length != N2.length) {
            throw new RuntimeException("Row length do not match: " + N1.length + " != " + N2.length);
        }
        if (N1.length != weight.length) {
            throw new RuntimeException("Weight length does not match data rows length: " + N1.length + " != " + weight.length);
        }
        double t2 = this.t(N1, N2, weight);
        double var = this.var(N1, N2, weight);
        return t2 / Math.sqrt(var);
    }

    double var(int[] N1, int[] N2, double[] weight) {
        int k = N1.length;
        int R1 = 0;
        int R2 = 0;
        int i = 0;
        while (i < k) {
            R1 += N1[i];
            R2 += N2[i];
            ++i;
        }
        int N = R1 + R2;
        double sum1 = 0.0;
        int i2 = 0;
        while (i2 < k) {
            int Ci = N1[i2] + N2[i2];
            sum1 += weight[i2] * weight[i2] * (double)Ci * (double)(N - Ci);
            ++i2;
        }
        double sum2 = 0.0;
        int i3 = 0;
        while (i3 < k - 1) {
            int Ci = N1[i3] + N2[i3];
            int j = i3 + 1;
            while (j < k) {
                int Cj = N1[j] + N2[j];
                sum2 += weight[i3] * weight[j] * (double)Ci * (double)Cj;
                ++j;
            }
            ++i3;
        }
        double var = (double)R1 * (double)R2 / (double)N * (sum1 - 2.0 * sum2);
        return var;
    }
}

