/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.ped.PedEntry;
import ca.mcgill.mcb.pcingola.ped.PedFileIterator;
import ca.mcgill.mcb.pcingola.ped.PlinkMap;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class PedPedigree {
    boolean verbose = false;
    HashMap<String, PedEntry> pedById = new HashMap();
    PlinkMap plinkMap;

    public void add(PedEntry pedEntry) {
        this.pedById.put(pedEntry.getId(), pedEntry);
    }

    public PedEntry get(String id) {
        return this.pedById.get(id);
    }

    public PlinkMap getPlinkMap() {
        return this.plinkMap;
    }

    public Set<String> keySet() {
        return this.pedById.keySet();
    }

    public void load(String pedFileName) {
        String pedBaseFileName = Gpr.removeExt(pedFileName);
        String mapFile = String.valueOf(pedBaseFileName) + ".map";
        PedFileIterator pedFile = new PedFileIterator(pedFileName, mapFile);
        int count2 = 1;
        for (PedEntry pe : pedFile) {
            if (this.verbose) {
                Gpr.showMarkStderr(count2++, 1);
            }
            this.add(pe);
        }
        this.plinkMap = pedFile.getPlinkMap();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int size() {
        return this.pedById.size();
    }

    public Collection<PedEntry> values() {
        return this.pedById.values();
    }
}

