/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class VcfOutputFormatter
extends OutputFormatter {
    public static final String VCF_INFO_EFF_NAME = "EFF";
    boolean needAddInfo = false;
    boolean needAddHeader = true;

    protected void addHeader() {
        VcfEntry vcfEntry = (VcfEntry)this.section;
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        for (String newHeaderLine : this.getNewHeaderLines()) {
            vcfFile.addHeader(newHeaderLine);
        }
        this.needAddHeader = false;
    }

    protected void addInfo(VcfEntry vcfEntry) {
        if (this.changeEffects.isEmpty()) {
            return;
        }
        HashSet<String> effs = new HashSet<String>();
        for (ChangeEffect changeEffect : this.changeEffects) {
            if (this.changeEffectResutFilter != null && this.changeEffectResutFilter.filter(changeEffect)) continue;
            StringBuilder effBuff = new StringBuilder();
            effBuff.append(changeEffect.effect(true, false, false));
            effBuff.append("(");
            effBuff.append((Object)changeEffect.getEffectImpact());
            effBuff.append("|");
            ChangeEffect.FunctionalClass fc = changeEffect.getFunctionalClass();
            effBuff.append(fc == ChangeEffect.FunctionalClass.NONE ? "" : fc.toString());
            effBuff.append("|");
            effBuff.append(changeEffect.getCodonChange());
            effBuff.append("|");
            effBuff.append(changeEffect.getAaChangeHgvs());
            effBuff.append("|");
            int aalen = changeEffect.getAaLength();
            effBuff.append(aalen > 0 ? Integer.valueOf(aalen) : "");
            effBuff.append("|");
            Gene gene = changeEffect.getGene();
            Transcript tr = changeEffect.getTranscript();
            if (gene != null) {
                String coding = "";
                if (gene.getGenome().hasCodingInfo()) {
                    coding = gene.isProteinCoding() ? ChangeEffect.Coding.CODING.toString() : ChangeEffect.Coding.NON_CODING.toString();
                }
                effBuff.append(gene.getGeneName());
                effBuff.append("|");
                effBuff.append(tr != null ? tr.getBioType() : "");
                effBuff.append("|");
                effBuff.append(coding);
                effBuff.append("|");
            } else if (changeEffect.isRegulation()) {
                Regulation reg = (Regulation)changeEffect.getMarker();
                effBuff.append("|" + reg.getCellType() + "||");
            } else if (changeEffect.isCustom()) {
                Marker m = changeEffect.getMarker();
                if (m != null) {
                    effBuff.append("|" + m.getId() + "||");
                } else {
                    effBuff.append("|||");
                }
            } else {
                effBuff.append("|||");
            }
            if (tr != null) {
                effBuff.append(tr.getId());
            }
            effBuff.append("|");
            Exon ex = changeEffect.getExon();
            if (ex != null) {
                effBuff.append(ex.getId());
            }
            if (!changeEffect.getWarning().isEmpty()) {
                effBuff.append("|" + changeEffect.getWarning());
            }
            if (!changeEffect.getError().isEmpty()) {
                effBuff.append("|" + changeEffect.getError());
            }
            effBuff.append(")");
            effs.add(effBuff.toString());
        }
        ArrayList listEffs = new ArrayList(effs);
        Collections.sort(listEffs);
        StringBuffer sbEffs = new StringBuffer();
        for (String eff : listEffs) {
            sbEffs.append(String.valueOf(eff) + ",");
        }
        if (sbEffs.length() > 0) {
            sbEffs.deleteCharAt(sbEffs.length() - 1);
        }
        vcfEntry.addInfo(VCF_INFO_EFF_NAME, sbEffs.toString());
        this.needAddInfo = false;
    }

    @Override
    public String endSection(Marker marker) {
        if (marker instanceof VcfEntry) {
            return super.endSection(marker);
        }
        return null;
    }

    public List<String> getNewHeaderLines() {
        ArrayList<String> newLines = new ArrayList<String>();
        newLines.add("##SnpEffVersion=\"" + this.version + "\"");
        newLines.add("##SnpEffCmd=\"" + this.commandLineStr + "\"");
        newLines.add("##INFO=<ID=EFF,Number=.,Type=String,Description=\"Predicted effects for this variant.Format: 'Effect ( Effect_Impact | Functional_Class | Codon_Change | Amino_Acid_change| Amino_Acid_length | Gene_Name | Gene_BioType | Coding | Transcript | Exon [ | ERRORS | WARNINGS ] )' \">");
        return newLines;
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof VcfEntry) {
            super.startSection(marker);
        }
        this.needAddInfo = true;
    }

    @Override
    public String toString() {
        VcfEntry vcfEntry = (VcfEntry)this.section;
        if (this.needAddInfo) {
            this.addInfo(vcfEntry);
        }
        return vcfEntry.toString();
    }

    @Override
    protected String toStringHeader() {
        if (this.needAddHeader) {
            this.addHeader();
        }
        VcfEntry vcfEntry = (VcfEntry)this.section;
        VcfFileIterator vcfFile = vcfEntry.getVcfFileIterator();
        return vcfFile.getHeader();
    }
}

