/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.HashSet;

public class BedOutputFormatter
extends OutputFormatter {
    public BedOutputFormatter() {
        this.outOffset = 0;
    }

    @Override
    public String endSection(Marker marker) {
        if (marker instanceof SeqChange) {
            return super.endSection(marker);
        }
        return null;
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof SeqChange) {
            super.startSection(marker);
        }
    }

    @Override
    public String toString() {
        SeqChange seqChange = (SeqChange)this.section;
        HashSet<String> chEffs = new HashSet<String>();
        for (ChangeEffect changeEffect : this.changeEffects) {
            Gene gene;
            if (this.changeEffectResutFilter != null && this.changeEffectResutFilter.filter(changeEffect)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(changeEffect.effect(true, false, false));
            Marker m = changeEffect.getMarker();
            if (m != null && (gene = (Gene)m.findParent(Gene.class)) != null) {
                sb.append("|" + gene.getGeneName() + "|" + gene.getBioType());
            }
            chEffs.add(sb.toString());
        }
        StringBuilder changeEffSb = new StringBuilder();
        changeEffSb.append(seqChange.getId());
        for (String chEff : chEffs) {
            changeEffSb.append(";");
            changeEffSb.append(chEff);
        }
        return String.valueOf(this.chrStr) + seqChange.getChromosomeName() + "\t" + (seqChange.getStart() + this.outOffset) + "\t" + (seqChange.getEnd() + 1) + "\t" + changeEffSb.toString() + "\t" + (!Double.isNaN(seqChange.getScore()) ? Double.valueOf(seqChange.getScore()) : "");
    }

    @Override
    public String toStringHeader() {
        return "# SnpEff version " + this.version + "\n" + "# Command line: " + this.commandLineStr + "\n" + "# Chromo\tStart\tEnd\tName;Effect|Gene|BioType\tScore";
    }
}

