/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.logStatsServer;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;

public class LogStats
extends Thread {
    public static final int LOG_THREAD_WAIT_TIME = 3000;
    public static final int LOG_THREAD_WAIT_TIME_REPEAT = 3;
    public static boolean debug = false;
    private static final String URL_ROOT = "http://www.tacner.com/special/recuse.php";
    private static final String HTTP_CHARSET = "ISO-8859-1";
    private static final int HTTP_CONNECT_TIMEOUT_MSECS = 22000;
    private static final int HTTP_READ_TIMEOUT_MSECS = 23000;
    private final Properties response = new Properties();
    public StringBuilder msg = new StringBuilder();
    private final String version;
    private RequestResult res = RequestResult.NOINFO;
    private long duration;
    protected boolean log = true;
    protected boolean verbose = false;
    HashMap<String, String> values;

    public static void report(String version, boolean ok, boolean verbose, String[] args, String errorMessage, HashMap<String, String> reportValues) {
        String[] properties;
        LogStats logStats = new LogStats(version);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                logStats.add("args_" + i, args[i]);
                ++i;
            }
        }
        logStats.add("Finished_OK", Boolean.toString(ok));
        if (errorMessage != null && !errorMessage.isEmpty()) {
            logStats.add("Error", errorMessage);
        }
        String[] stringArray = properties = new String[]{"user.name", "os.name", "os.version", "os.arch"};
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            try {
                logStats.add(prop, System.getProperty(prop));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        try {
            logStats.add("num.cores", String.valueOf(Gpr.NUM_CORES));
            logStats.add("total.mem", String.valueOf(Runtime.getRuntime().totalMemory()));
        }
        catch (Exception prop) {
            // empty catch block
        }
        for (String name : reportValues.keySet()) {
            logStats.add(name, reportValues.get(name));
        }
        logStats.start();
        if (verbose) {
            Timer.showStdErr("Finishing up");
        }
        int i = 0;
        while (i < 3) {
            if (!logStats.isAlive()) break;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (logStats.isAlive() && !logStats.isInterrupted()) {
            logStats.interrupt();
        }
    }

    public LogStats(String version) {
        this.version = version;
        this.values = new HashMap();
    }

    public void add(String name, String value2) {
        value2 = value2.replaceAll("\\n", "\\\\n");
        value2 = value2.replaceAll("\\t", "\\\\t");
        value2 = value2.replaceAll("\\r", "");
        this.values.put(name, value2);
    }

    private URL buildUrl() {
        try {
            return this.buildUrl0();
        }
        catch (MalformedURLException e) {
            this.msg.append(e.getMessage());
            return null;
        }
    }

    private URL buildUrl0() throws MalformedURLException {
        StringBuilder urlsb = new StringBuilder();
        urlsb.append(URL_ROOT).append("?");
        urlsb.append("program=").append(this.encode2url(SnpEff.class.getSimpleName()));
        urlsb.append("&version=").append(this.encode2url(this.version));
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.values.keySet());
        Collections.sort(names);
        for (String name : names) {
            urlsb.append("&" + name + "=").append(this.encode2url(this.values.get(name)));
        }
        return new URL(urlsb.toString());
    }

    public void connect() {
        block14: {
            int step2 = 0;
            long t0 = System.currentTimeMillis();
            if (debug) {
                Gpr.debug("Connect Step = " + step2);
            }
            try {
                try {
                    URL url = this.buildUrl();
                    step2 = 1;
                    if (debug) {
                        Gpr.debug("Connect Step = " + step2);
                    }
                    URLConnection hc = url.openConnection();
                    step2 = 2;
                    if (debug) {
                        Gpr.debug("Connect Step = " + step2);
                    }
                    hc.setConnectTimeout(22000);
                    hc.setReadTimeout(23000);
                    step2 = 3;
                    if (debug) {
                        Gpr.debug("Connect Step = " + step2);
                    }
                    this.response.load(hc.getInputStream());
                    step2 = 4;
                    if (debug) {
                        Gpr.debug("Connect Step = " + step2);
                    }
                    this.res = RequestResult.OK;
                }
                catch (Exception e) {
                    this.msg.append(step2 > 3 ? "Bad response" : "Error in connection. ").append(" Step " + step2).append("(").append(e.toString()).append(")");
                    this.res = RequestResult.ERROR;
                    this.duration = System.currentTimeMillis() - t0;
                    if (debug && !this.res.completed()) {
                        Gpr.debug("Error in connection: " + (Object)((Object)this.res) + " step=" + step2 + " duration(msecs)=" + this.duration + " " + this.msg);
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.duration = System.currentTimeMillis() - t0;
                if (debug && !this.res.completed()) {
                    Gpr.debug("Error in connection: " + (Object)((Object)this.res) + " step=" + step2 + " duration(msecs)=" + this.duration + " " + this.msg);
                }
                throw throwable;
            }
            this.duration = System.currentTimeMillis() - t0;
            if (debug && !this.res.completed()) {
                Gpr.debug("Error in connection: " + (Object)((Object)this.res) + " step=" + step2 + " duration(msecs)=" + this.duration + " " + this.msg);
            }
        }
        if (debug) {
            Gpr.debug("Connect done!");
        }
    }

    private String encode2url(String data2) {
        try {
            return URLEncoder.encode(data2, HTTP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public RequestResult getRes() {
        return this.res;
    }

    @Override
    public void run() {
        block4: {
            try {
                if (debug) {
                    Gpr.debug("Running thread");
                }
                this.connect();
                if (debug) {
                    Gpr.debug("Thread finished");
                }
            }
            catch (Throwable t2) {
                if (!debug) break block4;
                t2.printStackTrace();
            }
        }
    }

    public static enum RequestResult {
        OK,
        ERROR,
        NOINFO;


        public boolean completed() {
            return this != ERROR && this != NOINFO;
        }
    }
}

