/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.tree;

import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntervalNode
implements Serializable,
Iterable<Marker> {
    private static final long serialVersionUID = -444656480302906048L;
    private final SortedMap<Marker, List<Marker>> intervals = new TreeMap<Marker, List<Marker>>();
    private Integer center;
    private IntervalNode leftNode;
    private IntervalNode rightNode;

    public IntervalNode() {
        this.center = 0;
        this.leftNode = null;
        this.rightNode = null;
    }

    public IntervalNode(Markers intervalList) {
        TreeSet<Integer> endpoints = new TreeSet<Integer>();
        for (Interval interval : intervalList) {
            if (interval.isValid()) {
                endpoints.add(interval.getStart());
                endpoints.add(interval.getEnd());
                continue;
            }
            System.err.println("WARNING: Ignoring interval " + interval);
        }
        if (endpoints.isEmpty()) {
            this.center = 0;
            return;
        }
        int median = this.getMedian(endpoints);
        this.center = median;
        Markers left = new Markers();
        Markers right = new Markers();
        for (Marker interval : intervalList) {
            if (interval.getEnd() < median) {
                left.add(interval);
                continue;
            }
            if (interval.getStart() > median) {
                right.add(interval);
                continue;
            }
            ArrayList<Marker> posting = (ArrayList<Marker>)this.intervals.get(interval);
            if (posting == null) {
                posting = new ArrayList<Marker>();
                this.intervals.put(interval, posting);
            }
            posting.add(interval);
        }
        if (left.size() > 0) {
            this.leftNode = new IntervalNode(left);
        }
        if (right.size() > 0) {
            this.rightNode = new IntervalNode(right);
        }
    }

    void addAllIntervals(List<Marker> allIntervals) {
        for (List<Marker> list2 : this.intervals.values()) {
            allIntervals.addAll(list2);
        }
        if (this.leftNode != null) {
            this.leftNode.addAllIntervals(allIntervals);
        }
        if (this.rightNode != null) {
            this.rightNode.addAllIntervals(allIntervals);
        }
    }

    public Integer getCenter() {
        return this.center;
    }

    public IntervalNode getLeft() {
        return this.leftNode;
    }

    private Integer getMedian(SortedSet<Integer> set) {
        int i = 0;
        int middle = set.size() / 2;
        for (Integer point : set) {
            if (i == middle) {
                return point;
            }
            ++i;
        }
        return null;
    }

    public IntervalNode getRight() {
        return this.rightNode;
    }

    @Override
    public Iterator<Marker> iterator() {
        ArrayList<Marker> allIntervals = new ArrayList<Marker>();
        this.addAllIntervals(allIntervals);
        return allIntervals.iterator();
    }

    public Markers query(Interval target) {
        Markers result2 = new Markers();
        for (Map.Entry<Marker, List<Marker>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(target)) {
                for (Marker interval : entry.getValue()) {
                    result2.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > target.getEnd()) break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result2.add(this.leftNode.query(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result2.add(this.rightNode.query(target));
        }
        return result2;
    }

    public void setCenter(Integer center) {
        this.center = center;
    }

    public void setLeft(IntervalNode left) {
        this.leftNode = left;
    }

    public void setRight(IntervalNode right) {
        this.rightNode = right;
    }

    public Markers stab(Integer point) {
        Markers result2 = new Markers();
        for (Map.Entry<Marker, List<Marker>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(point.intValue())) {
                for (Marker interval : entry.getValue()) {
                    result2.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() > point) break;
        }
        if (point < this.center && this.leftNode != null) {
            result2.add(this.leftNode.stab(point));
        } else if (point > this.center && this.rightNode != null) {
            result2.add(this.rightNode.stab(point));
        }
        return result2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.center + ": ");
        for (Map.Entry<Marker, List<Marker>> entry : this.intervals.entrySet()) {
            sb.append("[" + entry.getKey().getStart() + "," + entry.getKey().getEnd() + "]:{");
            for (Interval interval : entry.getValue()) {
                sb.append("(" + interval + ")");
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

