/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;

public class CodonChangeDel
extends CodonChange {
    int oldCodonCdsStart = -1;
    int oldCodonCdsEnd = -1;

    public CodonChangeDel(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        super(seqChange, transcript, changeEffect);
        this.returnNow = false;
        this.requireNetCdsChange = true;
    }

    @Override
    boolean codonChangeSingle(ChangeEffect changeEffect, Exon exon) {
        if (this.netCdsChange.isEmpty()) {
            return false;
        }
        if (this.netCdsChange.length() % 3 != 0) {
            changeEffect.set(this.transcript, ChangeEffect.EffectType.FRAME_SHIFT, "");
            changeEffect.setCodons("", "", this.codonNum, this.codonIndex);
        } else if (this.codonIndex == 0) {
            this.codonsOld = this.codonsOld();
            changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_DELETION, "");
            changeEffect.setCodons(this.codonsOld, "", this.codonNum, this.codonIndex);
        } else {
            this.codonsOld = this.codonsOld();
            this.codonsNew = this.codonsNew();
            if (this.codonsNew.isEmpty() || this.codonsOld.startsWith(this.codonsNew)) {
                changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_DELETION, "");
                changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
            } else {
                changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_CHANGE_PLUS_CODON_DELETION, "");
                changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
            }
        }
        return true;
    }

    @Override
    String codonsNew() {
        int after = this.netCdsChange.length() + this.codonIndex;
        String codonsNew = String.valueOf(this.codonsOld.substring(0, this.codonIndex)) + (this.codonsOld.length() > after ? this.codonsOld.substring(after) : "");
        return codonsNew;
    }

    @Override
    public String codonsOld() {
        int min2 = this.seqChange.getStart();
        int max2 = this.seqChange.getEnd();
        int cdsBaseMin = this.cdsBaseNumber(min2);
        int cdsBaseMax = this.cdsBaseNumber(max2);
        if (this.transcript.getStrand() < 0) {
            int swap = cdsBaseMin;
            cdsBaseMin = cdsBaseMax;
            cdsBaseMax = swap;
        }
        if (cdsBaseMax < cdsBaseMin) {
            throw new RuntimeException("This should never happen!\n\tcdsBaseMin: " + cdsBaseMin + "\n\tcdsBaseMax: " + cdsBaseMax + "\n\tmin: " + min2 + "\n\tmax: " + max2 + "\n\tSeqChange: " + this.seqChange + "\n\ttranscript: " + this.transcript + "\n\tCDS.len: " + this.transcript.cds().length());
        }
        int maxCodon = cdsBaseMax / 3;
        int minCodon = cdsBaseMin / 3;
        this.oldCodonCdsStart = 3 * minCodon;
        this.oldCodonCdsEnd = 3 * (maxCodon + 1) - 1;
        String codons = "";
        codons = this.oldCodonCdsEnd >= this.transcript.cds().length() ? this.transcript.cds().substring(this.oldCodonCdsStart) : this.transcript.cds().substring(this.oldCodonCdsStart, this.oldCodonCdsEnd + 1);
        return codons;
    }
}

