/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Markers
implements Iterable<Marker>,
Serializable {
    private static final long serialVersionUID = 259791388087691277L;
    boolean verbose = true;
    ArrayList<Marker> markers;
    String name = "";

    public static Markers readTxt(String fileName, Genome genome) {
        Markers markers = new Markers();
        String file = Gpr.readFile(fileName);
        String[] lines2 = file.split("\n");
        int lineNum = 1;
        String[] stringArray = lines2;
        int n = lines2.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Marker interval = new Marker(null, 0, 0, 0, "");
            interval.readTxt(line, lineNum, genome, 0);
            markers.add(interval);
            ++lineNum;
            ++n2;
        }
        return markers;
    }

    public Markers() {
        this.markers = new ArrayList();
    }

    public Markers(String name) {
        this.name = name;
        this.markers = new ArrayList();
    }

    public void add(Marker marker) {
        this.markers.add(marker);
    }

    public void add(Markers intervalsMarkerIntervaloAdd) {
        this.markers.addAll(intervalsMarkerIntervaloAdd.markers);
    }

    public boolean equals(Markers intervals) {
        if (intervals == null) {
            return false;
        }
        if (this.size() != intervals.size()) {
            return false;
        }
        this.sort(false, false);
        intervals.sort(false, false);
        Iterator<Marker> it1 = this.iterator();
        Iterator<Marker> it2 = intervals.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Interval i2;
            Interval i1 = it1.next();
            if (i1.equals(i2 = (Interval)it2.next())) continue;
            return false;
        }
        return true;
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public String getName() {
        return this.name;
    }

    public Markers intersects(Marker interval) {
        Markers ints = new Markers();
        for (Marker i : this) {
            if (!i.intersects(interval)) continue;
            ints.add(i);
        }
        return ints;
    }

    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.markers.iterator();
    }

    public Markers merge() {
        Markers intsSorted = new Markers();
        intsSorted.add(this);
        intsSorted.sort(false, false);
        Markers intsMerged = new Markers();
        String tag = "";
        String chromoName = "";
        Chromosome chromo = null;
        int start = -1;
        int end = -1;
        for (Marker i : intsSorted) {
            Marker im;
            Chromosome ichromo = i.getChromosome();
            String ichromoName = ichromo.getId();
            if (!chromoName.equals(ichromoName)) {
                if (start >= 0 && end >= 0) {
                    im = new Marker(chromo, start, end, 1, tag);
                    intsMerged.add(im);
                }
                chromoName = ichromoName;
                chromo = ichromo;
                end = -1;
                start = -1;
                tag = "";
            }
            if (i.start > end) {
                if (start >= 0 && end >= 0) {
                    im = new Marker(chromo, start, end, 1, tag);
                    intsMerged.add(im);
                }
                end = -1;
                start = -1;
                tag = "";
            }
            if (start < 0) {
                start = i.start;
            }
            end = Math.max(end, i.end);
            tag = tag.length() <= 0 ? i.id : String.valueOf(tag) + " " + i.id;
        }
        if (start >= 0 && end >= 0) {
            Marker im = new Marker(chromo, start, end, 1, tag);
            intsMerged.add(im);
        }
        return intsMerged;
    }

    public Markers minus(Marker interval) {
        Markers ints = new Markers();
        for (Marker i : this) {
            if (i.intersects(interval)) {
                if (interval.getStart() <= i.getStart() && i.getEnd() <= interval.getEnd()) continue;
                if (interval.getStart() <= i.getStart() && interval.getEnd() < i.getEnd()) {
                    ints.add(new Marker(i.getParent(), interval.getEnd() + 1, i.getEnd(), i.getStrand(), i.getId()));
                    continue;
                }
                if (i.getStart() < interval.getStart() && i.getEnd() <= interval.getEnd()) {
                    ints.add(new Marker(i.getParent(), i.getStart(), interval.getStart() - 1, i.getStrand(), i.getId()));
                    continue;
                }
                if (i.getStart() < interval.getStart() && interval.getEnd() < i.getEnd()) {
                    ints.add(new Marker(i.getParent(), i.getStart(), interval.getStart() - 1, i.getStrand(), i.getId()));
                    ints.add(new Marker(i.getParent(), interval.getEnd() + 1, i.getEnd(), i.getStrand(), i.getId()));
                    continue;
                }
                throw new RuntimeException("Interval intersection not analysed. This should nbever happen!");
            }
            ints.add(i);
        }
        return ints;
    }

    public Markers minus(Markers intervals) {
        Markers result2 = new Markers();
        result2.add(this);
        for (Marker j : intervals) {
            result2 = result2.minus(j);
        }
        return result2;
    }

    public Interval rand() {
        int idx = (int)(Math.random() * (double)this.markers.size());
        return this.markers.get(idx);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int size() {
        return this.markers.size();
    }

    public void sort(boolean byEnd, boolean reverse2) {
        if (byEnd) {
            Collections.sort(this.markers, new IntervalComparatorByEnd(reverse2));
        } else {
            Collections.sort(this.markers, new IntervalComparatorByStart(reverse2));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Marker i : this) {
            sb.append(i + " ");
        }
        return sb.toString();
    }

    public String toStringAsciiArt(int maxLen) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        int i = 0;
        while (i < maxLen) {
            sep = String.valueOf(sep) + "=";
            ++i;
        }
        String ch = "";
        for (Marker i2 : this) {
            if (!i2.getChromosomeName().equals(ch)) {
                sb.append("|" + sep + "|\n");
                ch = i2.getChromosomeName();
            }
            sb.append("|" + i2.toStringAsciiArt(maxLen) + "|\t" + i2.getChromosomeName() + ": [" + i2.start + " - " + i2.end + "] ");
            if (i2.id != null && i2.id.length() > 0) {
                sb.append("'" + i2.id + "'");
            }
            sb.append("\n");
        }
        sb.append("|" + sep + "|\n");
        return sb.toString();
    }

    public String toStringTxt() {
        StringBuilder sb = new StringBuilder();
        for (Marker i : this) {
            sb.append(String.valueOf(i.getChromosomeName()) + "\t" + i.getStart() + "\t" + i.getEnd() + "\t" + i.getId() + "\n");
        }
        return sb.toString();
    }

    public Markers union(Markers intervalsForUnion) {
        Markers ints = new Markers();
        ints.add(this);
        ints.add(intervalsForUnion);
        return ints;
    }

    public Markers unionOfOverlaps() {
        Markers unionOfOverlaps = new Markers();
        IntervalForest forest = new IntervalForest(this);
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker mi : this) {
            if (done.contains(mi)) continue;
            Markers query = forest.query(mi);
            Marker union2 = new Marker(mi.getParent(), mi.getStart(), mi.getEnd(), mi.getStrand(), "");
            done.add(mi);
            for (Marker m : query) {
                if (union2.getStart() > m.getStart() || union2.getEnd() < m.getEnd()) {
                    int start = Math.min(union2.getStart(), m.getStart());
                    int end = Math.max(union2.getEnd(), m.getEnd());
                    union2 = new Marker(mi.getParent(), start, end, m.getStrand(), "");
                }
                done.add(m);
            }
            unionOfOverlaps.add(union2);
        }
        return unionOfOverlaps;
    }
}

