/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import java.util.HashMap;

public class ChromosomeSimpleName {
    public static final String[] CHROMO_PREFIX = new String[]{"chr", "chromo", "chromosome", "group", "scaffold", "contig", "supercontig", "supercont"};
    private static ChromosomeSimpleName instance = new ChromosomeSimpleName();
    private final HashMap<String, String> map = new HashMap();

    public static String get(String chrName) {
        return instance.simpleNameCache(chrName);
    }

    private ChromosomeSimpleName() {
    }

    protected String simpleName(String chr) {
        if (chr == null) {
            return "";
        }
        chr = chr.trim();
        String chName = chr.toLowerCase();
        String[] stringArray = CHROMO_PREFIX;
        int n = CHROMO_PREFIX.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (chName.startsWith(String.valueOf(prefix) + ":")) {
                return chr.substring(prefix.length() + 1);
            }
            if (chName.startsWith(String.valueOf(prefix) + "_")) {
                return chr.substring(prefix.length() + 1);
            }
            if (chName.startsWith(String.valueOf(prefix) + "-")) {
                return chr.substring(prefix.length() + 1);
            }
            if (chName.startsWith(prefix)) {
                return chr.substring(prefix.length());
            }
            ++n2;
        }
        return chr;
    }

    protected String simpleNameCache(String chrName) {
        String chr = this.map.get(chrName);
        if (chr == null) {
            chr = this.simpleName(chrName);
            this.map.put(chrName, chr);
        }
        return chr;
    }
}

