/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.parser.Parser;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class VcfFileIterator
extends MarkerFileIterator<VcfEntry>
implements Parser<VcfEntry> {
    public static final String MISSING = ".";
    private static final String EMPTY = "";
    boolean parseNow = true;
    StringBuffer header = new StringBuffer();
    HashMap<String, VcfInfo> vcfInfoById;

    public VcfFileIterator(BufferedReader reader) {
        super(reader, 1);
    }

    public VcfFileIterator(Genome genome) {
        super((String)null, 1);
        this.genome = genome;
    }

    public VcfFileIterator(String fileName) {
        super(fileName, 1);
    }

    public VcfFileIterator(String fileName, Genome genome) {
        super(fileName, 1);
        this.genome = genome;
    }

    public void addFormat(String formatName, String number2, String type, String description) {
        String headerFormatInfo = "##FORMAT=<ID=" + formatName + ",Number=" + number2 + ",Type=" + type + ",Description=\"" + description + "\">";
        this.addHeader(headerFormatInfo);
    }

    public void addHeader(String newHeaderLine) {
        String[] headerLines = this.header.toString().split("\n");
        this.header = new StringBuffer();
        boolean added = false;
        String[] stringArray = headerLines;
        int n = headerLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.equals(newHeaderLine)) {
                newHeaderLine = null;
                added = true;
            } else if (line.startsWith("#CHROM") && newHeaderLine != null) {
                this.header.append(String.valueOf(newHeaderLine) + "\n");
                added = true;
            }
            if (!line.isEmpty()) {
                this.header.append(String.valueOf(line) + "\n");
            }
            ++n2;
        }
        if (!added) {
            this.header.append(String.valueOf(newHeaderLine) + "\n");
        }
    }

    public String getHeader() {
        if (this.header.length() <= 0) {
            return EMPTY;
        }
        char c = this.header.charAt(this.header.length() - 1);
        while (c == '\n' || c == '\r') {
            this.header.deleteCharAt(this.header.length() - 1);
            c = this.header.charAt(this.header.length() - 1);
        }
        return this.header.toString();
    }

    public List<String> getSampleNames() {
        String[] headerLines;
        String[] stringArray = headerLines = this.header.toString().split("\n");
        int n = headerLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("#CHROM")) {
                String[] titles = line.split("\t");
                ArrayList<String> sampleNames = new ArrayList<String>();
                int i = 9;
                while (i < titles.length) {
                    sampleNames.add(titles[i]);
                    ++i;
                }
                return sampleNames;
            }
            ++n2;
        }
        return null;
    }

    public Collection<VcfInfo> getVcfInfo() {
        this.parseInfoLines();
        return this.vcfInfoById.values();
    }

    public VcfInfo getVcfInfo(String id) {
        this.parseInfoLines();
        return this.vcfInfoById.get(id);
    }

    @Override
    public Collection<VcfEntry> parse(String str) {
        LinkedList<VcfEntry> list2 = new LinkedList<VcfEntry>();
        list2.add(this.parseVcfLine(str));
        return list2;
    }

    public void parseInfoLines() {
        if (this.vcfInfoById == null) {
            String[] headerLines;
            this.vcfInfoById = new HashMap();
            this.vcfInfoById.put("CHROM", new VcfInfo("CHROM", VcfInfoType.STRING, "1", "Chromosome name"));
            this.vcfInfoById.put("POS", new VcfInfo("POS", VcfInfoType.INTEGER, "1", "Position in chromosome"));
            this.vcfInfoById.put("ID", new VcfInfo("ID", VcfInfoType.STRING, "1", "Variant ID"));
            this.vcfInfoById.put("REF", new VcfInfo("REF", VcfInfoType.STRING, "1", "Reference sequence"));
            this.vcfInfoById.put("ALT", new VcfInfo("ALT", VcfInfoType.STRING, "A", "Alternative sequence/s"));
            this.vcfInfoById.put("QUAL", new VcfInfo("QUAL", VcfInfoType.FLOAT, "1", "Mapping quality"));
            this.vcfInfoById.put("FILTER", new VcfInfo("FILTER", VcfInfoType.STRING, "1", "Filter status"));
            this.vcfInfoById.put("FORMAT", new VcfInfo("FORMAT", VcfInfoType.STRING, "1", "Format in genotype fields"));
            this.vcfInfoById.put("AA", new VcfInfo("AA", VcfInfoType.STRING, "1", "Ancestral allele"));
            this.vcfInfoById.put("AC", new VcfInfo("AC", VcfInfoType.INTEGER, "A", "Allele Frequency"));
            this.vcfInfoById.put("AF", new VcfInfo("AF", VcfInfoType.FLOAT, "1", "Allele Frequency"));
            this.vcfInfoById.put("AN", new VcfInfo("AN", VcfInfoType.INTEGER, "1", "Total number of alleles"));
            this.vcfInfoById.put("BQ", new VcfInfo("BQ", VcfInfoType.FLOAT, "1", "RMS base quality"));
            this.vcfInfoById.put("CIGAR", new VcfInfo("CIGAR", VcfInfoType.STRING, "1", "Cigar string describing how to align an alternate allele to the reference allele"));
            this.vcfInfoById.put("DB", new VcfInfo("DB", VcfInfoType.FLAG, "1", "dbSNP membership"));
            this.vcfInfoById.put("DP", new VcfInfo("DP", VcfInfoType.INTEGER, "1", "Combined depth across samples"));
            this.vcfInfoById.put("END", new VcfInfo("END", VcfInfoType.STRING, "1", "End position of the variant described in this record"));
            this.vcfInfoById.put("H2", new VcfInfo("H2", VcfInfoType.FLAG, "1", "Membership in hapmap 2"));
            this.vcfInfoById.put("H3", new VcfInfo("H3", VcfInfoType.FLAG, "1", "Membership in hapmap 3"));
            this.vcfInfoById.put("MQ", new VcfInfo("MQ", VcfInfoType.FLOAT, "1", "RMS mapping quality"));
            this.vcfInfoById.put("MQ0", new VcfInfo("MQ0", VcfInfoType.INTEGER, "1", "Number of MAPQ == 0 reads covering this record"));
            this.vcfInfoById.put("NS", new VcfInfo("NS", VcfInfoType.INTEGER, "1", "Number of samples with data"));
            this.vcfInfoById.put("SB", new VcfInfo("SB", VcfInfoType.FLOAT, "1", "Strand bias at this position"));
            this.vcfInfoById.put("SOMATIC", new VcfInfo("SOMATIC", VcfInfoType.FLAG, "1", "Indicates that the record is a somatic mutation, for cancer genomics"));
            this.vcfInfoById.put("VALIDATED", new VcfInfo("VALIDATED", VcfInfoType.FLAG, "1", "Validated by follow-up experiment"));
            this.vcfInfoById.put("1000G", new VcfInfo("1000G", VcfInfoType.FLAG, "1", "Membership in 1000 Genomes"));
            this.vcfInfoById.put("IMPRECISE", new VcfInfo("IMPRECISE", VcfInfoType.FLAG, "0", "Imprecise structural variation"));
            this.vcfInfoById.put("NOVEL", new VcfInfo("NOVEL", VcfInfoType.FLAG, "0", "Indicates a novel structural variation"));
            this.vcfInfoById.put("END", new VcfInfo("END", VcfInfoType.INTEGER, "1", "End position of the variant described in this record"));
            this.vcfInfoById.put("SVTYPE", new VcfInfo("SVTYPE", VcfInfoType.STRING, "1", "Type of structural variant"));
            this.vcfInfoById.put("SVLEN", new VcfInfo("SVLEN", VcfInfoType.INTEGER, MISSING, "Difference in length between REF and ALT alleles"));
            this.vcfInfoById.put("CIPOS", new VcfInfo("CIPOS", VcfInfoType.INTEGER, "2", "Confidence interval around POS for imprecise variants"));
            this.vcfInfoById.put("CIEND", new VcfInfo("CIEND", VcfInfoType.INTEGER, "2", "Confidence interval around END for imprecise variants"));
            this.vcfInfoById.put("HOMLEN", new VcfInfo("HOMLEN", VcfInfoType.INTEGER, MISSING, "Length of base pair identical micro-homology at event breakpoints"));
            this.vcfInfoById.put("HOMSEQ", new VcfInfo("HOMSEQ", VcfInfoType.STRING, MISSING, "Sequence of base pair identical micro-homology at event breakpoints"));
            this.vcfInfoById.put("BKPTID", new VcfInfo("BKPTID", VcfInfoType.STRING, MISSING, "ID of the assembled alternate allele in the assembly file"));
            this.vcfInfoById.put("MEINFO", new VcfInfo("MEINFO", VcfInfoType.STRING, "4", "Mobile element info of the form NAME,START,END,POLARITY"));
            this.vcfInfoById.put("METRANS", new VcfInfo("METRANS", VcfInfoType.STRING, "4", "Mobile element transduction info of the form CHR,START,END,POLARITY"));
            this.vcfInfoById.put("DGVID", new VcfInfo("DGVID", VcfInfoType.STRING, "1", "ID of this element in Database of Genomic Variation"));
            this.vcfInfoById.put("DBVARID", new VcfInfo("DBVARID", VcfInfoType.STRING, "1", "ID of this element in DBVAR"));
            this.vcfInfoById.put("DBRIPID", new VcfInfo("DBRIPID", VcfInfoType.STRING, "1", "ID of this element in DBRIP"));
            this.vcfInfoById.put("MATEID", new VcfInfo("MATEID", VcfInfoType.STRING, MISSING, "ID of mate breakends"));
            this.vcfInfoById.put("PARID", new VcfInfo("PARID", VcfInfoType.STRING, "1", "ID of partner breakend"));
            this.vcfInfoById.put("EVENT", new VcfInfo("EVENT", VcfInfoType.STRING, "1", "ID of event associated to breakend"));
            this.vcfInfoById.put("CILEN", new VcfInfo("CILEN", VcfInfoType.INTEGER, "2", "Confidence interval around the length of the inserted material between breakends"));
            this.vcfInfoById.put("DP", new VcfInfo("DP", VcfInfoType.INTEGER, "1", "Read Depth of segment containing breakend"));
            this.vcfInfoById.put("DPADJ", new VcfInfo("DPADJ", VcfInfoType.INTEGER, MISSING, "Read Depth of adjacency"));
            this.vcfInfoById.put("CN", new VcfInfo("CN", VcfInfoType.INTEGER, "1", "Copy number of segment containing breakend"));
            this.vcfInfoById.put("CNADJ", new VcfInfo("CNADJ", VcfInfoType.INTEGER, MISSING, "Copy number of adjacency"));
            this.vcfInfoById.put("CICN", new VcfInfo("CICN", VcfInfoType.INTEGER, "2", "Confidence interval around copy number for the segment"));
            this.vcfInfoById.put("CICNADJ", new VcfInfo("CICNADJ", VcfInfoType.INTEGER, MISSING, "Confidence interval around copy number for the adjacency"));
            this.vcfInfoById.put("EFF.EFFECT", new VcfInfo("EFF.EFFECT", VcfInfoType.STRING, MISSING, "SnpEff effect"));
            this.vcfInfoById.put("EFF.IMPACT", new VcfInfo("EFF.IMPACT", VcfInfoType.STRING, MISSING, "SnpEff impact (HIGH, MODERATE, LOW, MODIFIER)"));
            this.vcfInfoById.put("EFF.FUNCLASS", new VcfInfo("EFF.FUNCLASS", VcfInfoType.STRING, MISSING, "SnpEff functional class (NONE, SILENT, MISSENSE, NONSENSE)"));
            this.vcfInfoById.put("EFF.CODON", new VcfInfo("EFF.CODON", VcfInfoType.STRING, MISSING, "SnpEff codon change"));
            this.vcfInfoById.put("EFF.AA", new VcfInfo("EFF.AA", VcfInfoType.STRING, MISSING, "SnpEff amino acid change"));
            this.vcfInfoById.put("EFF.AA_LEN", new VcfInfo("EFF.AA_LEN", VcfInfoType.INTEGER, MISSING, "Protein length in amino acids"));
            this.vcfInfoById.put("EFF.GENE", new VcfInfo("EFF.GENE", VcfInfoType.STRING, MISSING, "SnpEff gene name"));
            this.vcfInfoById.put("EFF.BIOTYPE", new VcfInfo("EFF.BIOTYPE", VcfInfoType.STRING, MISSING, "SnpEff gene bio-type"));
            this.vcfInfoById.put("EFF.CODING", new VcfInfo("EFF.CODING", VcfInfoType.STRING, MISSING, "SnpEff gene coding (CODING, NON_CODING)"));
            this.vcfInfoById.put("EFF.TRID", new VcfInfo("EFF.TRID", VcfInfoType.STRING, MISSING, "SnpEff transcript ID"));
            this.vcfInfoById.put("EFF.EXID", new VcfInfo("EFF.EXID", VcfInfoType.STRING, MISSING, "SnpEff exon ID"));
            String[] stringArray = headerLines = this.header.toString().split("\n");
            int n = headerLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith("##INFO=") || line.startsWith("##FORMAT=")) {
                    VcfInfo vcfInfo = new VcfInfo(line);
                    this.vcfInfoById.put(vcfInfo.getId(), vcfInfo);
                }
                ++n2;
            }
        }
    }

    protected VcfEntry parseVcfLine(String line) {
        try {
            if (line.startsWith("#")) {
                this.header.append(String.valueOf(line) + "\n");
            } else if (line.length() > 0 && !line.startsWith("#")) {
                return new VcfEntry(this, line, this.lineNum, this.parseNow);
            }
        }
        catch (Throwable t2) {
            Gpr.debug("Fatal error reading file '" + this.fileName + "' (line: " + this.lineNum + "):\n" + line);
            throw new RuntimeException(t2);
        }
        return null;
    }

    public String readField(String[] fields, int fieldNum) {
        if (fields.length > fieldNum) {
            if (fields[fieldNum].equals(MISSING)) {
                return EMPTY;
            }
            return fields[fieldNum];
        }
        return EMPTY;
    }

    /*
     * Exception decompiling
     */
    public String readHeader() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected VcfEntry readNext() {
        try {
            VcfEntry vcfEntry;
            do {
                if (!this.ready()) {
                    return null;
                }
                this.line = this.readLine();
                if (this.line != null) continue;
                return null;
            } while ((vcfEntry = this.parseVcfLine(this.line)) == null);
            return vcfEntry;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
    }

    @Override
    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setParseNow(boolean parseNow) {
        this.parseNow = parseNow;
    }
}

