/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.coverage;

import ca.mcgill.mcb.pcingola.coverage.CoverageChr;
import ca.mcgill.mcb.pcingola.fileIterator.SamFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.sam.SamEntry;
import ca.mcgill.mcb.pcingola.sam.SamHeaderRecord;
import ca.mcgill.mcb.pcingola.sam.SamHeaderRecordSq;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CountFragments
implements Serializable {
    private static int SHOW_EVERY = 10000;
    private static final long serialVersionUID = 1150158182247576450L;
    HashMap<String, CoverageChr> coverageByName = new HashMap();

    public static CountFragments calculateFromSam(String samFile, boolean verbose) {
        int i = 1;
        boolean header = true;
        String chrPrev = "";
        SamFileIterator sfi = new SamFileIterator(samFile);
        CountFragments coverage = new CountFragments();
        Pattern patternCigar = Pattern.compile("(\\d+)([A-Z])");
        if (verbose) {
            Timer.showStdErr("Processing file '" + samFile + "'");
        }
        for (SamEntry se : sfi) {
            if (header) {
                header = false;
                for (SamHeaderRecord rec : sfi.getHeaders().getRecords("SQ")) {
                    SamHeaderRecordSq sq = (SamHeaderRecordSq)rec;
                    coverage.createChr(sq.getSequenceName(), sq.getLength());
                }
            }
            String chrName = se.getRname();
            int start = se.getPos() - 1;
            String cigar = se.getCigar();
            Matcher matcher = patternCigar.matcher(cigar);
            while (matcher.find()) {
                int len = Gpr.parseIntSafe(matcher.group(1));
                String op = matcher.group(2);
                if (op.equals("M")) {
                    coverage.inc(chrName, start, start + len - 1);
                }
                if (!op.equals("M") && !op.equals("D") && !op.equals("N") && !op.equals("EQ") && !op.equals("X") && !op.equals("P")) continue;
                start += len;
            }
            if (!verbose) continue;
            if (!chrName.equals(chrPrev)) {
                System.err.println("");
                Timer.showStdErr(String.valueOf(chrName) + "\t");
            }
            chrPrev = chrName;
            Gpr.showMark(i++, SHOW_EVERY);
        }
        return coverage;
    }

    public double avgCoverage(Marker m) {
        String chr = m.getChromosomeName();
        CoverageChr cchr = this.get(chr);
        if (cchr == null) {
            throw new RuntimeException("Chromosome '" + chr + "' not found!");
        }
        return cchr.avgCoverage(m.getStart(), m.getEnd());
    }

    public void createChr(String chr, int len) {
        this.coverageByName.put(Chromosome.simpleName(chr), new CoverageChr(len));
    }

    public CoverageChr get(String chr) {
        return this.coverageByName.get(Chromosome.simpleName(chr));
    }

    public void inc(String chr, int start, int end) {
        chr = Chromosome.simpleName(chr);
        this.get(chr).inc(start, end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

