/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.codons;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.RareAminoAcid;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class FindRareAaIntervals {
    public static final double RARE_THRESHOLD = 1.0E-5;
    boolean verbose = false;
    double rareThreshold = 1.0E-5;
    Genome genome;
    CodonTable codonTable;
    int[] count;
    int countTotal;
    boolean[] isInTable;
    HashMap<String, Transcript> trById;
    HashMap<String, RareAminoAcid> rareAaByPos;

    public FindRareAaIntervals(Genome genome) {
        this.genome = genome;
        this.codonTable = genome.codonTable();
        this.count = new int[90];
        this.isInTable = new boolean[90];
        this.countTotal = 0;
        this.rareAaByPos = new HashMap();
    }

    void addRareAa(Transcript tr, int start, int end) {
        int s = Math.min(start, end);
        int e = Math.max(start, end);
        String key = String.valueOf(tr.getChromosomeName()) + ":" + s + "-" + e;
        if (this.rareAaByPos.containsKey(key)) {
            return;
        }
        RareAminoAcid raa = new RareAminoAcid(tr, s, e, "");
        this.rareAaByPos.put(key, raa);
    }

    public Collection<RareAminoAcid> findRareAa(String proteinFastaFile) {
        this.isInTable();
        this.proteingFileStats(proteinFastaFile);
        String rare = this.findRareNames();
        if (rare.isEmpty()) {
            return new LinkedList<RareAminoAcid>();
        }
        this.findRareAaSites(proteinFastaFile, rare);
        return this.rareAaByPos.values();
    }

    void findRareAaSites(String trId, int aaIdx) {
        Transcript tr;
        if (this.trById == null) {
            this.trById = new HashMap();
            for (Gene gene : this.genome.getGenome().getGenes()) {
                for (Transcript tr2 : gene) {
                    this.trById.put(tr2.getId(), tr2);
                }
            }
        }
        if ((tr = this.trById.get(trId)) == null) {
            if (this.verbose) {
                System.err.println("WARNING: Cannot find transcript '" + trId + "'");
            }
            return;
        }
        int[] cds2pos = tr.cdsBaseNumber2ChrPos();
        int pos = 0;
        int posPrev = 0;
        int start = -1;
        int step2 = tr.isStrandPlus() ? 1 : -1;
        int cds = aaIdx * 3;
        while (cds < (aaIdx + 1) * 3) {
            pos = cds2pos[cds];
            if (start < 0) {
                start = pos;
            } else if (pos != posPrev + step2) {
                this.addRareAa(tr, start, pos);
                start = -1;
            }
            posPrev = pos;
            ++cds;
        }
        if (start >= 0) {
            this.addRareAa(tr, start, pos);
        }
    }

    void findRareAaSites(String proteinFastaFile, String rareAa) {
        char[] rareAaChr = rareAa.toCharArray();
        FastaFileIterator ffi = new FastaFileIterator(proteinFastaFile);
        for (String seq2 : ffi) {
            char[] cArray = rareAaChr;
            int n = rareAaChr.length;
            int n2 = 0;
            while (n2 < n) {
                char aa = cArray[n2];
                int aaIdx = seq2.indexOf(aa);
                if (aaIdx >= 0) {
                    String trId = ffi.getTranscriptId();
                    this.findRareAaSites(trId, aaIdx);
                }
                ++n2;
            }
        }
    }

    String findRareNames() {
        StringBuilder rare = new StringBuilder();
        int i = 0;
        while (i < this.count.length) {
            double p = (double)this.count[i] / (double)this.countTotal;
            if (this.count[i] > 0 && (p < this.rareThreshold || !this.isInTable[i])) {
                rare.append((char)i);
            }
            ++i;
        }
        return rare.toString();
    }

    public double getRareThreshold() {
        return this.rareThreshold;
    }

    void isInTable() {
        char[] cArray = GprSeq.BASES;
        int n = GprSeq.BASES.length;
        int n2 = 0;
        while (n2 < n) {
            char c1 = cArray[n2];
            char[] cArray2 = GprSeq.BASES;
            int n3 = GprSeq.BASES.length;
            int n4 = 0;
            while (n4 < n3) {
                char c2 = cArray2[n4];
                char[] cArray3 = GprSeq.BASES;
                int n5 = GprSeq.BASES.length;
                int n6 = 0;
                while (n6 < n5) {
                    char c3 = cArray3[n6];
                    String codon = "" + c1 + c2 + c3;
                    String aa = this.codonTable.aa(codon);
                    this.isInTable[aa.toUpperCase().charAt((int)0)] = true;
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    void proteingFileStats(String proteinFastaFile) {
        FastaFileIterator ffi = new FastaFileIterator(proteinFastaFile);
        for (String seq2 : ffi) {
            char[] cArray = seq2.toUpperCase().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Character.isLetter(c) && c != 'X') {
                    char c2 = c;
                    this.count[c2] = this.count[c2] + 1;
                    ++this.countTotal;
                }
                ++n2;
            }
        }
    }

    public void setRareThreshold(double rareThreshold) {
        this.rareThreshold = rareThreshold;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.count.length) {
            double p = (double)this.count[i] / (double)this.countTotal;
            if (this.count[i] > 0) {
                sb.append(String.format("\t%s\t%d\t%.2e\t%b\n", Character.valueOf((char)i), this.count[i], p, this.isInTable[i]));
            }
            ++i;
        }
        return sb.toString();
    }
}

