/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.variation;

import edu.mit.broad.picard.variation.AbstractKnownVariantCodec;
import edu.mit.broad.picard.variation.KnownVariant;
import edu.mit.broad.picard.variation.KnownVariantFileHeader;
import edu.mit.broad.picard.variation.VariantType;
import java.io.File;
import java.util.List;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.RuntimeEOFException;

public class ObsoleteKnownVariantCodecV1
extends AbstractKnownVariantCodec {
    public static final String MAGIC_NUMBER = "DBS\u0001";
    private static final int KV_RECORD_LENGTH_LESS_NAME = 15;
    private boolean headerReadOrWritten = false;

    public ObsoleteKnownVariantCodecV1(File dbSnpFile, boolean writing) {
        super(dbSnpFile, writing);
    }

    @Override
    public String getCodecVersionMagicNumber() {
        return MAGIC_NUMBER;
    }

    @Override
    public KnownVariantFileHeader decodeKnownVariantFileHeader() {
        String magic = this.decodeMagicNumber();
        List<SAMSequenceRecord> dictionary = this.decodeSequenceDictionary();
        int dbSnpCount = this.decodeDbSnpCount();
        KnownVariantFileHeader header = new KnownVariantFileHeader(magic, dictionary, dbSnpCount);
        this.headerReadOrWritten = true;
        return header;
    }

    @Override
    public void encodeKnownVariantFileHeader(KnownVariantFileHeader header) {
        this.encodeMagicNumber();
        this.encodeSequenceDictionary(header.getSequenceDictionary());
        this.encodeDbSnpCount(header.getDbSnpCount());
        this.headerReadOrWritten = true;
    }

    @Override
    public KnownVariant decodeKnownVariant() {
        int blockSize;
        if (!this.headerReadOrWritten) {
            throw new IllegalStateException("Header must be decoded first.");
        }
        try {
            blockSize = this.readInt();
        }
        catch (RuntimeEOFException e) {
            return null;
        }
        int seqIndex = this.readInt();
        int startPos = this.readInt() + 1;
        int endPos = this.readInt();
        VariantType type = VariantType.getVariantTypeFromOrdinal(this.readByte());
        boolean validated = this.readBoolean();
        String name = this.readString(blockSize - 15);
        this.readByte();
        return new KnownVariant(name, seqIndex, startPos, endPos, type, validated);
    }

    @Override
    public void encodeKnownVariant(KnownVariant variant) {
        if (!this.headerReadOrWritten) {
            throw new IllegalStateException("Header must be encoded first.");
        }
        this.writeInt(variant.getName().length() + 15);
        this.writeInt(variant.getSequenceIndex());
        this.writeInt(variant.getStartPos() - 1);
        this.writeInt(variant.getEndPos());
        this.writeByte((byte)variant.getType().ordinal());
        this.writeBoolean(variant.isValidated());
        this.writeString(variant.getName(), false, true);
    }
}

