/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.geli.GeliException;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoods;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoodsCodec;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.picard.util.AbstractIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.IOUtil;

public class GeliFileReader
extends AbstractIterator<GenotypeLikelihoods>
implements Iterable<GenotypeLikelihoods>,
CloseableIterator<GenotypeLikelihoods> {
    private final GenotypeLikelihoodsCodec codec;

    public GeliFileReader(InputStream stream) {
        try {
            if (!BlockCompressedInputStream.isValidFile((InputStream)IOUtil.toBufferedStream((InputStream)stream))) {
                throw new GeliException("Invalid GELI file");
            }
            this.codec = new GenotypeLikelihoodsCodec(new DataInputStream((InputStream)new BlockCompressedInputStream(stream)));
        }
        catch (IOException e) {
            throw new GeliException("Exception opening GELI stream", e);
        }
    }

    public GeliFileReader(File file) {
        try {
            if (!BlockCompressedInputStream.isValidFile((InputStream)IOUtil.toBufferedStream((InputStream)new FileInputStream(file)))) {
                throw new GeliException("Invalid GELI file");
            }
            this.codec = new GenotypeLikelihoodsCodec(new DataInputStream((InputStream)new BlockCompressedInputStream(file)));
        }
        catch (IOException e) {
            throw new GeliException("Exception opening file " + file.getAbsolutePath(), e);
        }
    }

    public void close() {
        this.codec.close();
    }

    public SAMFileHeader getFileHeader() {
        return this.codec.getFileHeader();
    }

    @Override
    public CloseableIterator<GenotypeLikelihoods> iterator() {
        if (this.isIterating()) {
            throw new IllegalStateException("Iteration in progress");
        }
        return this;
    }

    protected GenotypeLikelihoods advance() {
        return this.codec.decode();
    }
}

