/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.util;

import java.io.File;
import java.io.FileFilter;
import net.sf.picard.io.IoUtil;

public class PicardAggregationFsUtil {
    public File AGGREGATION_DIRECTORY = new File("/seq/picard_aggregation");

    public File[] findProjectDirectories() {
        return this.AGGREGATION_DIRECTORY.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }
        });
    }

    public File[] findSampleDirectories(String project) {
        return this.findSampleDirectories(new File(this.AGGREGATION_DIRECTORY, project));
    }

    public File[] findSampleDirectories(File projectDir) {
        if (!projectDir.exists()) {
            return new File[0];
        }
        return projectDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    public File getSampleDirectory(String project, String sampleAlias) {
        File projectDir = new File(this.AGGREGATION_DIRECTORY, project);
        if (!projectDir.exists()) {
            return null;
        }
        File sampleDir = new File(projectDir, IoUtil.makeFileNameSafe((String)sampleAlias));
        if (sampleDir.exists()) {
            return sampleDir;
        }
        return null;
    }

    public File findLatestFinishedAggregationForSample(File sampleDirectory) {
        File[] versions = sampleDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("v") && file.isDirectory();
            }
        });
        int latestVersion = 0;
        File latest = null;
        for (File f : versions) {
            if (!this.isFinished(f)) continue;
            int v = Integer.parseInt(f.getName().substring(1));
            if (latest != null && v <= latestVersion) continue;
            latestVersion = v;
            latest = f;
        }
        return latest;
    }

    public boolean isFinished(File versionDirectory) {
        File bam = this.getBam(versionDirectory);
        return new File(versionDirectory, "finished.txt").exists() && bam != null && bam.exists();
    }

    public File getBam(File versionDirectory) {
        File bam = new File(versionDirectory, versionDirectory.getAbsoluteFile().getParentFile().getName() + ".bam");
        if (!bam.exists()) {
            return null;
        }
        return bam;
    }
}

