/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.genotype.geli;

import edu.mit.broad.picard.genotype.DiploidGenotype;
import edu.mit.broad.picard.genotype.geli.GeliException;
import edu.mit.broad.picard.genotype.geli.GenotypeLikelihoods;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeEOFException;
import net.sf.samtools.util.StringLineReader;
import net.sf.samtools.util.StringUtil;

public class GenotypeLikelihoodsCodec
extends BinaryCodec {
    private static final DiploidGenotype[] DIPLOID_GENOTYPES = DiploidGenotype.values();
    public static final String GELI_VERSION = "GL01";
    private static final byte[] GELI_MAGIC = StringUtil.stringToBytes((String)"GL01");
    private SAMFileHeader fileHeader;

    public GenotypeLikelihoodsCodec(InputStream inputStream) {
        super((InputStream)IOUtil.toBufferedStream((InputStream)inputStream));
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, GELI_MAGIC)) {
            throw new GeliException("Invalid GELI file");
        }
        this.readHeader();
    }

    public GenotypeLikelihoodsCodec(OutputStream outputStream, SAMFileHeader fileHeader) {
        super(outputStream);
        this.writeBytes(GELI_MAGIC);
        this.writeHeader(fileHeader);
    }

    public void encode(GenotypeLikelihoods genotypeLikelihoods) {
        this.writeInt(genotypeLikelihoods.getSequenceIndex());
        this.writeInt(genotypeLikelihoods.getPosition());
        this.writeByte(genotypeLikelihoods.getReferenceBase());
        this.writeUShort(genotypeLikelihoods.getNumReads());
        this.writeUByte(genotypeLikelihoods.getMaxMappingQuality());
        for (DiploidGenotype genotype : DIPLOID_GENOTYPES) {
            this.writeLikelihood(genotypeLikelihoods.getLikelihood(genotype));
        }
    }

    public GenotypeLikelihoods decode() {
        GenotypeLikelihoods genotypeLikelihoods = new GenotypeLikelihoods(this.fileHeader);
        try {
            genotypeLikelihoods.setSequenceIndex(this.readInt());
        }
        catch (RuntimeEOFException eof) {
            return null;
        }
        genotypeLikelihoods.setPosition(this.readInt());
        genotypeLikelihoods.setReferenceBase(this.readByte());
        genotypeLikelihoods.setNumReads(this.readUShort());
        genotypeLikelihoods.setMaxMappingQuality(this.readUByte());
        for (DiploidGenotype genotype : DIPLOID_GENOTYPES) {
            genotypeLikelihoods.setLikelihood(genotype, this.readLikelihood());
        }
        return genotypeLikelihoods;
    }

    private void writeLikelihood(float likelihood) {
        this.writeFloat(likelihood);
    }

    private float readLikelihood() {
        return this.readFloat();
    }

    private void writeHeader(SAMFileHeader header) {
        this.fileHeader = header;
        StringWriter headerTextBuffer = new StringWriter();
        new SAMTextHeaderCodec().encode((Writer)headerTextBuffer, header);
        String headerText = headerTextBuffer.toString();
        this.writeInt(headerText.length());
        this.writeBytes(headerText.getBytes());
    }

    private void readHeader() {
        int headerTextLength = this.readInt();
        String textHeader = this.readString(headerTextLength);
        this.fileHeader = new SAMTextHeaderCodec().decode((LineReader)new StringLineReader(textHeader), null);
    }

    public SAMFileHeader getFileHeader() {
        return this.fileHeader;
    }
}

