/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.Logger;
import freemarker.log.LoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

class Log4JLoggerFactory
implements LoggerFactory {
    Log4JLoggerFactory() {
    }

    public Logger getLogger(String category) {
        return new Log4JLogger(org.apache.log4j.Logger.getLogger((String)category));
    }

    private static class Log4JLogger
    extends Logger {
        private final org.apache.log4j.Logger logger;

        Log4JLogger(org.apache.log4j.Logger logger) {
            this.logger = logger;
        }

        public void debug(String message) {
            this.logger.debug((Object)message);
        }

        public void debug(String message, Throwable t2) {
            this.logger.debug((Object)message, t2);
        }

        public void error(String message) {
            this.logger.error((Object)message);
        }

        public void error(String message, Throwable t2) {
            this.logger.error((Object)message, t2);
        }

        public void info(String message) {
            this.logger.info((Object)message);
        }

        public void info(String message, Throwable t2) {
            this.logger.info((Object)message, t2);
        }

        public void warn(String message) {
            this.logger.warn((Object)message);
        }

        public void warn(String message, Throwable t2) {
            this.logger.warn((Object)message, t2);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.logger.isEnabledFor((Priority)Level.WARN);
        }

        public boolean isErrorEnabled() {
            return this.logger.isEnabledFor((Priority)Level.ERROR);
        }

        public boolean isFatalEnabled() {
            return this.logger.isEnabledFor((Priority)Level.FATAL);
        }
    }
}

