/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.MinimisationFunction;

class GCSminim
implements MinimisationFunction {
    public double psiDelta = 0.0;
    public double tempK = 298.15;
    public double surfaceSiteDensity = 0.0;
    public double surfaceArea = 0.0;
    public double volume = 0.0;
    public int nonZeroAssocK = 0;
    public double[] assocK = null;
    public double[] initConcn = null;
    public double[] charges = null;
    public int[] indexK = null;

    @Override
    public double function(double[] x2) {
        double gFunction = 0.0;
        double arg = 0.0;
        int ii = 0;
        double convFac = this.surfaceArea / this.volume;
        double expTerm = this.psiDelta * -1.60217646263E-19 / (1.380650324E-23 * this.tempK);
        double innerSumTerm = 0.0;
        int i = 0;
        while (i < this.nonZeroAssocK) {
            innerSumTerm += x2[0];
            ++i;
        }
        innerSumTerm = this.surfaceSiteDensity - innerSumTerm;
        i = 0;
        while (i < this.nonZeroAssocK) {
            ii = this.indexK[i];
            arg = this.assocK[ii] * (this.initConcn[ii] - x2[i] * convFac) * Math.exp(expTerm * this.charges[ii]) * innerSumTerm - x2[0];
            gFunction += arg * arg;
            ++i;
        }
        return gFunction;
    }
}

