/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.integration.IntegralFunction;

class FunctionPatX
implements IntegralFunction {
    public int numOfIons = 0;
    public double termOne = 0.0;
    public double expTerm = 0.0;
    public double[] bulkConcn = null;
    public double[] charges = null;

    FunctionPatX() {
    }

    @Override
    public double function(double x2) {
        double sigma = 0.0;
        int i = 0;
        while (i < this.numOfIons) {
            sigma += this.bulkConcn[i] * this.termOne * (Math.exp(-this.expTerm * this.charges[i] * x2) - 1.0);
            ++i;
        }
        return 1.0 / Math.sqrt(sigma);
    }
}

