/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.roots.RealRootFunction;

class FunctTMplot
implements RealRootFunction {
    public double substrateRefractiveIndex2 = 0.0;
    public double superstrateRefractiveIndex2 = 0.0;
    public double coreFilmRefractiveIndex2 = 0.0;
    public double prismRefractiveIndex2 = 0.0;
    public double ko = 0.0;
    public double prismToWaveguideGap = 0.0;
    public boolean setPrismToWaveguideGap = false;
    public double thickness = 0.0;
    public double modeNumber = 0.0;

    FunctTMplot() {
    }

    @Override
    public double function(double x2) {
        double y = 0.0;
        double effectiveRefractiveIndex2 = x2 * x2;
        double zetaSub = Math.sqrt(effectiveRefractiveIndex2 - this.substrateRefractiveIndex2);
        double zetaSuper = Math.sqrt(effectiveRefractiveIndex2 - this.superstrateRefractiveIndex2);
        double zetaFilm = Math.sqrt(this.coreFilmRefractiveIndex2 - effectiveRefractiveIndex2);
        double zetaPrism = Math.sqrt(this.prismRefractiveIndex2 - effectiveRefractiveIndex2);
        double gammaSuper = Math.atan2(this.coreFilmRefractiveIndex2 * zetaSuper, this.superstrateRefractiveIndex2 * zetaFilm);
        y = Math.PI * this.modeNumber - this.thickness * this.ko * zetaFilm;
        y += gammaSuper + Math.atan2(this.coreFilmRefractiveIndex2 * zetaSub, this.substrateRefractiveIndex2 * zetaFilm);
        if (this.setPrismToWaveguideGap) {
            y += Math.sin(gammaSuper) * Math.cos(Math.atan2(zetaSuper * this.prismRefractiveIndex2, zetaPrism * this.superstrateRefractiveIndex2)) * Math.exp(-2.0 * this.prismToWaveguideGap * zetaSuper);
        }
        return y;
    }
}

