/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class Matrix {
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private double[][] matrix = null;
    private double[][] hessenberg = null;
    private boolean hessenbergDone = false;
    private int[] permutationIndex = null;
    private double rowSwapIndex = 1.0;
    private double[] eigenValues = null;
    private double[][] eigenVector = null;
    private double[] sortedEigenValues = null;
    private double[][] sortedEigenVector = null;
    private int numberOfRotations = 0;
    private int[] eigenIndices = null;
    private int maximumJacobiIterations = 100;
    private boolean eigenDone = false;
    private boolean matrixCheck = true;
    private boolean supressErrorMessage = false;
    private double tiny = 1.0E-100;

    public Matrix(int numberOfRows, int numberOfColumns) {
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.matrix = new double[numberOfRows][numberOfColumns];
        this.permutationIndex = new int[numberOfRows];
        int i = 0;
        while (i < numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(int numberOfRows, int numberOfColumns, double constant) {
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.matrix = new double[numberOfRows][numberOfColumns];
        int i = 0;
        while (i < numberOfRows) {
            int j = 0;
            while (j < numberOfColumns) {
                this.matrix[i][j] = constant;
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[numberOfRows];
        i = 0;
        while (i < numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(double[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j];
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(float[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j];
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(long[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j];
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(int[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j];
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(ArrayMaths[] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(ArrayList<Object>[] twoDal) {
        this.numberOfRows = twoDal.length;
        ArrayMaths[] twoD = new ArrayMaths[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            twoD[i] = new ArrayMaths(twoDal[i]);
            ++i;
        }
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(Vector<Object>[] twoDv) {
        this.numberOfRows = twoDv.length;
        ArrayMaths[] twoD = new ArrayMaths[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            twoD[i] = new ArrayMaths(twoDv[i]);
            ++i;
        }
        this.numberOfColumns = twoD[0].length();
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            double[] arrayh = twoD[i].copy().array();
            if (arrayh.length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            this.matrix[i] = arrayh;
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(BigDecimal[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j].doubleValue();
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(BigInteger[][] twoD) {
        this.numberOfRows = twoD.length;
        this.numberOfColumns = twoD[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (twoD[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            ++i;
        }
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = twoD[i][j].doubleValue();
                ++j;
            }
            ++i;
        }
        this.permutationIndex = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            this.permutationIndex[i] = i;
            ++i;
        }
    }

    public Matrix(Matrix bb) {
        this.numberOfRows = bb.numberOfRows;
        this.numberOfColumns = bb.numberOfColumns;
        this.matrix = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = bb.matrix[i][j];
                ++j;
            }
            ++i;
        }
        this.permutationIndex = Conv.copy(bb.permutationIndex);
        this.rowSwapIndex = bb.rowSwapIndex;
    }

    public void resetLUzero(double zeroValue) {
        this.tiny = zeroValue;
    }

    public void setTwoDarray(double[][] aarray) {
        if (this.numberOfRows != aarray.length) {
            throw new IllegalArgumentException("row length of this Matrix differs from that of the 2D array argument");
        }
        if (this.numberOfColumns != aarray[0].length) {
            throw new IllegalArgumentException("column length of this Matrix differs from that of the 2D array argument");
        }
        int i = 0;
        while (i < this.numberOfRows) {
            if (aarray[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            int j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = aarray[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void setElement(int i, int j, double aa) {
        this.matrix[i][j] = aa;
    }

    public void setSubMatrix(int i, int j, double[][] subMatrix) {
        int k = subMatrix.length;
        int l = subMatrix[0].length;
        if (i + k - 1 >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (j + l - 1 >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix");
        }
        int m = 0;
        int n = 0;
        int p = 0;
        while (p < k) {
            n = 0;
            int q = 0;
            while (q < l) {
                this.matrix[i + p][j + q] = subMatrix[m][n];
                ++n;
                ++q;
            }
            ++m;
            ++p;
        }
    }

    public void setSubMatrix(int i, int j, int k, int l, double[][] subMatrix) {
        this.setSubMatrix(i, j, subMatrix);
    }

    public void setSubMatrix(int[] row, int[] col, double[][] subMatrix) {
        int n = row.length;
        int m = col.length;
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                this.matrix[row[p]][col[q]] = subMatrix[p][q];
                ++q;
            }
            ++p;
        }
    }

    public boolean getMatrixCheck() {
        return this.matrixCheck;
    }

    public static Matrix identityMatrix(int numberOfRows) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        int i = 0;
        while (i < numberOfRows) {
            special.matrix[i][i] = 1.0;
            ++i;
        }
        return special;
    }

    public static Matrix unitMatrix(int numberOfRows) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        int i = 0;
        while (i < numberOfRows) {
            int j = 0;
            while (j < numberOfRows) {
                special.matrix[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        return special;
    }

    public static Matrix unitMatrix(int numberOfRows, int numberOfColumns) {
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        int i = 0;
        while (i < numberOfRows) {
            int j = 0;
            while (j < numberOfColumns) {
                special.matrix[i][j] = 1.0;
                ++j;
            }
            ++i;
        }
        return special;
    }

    public static Matrix scalarMatrix(int numberOfRows, double diagconst) {
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        double[][] specialArray = special.getArrayReference();
        int i = 0;
        while (i < numberOfRows) {
            int j = i;
            while (j < numberOfRows) {
                if (i == j) {
                    specialArray[i][j] = diagconst;
                }
                ++j;
            }
            ++i;
        }
        return special;
    }

    public static Matrix scalarMatrix(int numberOfRows, int numberOfColumns, double diagconst) {
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        double[][] specialArray = special.getArrayReference();
        int i = 0;
        while (i < numberOfRows) {
            int j = i;
            while (j < numberOfColumns) {
                if (i == j) {
                    specialArray[i][j] = diagconst;
                }
                ++j;
            }
            ++i;
        }
        return special;
    }

    public static Matrix diagonalMatrix(int numberOfRows, double[] diag) {
        if (diag.length != numberOfRows) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix special = new Matrix(numberOfRows, numberOfRows);
        double[][] specialArray = special.getArrayReference();
        int i = 0;
        while (i < numberOfRows) {
            specialArray[i][i] = diag[i];
            ++i;
        }
        return special;
    }

    public static Matrix diagonalMatrix(int numberOfRows, int numberOfColumns, double[] diag) {
        if (diag.length != numberOfRows) {
            throw new IllegalArgumentException("matrix dimension differs from diagonal array length");
        }
        Matrix special = new Matrix(numberOfRows, numberOfColumns);
        double[][] specialArray = special.getArrayReference();
        int i = 0;
        while (i < numberOfRows) {
            int j = i;
            while (j < numberOfColumns) {
                if (i == j) {
                    specialArray[i][j] = diag[i];
                }
                ++j;
            }
            ++i;
        }
        return special;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNrow() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNcol() {
        return this.numberOfColumns;
    }

    public double[][] getArrayReference() {
        return this.matrix;
    }

    public double[][] getArrayPointer() {
        return this.matrix;
    }

    public double[][] getArrayCopy() {
        double[][] c = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                c[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return c;
    }

    public double[] getRowCopy(int i) {
        if (i >= this.numberOfRows) {
            throw new IllegalArgumentException("Row index, " + i + ", must be less than the number of rows, " + this.numberOfRows);
        }
        if (i < 0) {
            throw new IllegalArgumentException("Row index, " + i + ", must be zero or positive");
        }
        return Conv.copy(this.matrix[i]);
    }

    public double[] getColumnCopy(int ii) {
        if (ii >= this.numberOfColumns) {
            throw new IllegalArgumentException("Column index, " + ii + ", must be less than the number of columns, " + this.numberOfColumns);
        }
        if (ii < 0) {
            throw new IllegalArgumentException("column index, " + ii + ", must be zero or positive");
        }
        double[] col = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            col[i] = this.matrix[i][ii];
            ++i;
        }
        return col;
    }

    public double getElement(int i, int j) {
        return this.matrix[i][j];
    }

    public double getElementCopy(int i, int j) {
        return this.matrix[i][j];
    }

    public double getElementPointer(int i, int j) {
        return this.matrix[i][j];
    }

    public Matrix getSubMatrix(int i, int j, int k, int l) {
        if (i > k) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (j > l) {
            throw new IllegalArgumentException("column indices inverted");
        }
        if (k >= this.numberOfRows) {
            throw new IllegalArgumentException("Sub-matrix position is outside the row bounds of this Matrix");
        }
        if (l >= this.numberOfColumns) {
            throw new IllegalArgumentException("Sub-matrix position is outside the column bounds of this Matrix" + i + " " + l);
        }
        int n = k - i + 1;
        int m = l - j + 1;
        Matrix subMatrix = new Matrix(n, m);
        double[][] sarray = subMatrix.getArrayReference();
        int p = 0;
        while (p < n) {
            int q = 0;
            while (q < m) {
                sarray[p][q] = this.matrix[i + p][j + q];
                ++q;
            }
            ++p;
        }
        return subMatrix;
    }

    public Matrix getSubMatrix(int[] row, int[] col) {
        int n = row.length;
        int m = col.length;
        Matrix subMatrix = new Matrix(n, m);
        double[][] sarray = subMatrix.getArrayReference();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                sarray[i][j] = this.matrix[row[i]][col[j]];
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    public int[] getIndexReference() {
        return this.permutationIndex;
    }

    public int[] getIndexPointer() {
        return this.permutationIndex;
    }

    public int[] getIndexCopy() {
        int[] indcopy = new int[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            indcopy[i] = this.permutationIndex[i];
            ++i;
        }
        return indcopy;
    }

    public double getSwap() {
        return this.rowSwapIndex;
    }

    public static Matrix copy(Matrix a) {
        if (a == null) {
            return null;
        }
        int nr = a.getNumberOfRows();
        int nc = a.getNumberOfColumns();
        double[][] aarray = a.getArrayReference();
        Matrix b = new Matrix(nr, nc);
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        double[][] barray = b.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = aarray[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.permutationIndex[i] = a.permutationIndex[i];
            ++i;
        }
        return b;
    }

    public Matrix copy() {
        if (this == null) {
            return null;
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix b = new Matrix(nr, nc);
        double[][] barray = b.getArrayReference();
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.permutationIndex[i] = this.permutationIndex[i];
            ++i;
        }
        return b;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix b = new Matrix(nr, nc);
        double[][] barray = b.getArrayReference();
        b.numberOfRows = nr;
        b.numberOfColumns = nc;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                barray[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nr) {
            b.permutationIndex[i] = this.permutationIndex[i];
            ++i;
        }
        return b;
    }

    public static Matrix columnMatrix(double[] darray) {
        int nr = darray.length;
        Matrix pp = new Matrix(nr, 1);
        int i = 0;
        while (i < nr) {
            pp.matrix[i][0] = darray[i];
            ++i;
        }
        return pp;
    }

    public static Matrix rowMatrix(double[] darray) {
        int nc = darray.length;
        Matrix pp = new Matrix(1, nc);
        int i = 0;
        while (i < nc) {
            pp.matrix[0][i] = darray[i];
            ++i;
        }
        return pp;
    }

    public Matrix plus(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j] + bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public Matrix plus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j] + bmat[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static Matrix plus(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.numberOfRows;
        int nc = amat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = amat.matrix[i][j] + bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void plusEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Matrix minus(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = this.numberOfRows;
        int nc = this.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j] - bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public Matrix minus(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = this.matrix[i][j] - bmat[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static Matrix minus(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = amat.numberOfRows;
        int nc = amat.numberOfColumns;
        Matrix cmat = new Matrix(nr, nc);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                carray[i][j] = amat.matrix[i][j] - bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void minusEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int nr = bmat.numberOfRows;
        int nc = bmat.numberOfColumns;
        int i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nc) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] - bmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Matrix times(Matrix bmat) {
        if (this.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < bmat.numberOfColumns) {
                sum2 = 0.0;
                int k = 0;
                while (k < this.numberOfColumns) {
                    sum2 += this.matrix[i][k] * bmat.matrix[k][j];
                    ++k;
                }
                carray[i][j] = sum2;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public Matrix times(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfColumns != nr) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, nc);
        double[][] carray = cmat.getArrayReference();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < nc) {
                sum2 = 0.0;
                int k = 0;
                while (k < this.numberOfColumns) {
                    sum2 += this.matrix[i][k] * bmat[k][j];
                    ++k;
                }
                carray[i][j] = sum2;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public Matrix times(double constant) {
        Matrix cmat = new Matrix(this.numberOfRows, this.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                carray[i][j] = this.matrix[i][j] * constant;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, Matrix bmat) {
        if (amat.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(amat.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum2 = 0.0;
        int i = 0;
        while (i < amat.numberOfRows) {
            int j = 0;
            while (j < bmat.numberOfColumns) {
                sum2 = 0.0;
                int k = 0;
                while (k < amat.numberOfColumns) {
                    sum2 += amat.matrix[i][k] * bmat.matrix[k][j];
                    ++k;
                }
                carray[i][j] = sum2;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, double[][] bmat) {
        if (amat.numberOfColumns != bmat.length) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(amat.numberOfRows, bmat[0].length);
        Matrix dmat = new Matrix(bmat);
        double[][] carray = cmat.getArrayReference();
        double sum2 = 0.0;
        int i = 0;
        while (i < amat.numberOfRows) {
            int j = 0;
            while (j < dmat.numberOfColumns) {
                sum2 = 0.0;
                int k = 0;
                while (k < amat.numberOfColumns) {
                    sum2 += amat.matrix[i][k] * dmat.matrix[k][j];
                    ++k;
                }
                carray[i][j] = sum2;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public static Matrix times(Matrix amat, double constant) {
        Matrix cmat = new Matrix(amat.numberOfRows, amat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        int i = 0;
        while (i < amat.numberOfRows) {
            int j = 0;
            while (j < amat.numberOfColumns) {
                carray[i][j] = amat.matrix[i][j] * constant;
                ++j;
            }
            ++i;
        }
        return cmat;
    }

    public void timesEquals(Matrix bmat) {
        int j;
        if (this.numberOfColumns != bmat.numberOfRows) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matrix cmat = new Matrix(this.numberOfRows, bmat.numberOfColumns);
        double[][] carray = cmat.getArrayReference();
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            j = 0;
            while (j < bmat.numberOfColumns) {
                sum2 = 0.0;
                int k = 0;
                while (k < this.numberOfColumns) {
                    sum2 += this.matrix[i][k] * bmat.matrix[k][j];
                    ++k;
                }
                carray[i][j] = sum2;
                ++j;
            }
            ++i;
        }
        this.numberOfRows = cmat.numberOfRows;
        this.numberOfColumns = cmat.numberOfColumns;
        i = 0;
        while (i < this.numberOfRows) {
            j = 0;
            while (j < this.numberOfColumns) {
                this.matrix[i][j] = cmat.matrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void timesEquals(double constant) {
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                double[] dArray = this.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * constant;
            }
            ++i;
        }
    }

    public Matrix over(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return this.times(bmat.inverse());
    }

    public Matrix over(Matrix amat, Matrix bmat) {
        if (amat.numberOfRows != bmat.numberOfRows || amat.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        return amat.times(bmat.inverse());
    }

    public Matrix over(double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (this.numberOfRows != nr || this.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        return this.times(cmat.inverse());
    }

    public Matrix over(Matrix amat, double[][] bmat) {
        int nr = bmat.length;
        int nc = bmat[0].length;
        if (amat.numberOfRows != nr || amat.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        return amat.times(cmat.inverse());
    }

    public Matrix over(double[][] amat, Matrix bmat) {
        int nr = amat.length;
        int nc = amat[0].length;
        if (bmat.numberOfRows != nr || bmat.numberOfColumns != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(amat);
        return cmat.times(bmat.inverse());
    }

    public Matrix over(double[][] amat, double[][] bmat) {
        int nr = amat.length;
        int nc = amat[0].length;
        if (bmat.length != nr || bmat[0].length != nc) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(amat);
        Matrix dmat = new Matrix(bmat);
        return cmat.times(dmat.inverse());
    }

    public void overEquals(Matrix bmat) {
        if (this.numberOfRows != bmat.numberOfRows || this.numberOfColumns != bmat.numberOfColumns) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        Matrix cmat = new Matrix(bmat);
        this.timesEquals(cmat.inverse());
    }

    public void overEquals(double[][] bmat) {
        Matrix pmat = new Matrix(bmat);
        this.overEquals(pmat);
    }

    public Matrix inverse() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix invmat = new Matrix(n, n);
        if (n == 1) {
            double[][] hold = this.getArrayCopy();
            if (hold[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = 1.0 / hold[0][0];
            invmat = new Matrix(hold);
        } else if (n == 2) {
            double[][] hold = this.getArrayCopy();
            double det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
            if (det == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] hold2 = new double[2][2];
            hold2[0][0] = hold[1][1] / det;
            hold2[1][1] = hold[0][0] / det;
            hold2[1][0] = -hold[1][0] / det;
            hold2[0][1] = -hold[0][1] / det;
            invmat = new Matrix(hold2);
        } else {
            double[] col = new double[n];
            double[] xvec = new double[n];
            double[][] invarray = invmat.getArrayReference();
            Matrix ludmat = this.luDecomp();
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    col[i] = 0.0;
                    ++i;
                }
                col[j] = 1.0;
                xvec = ludmat.luBackSub(col);
                i = 0;
                while (i < n) {
                    invarray[i][j] = xvec[i];
                    ++i;
                }
                ++j;
            }
        }
        return invmat;
    }

    public static Matrix inverse(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        Matrix invmat = new Matrix(n, n);
        if (n == 1) {
            double[][] hold = amat.getArrayCopy();
            if (hold[0][0] == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            hold[0][0] = 1.0 / hold[0][0];
            invmat = new Matrix(hold);
        } else if (n == 2) {
            double[][] hold = amat.getArrayCopy();
            double det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
            if (det == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            double[][] hold2 = new double[2][2];
            hold2[0][0] = hold[1][1] / det;
            hold2[1][1] = hold[0][0] / det;
            hold2[1][0] = -hold[1][0] / det;
            hold2[0][1] = -hold[0][1] / det;
            invmat = new Matrix(hold2);
        } else {
            double[] col = new double[n];
            double[] xvec = new double[n];
            double[][] invarray = invmat.getArrayReference();
            Matrix ludmat = amat.luDecomp();
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    col[i] = 0.0;
                    ++i;
                }
                col[j] = 1.0;
                xvec = ludmat.luBackSub(col);
                i = 0;
                while (i < n) {
                    invarray[i][j] = xvec[i];
                    ++i;
                }
                ++j;
            }
        }
        return invmat;
    }

    public Matrix transpose() {
        Matrix tmat = new Matrix(this.numberOfColumns, this.numberOfRows);
        double[][] tarray = tmat.getArrayReference();
        int i = 0;
        while (i < this.numberOfColumns) {
            int j = 0;
            while (j < this.numberOfRows) {
                tarray[i][j] = this.matrix[j][i];
                ++j;
            }
            ++i;
        }
        return tmat;
    }

    public static Matrix transpose(Matrix amat) {
        Matrix tmat = new Matrix(amat.numberOfColumns, amat.numberOfRows);
        double[][] tarray = tmat.getArrayReference();
        int i = 0;
        while (i < amat.numberOfColumns) {
            int j = 0;
            while (j < amat.numberOfRows) {
                tarray[i][j] = amat.matrix[j][i];
                ++j;
            }
            ++i;
        }
        return tmat;
    }

    public Matrix opposite() {
        Matrix opp = Matrix.copy(this);
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                opp.matrix[i][j] = -this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return opp;
    }

    public static Matrix opposite(Matrix amat) {
        Matrix opp = Matrix.copy(amat);
        int i = 0;
        while (i < amat.numberOfRows) {
            int j = 0;
            while (j < amat.numberOfColumns) {
                opp.matrix[i][j] = -amat.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return opp;
    }

    public double trace() {
        double trac = 0.0;
        int i = 0;
        while (i < Math.min(this.numberOfColumns, this.numberOfColumns)) {
            trac += this.matrix[i][i];
            ++i;
        }
        return trac;
    }

    public static double trace(Matrix amat) {
        double trac = 0.0;
        int i = 0;
        while (i < Math.min(amat.numberOfColumns, amat.numberOfColumns)) {
            trac += amat.matrix[i][i];
            ++i;
        }
        return trac;
    }

    public double determinant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        if (n == 2) {
            det = this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        } else {
            Matrix ludmat = this.luDecomp();
            det = ludmat.rowSwapIndex;
            int j = 0;
            while (j < n) {
                det *= ludmat.matrix[j][j];
                ++j;
            }
        }
        return det;
    }

    public static double determinant(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        if (n == 2) {
            double[][] hold = amat.getArrayCopy();
            det = hold[0][0] * hold[1][1] - hold[0][1] * hold[1][0];
        } else {
            Matrix ludmat = amat.luDecomp();
            det = ludmat.rowSwapIndex;
            int j = 0;
            while (j < n) {
                det *= ludmat.matrix[j][j];
                ++j;
            }
        }
        return det;
    }

    public static double determinant(double[][] mat) {
        int n = mat.length;
        int i = 0;
        while (i < n) {
            if (n != mat[i].length) {
                throw new IllegalArgumentException("Matrix is not square");
            }
            ++i;
        }
        double det = 0.0;
        if (n == 2) {
            det = mat[0][0] * mat[1][1] - mat[0][1] * mat[1][0];
        } else {
            Matrix amat = new Matrix(mat);
            Matrix ludmat = amat.luDecomp();
            det = ludmat.rowSwapIndex;
            int j = 0;
            while (j < n) {
                det *= ludmat.matrix[j][j];
                ++j;
            }
        }
        return det;
    }

    public double logDeterminant() {
        int n = this.numberOfRows;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        Matrix ludmat = this.luDecomp();
        det = ludmat.rowSwapIndex;
        det = Math.log(det);
        int j = 0;
        while (j < n) {
            det += Math.log(ludmat.matrix[j][j]);
            ++j;
        }
        return det;
    }

    public static double logDeterminant(Matrix amat) {
        int n = amat.numberOfRows;
        if (n != amat.numberOfColumns) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double det = 0.0;
        Matrix ludmat = amat.luDecomp();
        det = ludmat.rowSwapIndex;
        det = Math.log(det);
        int j = 0;
        while (j < n) {
            det += Math.log(ludmat.matrix[j][j]);
            ++j;
        }
        return det;
    }

    public static double logDeterminant(double[][] mat) {
        int n = mat.length;
        int i = 0;
        while (i < n) {
            if (n != mat[i].length) {
                throw new IllegalArgumentException("Matrix is not square");
            }
            ++i;
        }
        Matrix amat = new Matrix(mat);
        return amat.logDeterminant();
    }

    public Matrix cofactor() {
        double[][] cof = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                cof[i][j] = this.cofactor(i, j);
                ++j;
            }
            ++i;
        }
        return new Matrix(cof);
    }

    public double cofactor(int ii, int jj) {
        if (ii < 0 || ii >= this.numberOfRows) {
            throw new IllegalArgumentException("The entered row index, " + ii + " must lie between 0 and " + (this.numberOfRows - 1) + " inclusive");
        }
        if (jj < 0 || jj >= this.numberOfColumns) {
            throw new IllegalArgumentException("The entered column index, " + jj + " must lie between 0 and " + (this.numberOfColumns - 1) + " inclusive");
        }
        int[] rowi = new int[this.numberOfRows - 1];
        int[] colj = new int[this.numberOfColumns - 1];
        int kk = 0;
        int i = 0;
        while (i < this.numberOfRows) {
            if (i != ii) {
                rowi[kk] = i;
                ++kk;
            }
            ++i;
        }
        kk = 0;
        int j = 0;
        while (j < this.numberOfColumns) {
            if (j != jj) {
                colj[kk] = j;
                ++kk;
            }
            ++j;
        }
        Matrix aa = this.getSubMatrix(rowi, colj);
        double aadet = aa.determinant();
        return aadet * Math.pow(-1.0, ii + jj);
    }

    public Matrix reducedRowEchelonForm() {
        double[][] mat = new double[this.numberOfRows][this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                mat[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        int leadingCoeff = 0;
        int rowPointer = 0;
        boolean testOuter = true;
        while (testOuter) {
            int counter = rowPointer;
            boolean testInner = true;
            while (testInner && mat[counter][leadingCoeff] == 0.0) {
                if (++counter != this.numberOfRows) continue;
                counter = rowPointer;
                if (++leadingCoeff != this.numberOfColumns) continue;
                testInner = false;
            }
            if (testInner) {
                double[] temp = mat[rowPointer];
                mat[rowPointer] = mat[counter];
                mat[counter] = temp;
                double pivot = mat[rowPointer][leadingCoeff];
                int j = 0;
                while (j < this.numberOfColumns) {
                    double[] dArray = mat[rowPointer];
                    int n = j++;
                    dArray[n] = dArray[n] / pivot;
                }
                int i2 = 0;
                while (i2 < this.numberOfRows) {
                    if (i2 != rowPointer) {
                        pivot = mat[i2][leadingCoeff];
                        int j2 = 0;
                        while (j2 < this.numberOfColumns) {
                            double[] dArray = mat[i2];
                            int n = j2;
                            dArray[n] = dArray[n] - pivot * mat[rowPointer][j2];
                            ++j2;
                        }
                    }
                    ++i2;
                }
                if (++leadingCoeff >= this.numberOfColumns) {
                    testOuter = false;
                }
            }
            if (++rowPointer < this.numberOfRows && testInner) continue;
            testOuter = false;
        }
        int i3 = 0;
        while (i3 < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (mat[i3][j] == -0.0) {
                    mat[i3][j] = 0.0;
                }
                ++j;
            }
            ++i3;
        }
        return new Matrix(mat);
    }

    public double frobeniusNorm() {
        double norm = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                norm = Matrix.hypot(norm, Math.abs(this.matrix[i][j]));
                ++j;
            }
            ++i;
        }
        return norm;
    }

    public double oneNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.numberOfColumns) {
                sum2 += Math.abs(this.matrix[i][j]);
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public double infinityNorm() {
        double norm = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            sum2 = 0.0;
            int j = 0;
            while (j < this.numberOfColumns) {
                sum2 += Math.abs(this.matrix[i][j]);
                ++j;
            }
            norm = Math.max(norm, sum2);
            ++i;
        }
        return norm;
    }

    public double sum() {
        double sum2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                sum2 += this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sum2;
    }

    public double[] rowSums() {
        double[] sums = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            sums[i] = 0.0;
            int j = 0;
            while (j < this.numberOfColumns) {
                int n = i;
                sums[n] = sums[n] + this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sums;
    }

    public double[] columnSums() {
        double[] sums = new double[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            sums[i] = 0.0;
            int j = 0;
            while (j < this.numberOfRows) {
                int n = i;
                sums[n] = sums[n] + this.matrix[j][i];
                ++j;
            }
            ++i;
        }
        return sums;
    }

    public double mean() {
        double mean = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                mean += this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return mean /= (double)(this.numberOfRows * this.numberOfColumns);
    }

    public double[] rowMeans() {
        double[] means = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            means[i] = 0.0;
            int j = 0;
            while (j < this.numberOfColumns) {
                int n = i;
                means[n] = means[n] + this.matrix[i][j];
                ++j;
            }
            int n = i++;
            means[n] = means[n] / (double)this.numberOfColumns;
        }
        return means;
    }

    public double[] columnMeans() {
        double[] means = new double[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            means[i] = 0.0;
            int j = 0;
            while (j < this.numberOfRows) {
                int n = i;
                means[n] = means[n] + this.matrix[j][i];
                ++j;
            }
            int n = i++;
            means[n] = means[n] / (double)this.numberOfRows;
        }
        return means;
    }

    public Matrix subtractMean() {
        int j;
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        double mean = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            j = 0;
            while (j < this.numberOfColumns) {
                mean += this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        mean /= (double)(this.numberOfRows * this.numberOfColumns);
        i = 0;
        while (i < this.numberOfRows) {
            j = 0;
            while (j < this.numberOfColumns) {
                mat.matrix[i][j] = this.matrix[i][j] - mean;
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public Matrix subtractRowMeans() {
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        int i = 0;
        while (i < this.numberOfRows) {
            double mean = 0.0;
            int j = 0;
            while (j < this.numberOfColumns) {
                mean += this.matrix[i][j];
                ++j;
            }
            mean /= (double)this.numberOfColumns;
            j = 0;
            while (j < this.numberOfColumns) {
                mat.matrix[i][j] = this.matrix[i][j] - mean;
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public Matrix subtractColumnMeans() {
        Matrix mat = new Matrix(this.numberOfRows, this.numberOfColumns);
        int i = 0;
        while (i < this.numberOfColumns) {
            double mean = 0.0;
            int j = 0;
            while (j < this.numberOfRows) {
                mean += this.matrix[j][i];
                ++j;
            }
            mean /= (double)this.numberOfRows;
            j = 0;
            while (j < this.numberOfRows) {
                mat.matrix[j][i] = this.matrix[j][i] - mean;
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public double median() {
        Stat st = new Stat(this.matrix[0]);
        int i = 1;
        while (i < this.numberOfRows) {
            st.concatenate(this.matrix[i]);
            ++i;
        }
        return st.median();
    }

    public double[] rowMedians() {
        double[] medians = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            medians[i] = st.median();
            ++i;
        }
        return medians;
    }

    public double[] columnMedians() {
        double[] medians = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            medians[i] = st.median();
            ++i;
        }
        return medians;
    }

    public void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    public double variance() {
        Stat st = new Stat(this.matrix[0]);
        int i = 1;
        while (i < this.numberOfRows) {
            st.concatenate(this.matrix[i]);
            ++i;
        }
        return st.variance();
    }

    public double[] rowVariances() {
        double[] variances = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            variances[i] = st.variance();
            ++i;
        }
        return variances;
    }

    public double[] columnVariances() {
        double[] variances = new double[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            variances[i] = st.variance();
            ++i;
        }
        return variances;
    }

    public double standardDeviation() {
        Stat st = new Stat(this.matrix[0]);
        int i = 1;
        while (i < this.numberOfRows) {
            st.concatenate(this.matrix[i]);
            ++i;
        }
        return st.standardDeviation();
    }

    public double[] rowStandardDeviations() {
        double[] standardDeviations = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            standardDeviations[i] = st.standardDeviation();
            ++i;
        }
        return standardDeviations;
    }

    public double[] columnStandardDeviations() {
        double[] standardDeviations = new double[this.numberOfColumns];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            standardDeviations[i] = st.standardDeviation();
            ++i;
        }
        return standardDeviations;
    }

    public double stanadardError() {
        Stat st = new Stat(this.matrix[0]);
        int i = 1;
        while (i < this.numberOfRows) {
            st.concatenate(this.matrix[i]);
            ++i;
        }
        return st.standardError();
    }

    public double[] rowStandardErrors() {
        double[] standardErrors = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            standardErrors[i] = st.standardError();
            ++i;
        }
        return standardErrors;
    }

    public double[] columnStandardErrors() {
        double[] standardErrors = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            standardErrors[i] = st.standardError();
            ++i;
        }
        return standardErrors;
    }

    public double[] maximumElement() {
        double[] ret = new double[3];
        double[] holdD = new double[this.numberOfRows];
        ArrayMaths am = null;
        int[] holdI = new int[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            am = new ArrayMaths(this.matrix[i]);
            holdD[i] = am.maximum();
            holdI[i] = am.maximumIndex();
            ++i;
        }
        am = new ArrayMaths(holdD);
        ret[0] = am.maximum();
        int maxI = am.maximumIndex();
        ret[1] = maxI;
        ret[2] = holdI[maxI];
        return ret;
    }

    public double[] rowMaxima() {
        double[] maxima = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            maxima[i] = st.maximum();
            ++i;
        }
        return maxima;
    }

    public double[] columnMaxima() {
        double[] maxima = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            maxima[i] = st.maximum();
            ++i;
        }
        return maxima;
    }

    public double[] minimumElement() {
        double[] ret = new double[3];
        double[] holdD = new double[this.numberOfRows];
        ArrayMaths am = null;
        int[] holdI = new int[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            am = new ArrayMaths(this.matrix[i]);
            holdD[i] = am.minimum();
            holdI[i] = am.minimumIndex();
            ++i;
        }
        am = new ArrayMaths(holdD);
        ret[0] = am.minimum();
        int minI = am.minimumIndex();
        ret[1] = minI;
        ret[2] = holdI[minI];
        return ret;
    }

    public double[] rowMinima() {
        double[] minima = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            minima[i] = st.minimum();
            ++i;
        }
        return minima;
    }

    public double[] columnMinima() {
        double[] minima = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            minima[i] = st.minimum();
            ++i;
        }
        return minima;
    }

    public double range() {
        return this.maximumElement()[0] - this.minimumElement()[0];
    }

    public double[] rowRanges() {
        double[] ranges = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            Stat st = new Stat(this.matrix[i]);
            ranges[i] = st.maximum() - st.minimum();
            ++i;
        }
        return ranges;
    }

    public double[] columnRanges() {
        double[] ranges = new double[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfColumns) {
            double[] hold = new double[this.numberOfRows];
            int j = 0;
            while (j < this.numberOfRows) {
                hold[i] = this.matrix[j][i];
                ++j;
            }
            Stat st = new Stat(hold);
            ranges[i] = st.maximum() - st.minimum();
            ++i;
        }
        return ranges;
    }

    public int[] pivot() {
        double[] max2 = this.maximumElement();
        int maxI = (int)max2[1];
        int maxJ = (int)max2[2];
        double[] min2 = this.minimumElement();
        int minI = (int)min2[1];
        int minJ = (int)min2[2];
        if (Math.abs(min2[0]) > Math.abs(max2[0])) {
            maxI = minI;
            maxJ = minJ;
        }
        int[] ret = new int[]{maxI, maxJ};
        double[] hold1 = this.matrix[0];
        this.matrix[0] = this.matrix[maxI];
        this.matrix[maxI] = hold1;
        double hold2 = 0.0;
        int i = 0;
        while (i < this.numberOfRows) {
            hold2 = this.matrix[i][0];
            this.matrix[i][0] = this.matrix[i][maxJ];
            this.matrix[i][maxJ] = hold2;
            ++i;
        }
        return ret;
    }

    public boolean isSquare() {
        boolean test2 = false;
        if (this.numberOfRows == this.numberOfColumns) {
            test2 = true;
        }
        return test2;
    }

    public boolean isSymmetric() {
        boolean test2 = true;
        if (this.numberOfRows == this.numberOfColumns) {
            int i = 0;
            while (i < this.numberOfRows) {
                int j = i + 1;
                while (j < this.numberOfColumns) {
                    if (this.matrix[i][j] != this.matrix[j][i]) {
                        test2 = false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            test2 = false;
        }
        return test2;
    }

    public boolean isZero() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isUnit() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (this.matrix[i][j] != 1.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isDiagonal() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i != j && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isUpperTriagonal() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (j < i && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isLowerTriagonal() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i > j && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isTridiagonal() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i < j + 1 && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                if (j > i + 1 && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isUpperHessenberg() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (j < i + 1 && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isLowerHessenberg() {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i > j + 1 && this.matrix[i][j] != 0.0) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isIdentity() {
        boolean test2 = true;
        if (this.numberOfRows == this.numberOfColumns) {
            int i = 0;
            while (i < this.numberOfRows) {
                if (this.matrix[i][i] != 1.0) {
                    test2 = false;
                }
                int j = i + 1;
                while (j < this.numberOfColumns) {
                    if (this.matrix[i][j] != 0.0) {
                        test2 = false;
                    }
                    if (this.matrix[j][i] != 0.0) {
                        test2 = false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            test2 = false;
        }
        return test2;
    }

    public boolean isNearlySymmetric(double tolerance) {
        boolean test2 = true;
        if (this.numberOfRows == this.numberOfColumns) {
            int i = 0;
            while (i < this.numberOfRows) {
                int j = i + 1;
                while (j < this.numberOfColumns) {
                    if (Math.abs(this.matrix[i][j] - this.matrix[j][i]) > Math.abs(tolerance)) {
                        test2 = false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            test2 = false;
        }
        return test2;
    }

    public boolean isNearlyZero(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyUnit(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (Math.abs(this.matrix[i][j] - 1.0) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyUpperTriagonal(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (j < i && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyLowerTriagonal(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i > j && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyIdenty(double tolerance) {
        boolean test2 = true;
        if (this.numberOfRows == this.numberOfColumns) {
            int i = 0;
            while (i < this.numberOfRows) {
                if (Math.abs(this.matrix[i][i] - 1.0) > Math.abs(tolerance)) {
                    test2 = false;
                }
                int j = i + 1;
                while (j < this.numberOfColumns) {
                    if (Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                        test2 = false;
                    }
                    if (Math.abs(this.matrix[j][i]) > Math.abs(tolerance)) {
                        test2 = false;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            test2 = false;
        }
        return test2;
    }

    public boolean isTridiagonal(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i < j + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                if (j > i + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyTridiagonal(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i < j + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                if (j > i + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyUpperHessenberg(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (j < i + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isNearlyLowerHessenberg(double tolerance) {
        boolean test2 = true;
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                if (i > j + 1 && Math.abs(this.matrix[i][j]) > Math.abs(tolerance)) {
                    test2 = false;
                }
                ++j;
            }
            ++i;
        }
        return test2;
    }

    public boolean isSingular() {
        boolean test2 = false;
        double det = this.determinant();
        if (det == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public boolean isNearlySingular(double tolerance) {
        boolean test2 = false;
        double det = this.determinant();
        if (Math.abs(det) <= Math.abs(tolerance)) {
            test2 = true;
        }
        return test2;
    }

    public ArrayList<Integer> identicalRows() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nIdentical = 0;
        int i = 0;
        while (i < this.numberOfRows - 1) {
            int j = i + 1;
            while (j < this.numberOfRows) {
                int m = 0;
                int k = 0;
                while (k < this.numberOfColumns) {
                    if (this.matrix[i][k] == this.matrix[j][k]) {
                        ++m;
                    }
                    ++k;
                }
                if (m == this.numberOfColumns) {
                    ++nIdentical;
                    ret.add(new Integer(i));
                    ret.add(new Integer(j));
                }
                ++j;
            }
            ++i;
        }
        ret.add(0, new Integer(nIdentical));
        return ret;
    }

    public ArrayList<Integer> identicalColumns() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nIdentical = 0;
        int i = 0;
        while (i < this.numberOfColumns) {
            int j = i + 1;
            while (j < this.numberOfColumns - 1) {
                int m = 0;
                int k = 0;
                while (k < this.numberOfRows) {
                    if (this.matrix[k][i] == this.matrix[k][j]) {
                        ++m;
                    }
                    ++k;
                }
                if (m == this.numberOfRows) {
                    ++nIdentical;
                    ret.add(new Integer(i));
                    ret.add(new Integer(j));
                }
                ++j;
            }
            ++i;
        }
        ret.add(0, new Integer(nIdentical));
        return ret;
    }

    public ArrayList<Integer> zeroRows() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nZero = 0;
        int i = 0;
        while (i < this.numberOfRows) {
            int m = 0;
            int k = 0;
            while (k < this.numberOfColumns) {
                if (this.matrix[i][k] == 0.0) {
                    ++m;
                }
                ++k;
            }
            if (m == this.numberOfColumns) {
                ++nZero;
                ret.add(new Integer(i));
            }
            ++i;
        }
        ret.add(0, new Integer(nZero));
        return ret;
    }

    public ArrayList<Integer> zeroColumns() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int nZero = 0;
        int i = 0;
        while (i < this.numberOfColumns) {
            int m = 0;
            int k = 0;
            while (k < this.numberOfRows) {
                if (this.matrix[k][i] == 0.0) {
                    ++m;
                }
                ++k;
            }
            if (m == this.numberOfRows) {
                ++nZero;
                ret.add(new Integer(i));
            }
            ++i;
        }
        ret.add(0, new Integer(nZero));
        return ret;
    }

    public Matrix luDecomp() {
        int k;
        if (this.numberOfRows != this.numberOfColumns) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n = this.numberOfRows;
        int imax = 0;
        double dum = 0.0;
        double temp = 0.0;
        double big = 0.0;
        double[] vv = new double[n];
        double sum2 = 0.0;
        double dumm = 0.0;
        this.matrixCheck = true;
        Matrix ludmat = Matrix.copy(this);
        double[][] ludarray = ludmat.getArrayReference();
        ludmat.rowSwapIndex = 1.0;
        int i = 0;
        while (i < n) {
            big = 0.0;
            int j = 0;
            while (j < n) {
                double d;
                temp = Math.abs(ludarray[i][j]);
                if (d > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                if (!this.supressErrorMessage) {
                    System.out.println("Attempted LU Decomposition of a singular matrix in Matrix.luDecomp()");
                    System.out.println("NaN matrix returned and matrixCheck set to false");
                }
                this.matrixCheck = false;
                k = 0;
                while (k < n) {
                    int j2 = 0;
                    while (j2 < n) {
                        ludarray[k][j2] = Double.NaN;
                        ++j2;
                    }
                    ++k;
                }
                return ludmat;
            }
            vv[i] = 1.0 / big;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int k2;
            int i2 = 0;
            while (i2 < j) {
                sum2 = ludarray[i2][j];
                k2 = 0;
                while (k2 < i2) {
                    sum2 -= ludarray[i2][k2] * ludarray[k2][j];
                    ++k2;
                }
                ludarray[i2][j] = sum2;
                ++i2;
            }
            big = 0.0;
            i2 = j;
            while (i2 < n) {
                double d;
                sum2 = ludarray[i2][j];
                k2 = 0;
                while (k2 < j) {
                    sum2 -= ludarray[i2][k2] * ludarray[k2][j];
                    ++k2;
                }
                ludarray[i2][j] = sum2;
                dum = vv[i2] * Math.abs(sum2);
                if (d >= big) {
                    big = dum;
                    imax = i2;
                }
                ++i2;
            }
            if (j != imax) {
                k = 0;
                while (k < n) {
                    dumm = ludarray[imax][k];
                    ludarray[imax][k] = ludarray[j][k];
                    ludarray[j][k] = dumm;
                    ++k;
                }
                ludmat.rowSwapIndex = -ludmat.rowSwapIndex;
                vv[imax] = vv[j];
            }
            ludmat.permutationIndex[j] = imax;
            if (ludarray[j][j] == 0.0) {
                ludarray[j][j] = this.tiny;
            }
            if (j != n - 1) {
                dumm = 1.0 / ludarray[j][j];
                i2 = j + 1;
                while (i2 < n) {
                    double[] dArray = ludarray[i2];
                    int n2 = j;
                    dArray[n2] = dArray[n2] * dumm;
                    ++i2;
                }
            }
            ++j;
        }
        return ludmat;
    }

    public double[] luBackSub(double[] bvec) {
        int j;
        int ii = 0;
        int ip = 0;
        int n = bvec.length;
        if (n != this.numberOfColumns) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.numberOfColumns != this.numberOfRows) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double sum2 = 0.0;
        double[] xvec = new double[n];
        int i = 0;
        while (i < n) {
            xvec[i] = bvec[i];
            ++i;
        }
        i = 0;
        while (i < n) {
            ip = this.permutationIndex[i];
            sum2 = xvec[ip];
            xvec[ip] = xvec[i];
            if (ii == 0) {
                j = ii;
                while (j <= i - 1) {
                    sum2 -= this.matrix[i][j] * xvec[j];
                    ++j;
                }
            } else if (sum2 == 0.0) {
                ii = i;
            }
            xvec[i] = sum2;
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            sum2 = xvec[i];
            j = i + 1;
            while (j < n) {
                sum2 -= this.matrix[i][j] * xvec[j];
                ++j;
            }
            xvec[i] = sum2 / this.matrix[i][i];
            --i;
        }
        return xvec;
    }

    public double[] solveLinearSet(double[] bvec) {
        double[] xvec = null;
        if (this.numberOfRows == this.numberOfColumns) {
            Matrix ludmat = this.luDecomp();
            xvec = ludmat.luBackSub(bvec);
        } else if (this.numberOfRows > this.numberOfColumns) {
            int n = bvec.length;
            if (this.numberOfRows != n) {
                throw new IllegalArgumentException("Overdetermined equation solution - vector length is not equal to matrix column length");
            }
            Matrix avecT = this.transpose();
            double[][] avec = avecT.getArrayCopy();
            Regression reg = new Regression(avec, bvec);
            reg.linearGeneral();
            xvec = reg.getCoeff();
        } else {
            throw new IllegalArgumentException("This class does not handle underdetermined equations");
        }
        return xvec;
    }

    public void supressErrorMessage() {
        this.supressErrorMessage = true;
    }

    public void hessenbergMatrix() {
        int j;
        this.hessenberg = this.getArrayCopy();
        double pivot = 0.0;
        int pivotIndex = 0;
        double hold = 0.0;
        int i = 1;
        while (i < this.numberOfRows - 1) {
            pivot = 0.0;
            pivotIndex = i;
            j = i;
            while (j < this.numberOfRows) {
                if (Math.abs(this.hessenberg[j][i - 1]) > Math.abs(pivot)) {
                    pivot = this.hessenberg[j][i - 1];
                    pivotIndex = j;
                }
                ++j;
            }
            if (pivotIndex != i) {
                j = i - 1;
                while (j < this.numberOfRows) {
                    hold = this.hessenberg[pivotIndex][j];
                    this.hessenberg[pivotIndex][j] = this.hessenberg[i][j];
                    this.hessenberg[i][j] = hold;
                    ++j;
                }
                j = 0;
                while (j < this.numberOfRows) {
                    hold = this.hessenberg[j][pivotIndex];
                    this.hessenberg[j][pivotIndex] = this.hessenberg[j][i];
                    this.hessenberg[j][i] = hold;
                    ++j;
                }
                if (pivot != 0.0) {
                    j = i + 1;
                    while (j < this.numberOfRows) {
                        hold = this.hessenberg[j][i - 1];
                        if (hold != 0.0) {
                            this.hessenberg[j][i - 1] = hold /= pivot;
                            int k = i;
                            while (k < this.numberOfRows) {
                                double[] dArray = this.hessenberg[j];
                                int n = k;
                                dArray[n] = dArray[n] - hold * this.hessenberg[i][k];
                                ++k;
                            }
                            k = 0;
                            while (k < this.numberOfRows) {
                                double[] dArray = this.hessenberg[k];
                                int n = i;
                                dArray[n] = dArray[n] + hold * this.hessenberg[k][j];
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 2;
        while (i < this.numberOfRows) {
            j = 0;
            while (j < i - 1) {
                this.hessenberg[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.hessenbergDone = true;
    }

    public double[][] getHessenbergMatrix() {
        if (!this.hessenbergDone) {
            this.hessenbergMatrix();
        }
        return this.hessenberg;
    }

    public double[] getEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenValues;
    }

    public double[] getSortedEigenValues() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenValues;
    }

    public double[][] getEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenVector;
    }

    public double[][] getEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] ret = new double[this.numberOfRows][this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfRows) {
                ret[i][j] = this.eigenVector[j][i];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][] getSortedEigenVectorsAsColumns() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVector() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.sortedEigenVector;
    }

    public double[][] getSortedEigenVectorsAsRows() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        double[][] ret = new double[this.numberOfRows][this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfRows) {
                ret[i][j] = this.sortedEigenVector[j][i];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int getNumberOfJacobiRotations() {
        return this.numberOfRotations;
    }

    private void symmetricEigen() {
        if (!this.isSymmetric()) {
            throw new IllegalArgumentException("matrix is not symmetric");
        }
        double[][] amat = this.getArrayCopy();
        this.eigenVector = new double[this.numberOfRows][this.numberOfRows];
        this.eigenValues = new double[this.numberOfRows];
        double threshold = 0.0;
        double cot2rotationAngle = 0.0;
        double tanHalfRotationAngle = 0.0;
        double offDiagonalSum = 0.0;
        double scaledOffDiagonal = 0.0;
        double sElement = 0.0;
        double cElement = 0.0;
        double sOverC = 0.0;
        double vectorDifference = 0.0;
        double[] holdingVector1 = new double[this.numberOfRows];
        double[] holdingVector2 = new double[this.numberOfRows];
        int p = 0;
        while (p < this.numberOfRows) {
            int q = 0;
            while (q < this.numberOfRows) {
                this.eigenVector[p][q] = 0.0;
                ++q;
            }
            this.eigenVector[p][p] = 1.0;
            ++p;
        }
        p = 0;
        while (p < this.numberOfRows) {
            holdingVector1[p] = amat[p][p];
            this.eigenValues[p] = amat[p][p];
            holdingVector2[p] = 0.0;
            ++p;
        }
        this.numberOfRotations = 0;
        int i = 1;
        while (i <= this.maximumJacobiIterations) {
            int q;
            offDiagonalSum = 0.0;
            int p2 = 0;
            while (p2 < this.numberOfRows - 1) {
                q = p2 + 1;
                while (q < this.numberOfRows) {
                    offDiagonalSum += Math.abs(amat[p2][q]);
                    ++q;
                }
                ++p2;
            }
            if (offDiagonalSum == 0.0) {
                this.eigenDone = true;
                this.eigenSort();
                return;
            }
            threshold = i < 4 ? 0.2 * offDiagonalSum / (double)(this.numberOfRows * this.numberOfRows) : 0.0;
            p2 = 0;
            while (p2 < this.numberOfRows - 1) {
                q = p2 + 1;
                while (q < this.numberOfRows) {
                    scaledOffDiagonal = 100.0 * Math.abs(amat[p2][q]);
                    if (i > 4 && Math.abs(this.eigenValues[p2]) + scaledOffDiagonal == Math.abs(this.eigenValues[p2]) && Math.abs(this.eigenValues[q]) + scaledOffDiagonal == Math.abs(this.eigenValues[q])) {
                        amat[p2][q] = 0.0;
                    } else if (Math.abs(amat[p2][q]) > threshold) {
                        vectorDifference = this.eigenValues[q] - this.eigenValues[p2];
                        if (Math.abs(vectorDifference) + scaledOffDiagonal == Math.abs(vectorDifference)) {
                            sOverC = amat[p2][q] / vectorDifference;
                        } else {
                            cot2rotationAngle = 0.5 * vectorDifference / amat[p2][q];
                            sOverC = 1.0 / (Math.abs(cot2rotationAngle) + Math.sqrt(1.0 + cot2rotationAngle * cot2rotationAngle));
                            if (cot2rotationAngle < 0.0) {
                                sOverC = -sOverC;
                            }
                        }
                        cElement = 1.0 / Math.sqrt(1.0 + sOverC * sOverC);
                        sElement = sOverC * cElement;
                        tanHalfRotationAngle = sElement / (1.0 + cElement);
                        vectorDifference = sOverC * amat[p2][q];
                        int n = p2;
                        holdingVector2[n] = holdingVector2[n] - vectorDifference;
                        int n2 = q;
                        holdingVector2[n2] = holdingVector2[n2] + vectorDifference;
                        int n3 = p2;
                        this.eigenValues[n3] = this.eigenValues[n3] - vectorDifference;
                        int n4 = q;
                        this.eigenValues[n4] = this.eigenValues[n4] + vectorDifference;
                        amat[p2][q] = 0.0;
                        int j = 0;
                        while (j <= p2 - 1) {
                            this.rotation(amat, tanHalfRotationAngle, sElement, j, p2, j, q);
                            ++j;
                        }
                        j = p2 + 1;
                        while (j <= q - 1) {
                            this.rotation(amat, tanHalfRotationAngle, sElement, p2, j, j, q);
                            ++j;
                        }
                        j = q + 1;
                        while (j < this.numberOfRows) {
                            this.rotation(amat, tanHalfRotationAngle, sElement, p2, j, q, j);
                            ++j;
                        }
                        j = 0;
                        while (j < this.numberOfRows) {
                            this.rotation(this.eigenVector, tanHalfRotationAngle, sElement, j, p2, j, q);
                            ++j;
                        }
                        ++this.numberOfRotations;
                    }
                    ++q;
                }
                ++p2;
            }
            p2 = 0;
            while (p2 < this.numberOfRows) {
                int n = p2;
                holdingVector1[n] = holdingVector1[n] + holdingVector2[p2];
                this.eigenValues[p2] = holdingVector1[p2];
                holdingVector2[p2] = 0.0;
                ++p2;
            }
            ++i;
        }
        System.out.println("Maximum iterations, " + this.maximumJacobiIterations + ", reached - values at this point returned");
        this.eigenDone = true;
        this.eigenSort();
    }

    private void rotation(double[][] a, double tau, double sElement, int i, int j, int k, int l) {
        double aHold1 = a[i][j];
        double aHold2 = a[k][l];
        a[i][j] = aHold1 - sElement * (aHold2 + aHold1 * tau);
        a[k][l] = aHold2 + sElement * (aHold1 - aHold2 * tau);
    }

    private void eigenSort() {
        int k = 0;
        this.sortedEigenValues = Conv.copy(this.eigenValues);
        this.sortedEigenVector = Conv.copy(this.eigenVector);
        this.eigenIndices = new int[this.numberOfRows];
        int i = 0;
        while (i < this.numberOfRows - 1) {
            double holdingElement = this.sortedEigenValues[i];
            k = i;
            int j = i + 1;
            while (j < this.numberOfRows) {
                if (this.sortedEigenValues[j] >= holdingElement) {
                    holdingElement = this.sortedEigenValues[j];
                    k = j;
                }
                ++j;
            }
            if (k != i) {
                this.sortedEigenValues[k] = this.sortedEigenValues[i];
                this.sortedEigenValues[i] = holdingElement;
                j = 0;
                while (j < this.numberOfRows) {
                    holdingElement = this.sortedEigenVector[j][i];
                    this.sortedEigenVector[j][i] = this.sortedEigenVector[j][k];
                    this.sortedEigenVector[j][k] = holdingElement;
                    ++j;
                }
            }
            ++i;
        }
        this.eigenIndices = new int[this.numberOfRows];
        i = 0;
        while (i < this.numberOfRows) {
            boolean test2 = true;
            int j = 0;
            while (test2) {
                if (this.sortedEigenValues[i] == this.eigenValues[j]) {
                    this.eigenIndices[i] = j;
                    test2 = false;
                    continue;
                }
                ++j;
            }
            ++i;
        }
    }

    public int[] eigenValueIndices() {
        if (!this.eigenDone) {
            this.symmetricEigen();
        }
        return this.eigenIndices;
    }

    private static double hypot(double aa, double bb) {
        double cc = 0.0;
        double ratio = 0.0;
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod <= bmod) {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }
}

