/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class FileTypeFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable<String, FileTypeFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public FileTypeFilter() {
    }

    public FileTypeFilter(String extension) {
        this(extension, null);
    }

    public FileTypeFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public FileTypeFilter(String[] filters) {
        this(filters, null);
    }

    public FileTypeFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f2) {
        if (f2 != null) {
            if (f2.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f2);
            if (extension != null && this.filters.get(this.getExtension(f2)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f2) {
        String filename;
        int i;
        if (f2 != null && (i = (filename = f2.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : String.valueOf(this.description) + " (";
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", ." + extensions.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

