/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class TriCubicSpline {
    private int nPoints = 0;
    private int mPoints = 0;
    private int lPoints = 0;
    private double[][][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] x3 = null;
    private double[] xMin = new double[3];
    private double[] xMax = new double[3];
    private BiCubicSpline[] bcsn = null;
    private CubicSpline csm = null;
    private double[][][] d2ydx2inner = null;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public TriCubicSpline(double[] x1, double[] x2, double[] x3, double[][][] y) {
        this.nPoints = x1.length;
        this.mPoints = x2.length;
        this.lPoints = x3.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + y.length);
        }
        if (this.mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + y[0].length);
        }
        if (this.lPoints != y[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y-column are of different length " + this.mPoints + " " + y[0][0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3) {
            throw new IllegalArgumentException("The tabulated 3D array must have a minimum size of 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints];
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        int j = 0;
        while (j < this.mPoints) {
            this.x2[j] = x2[j];
            ++j;
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        j = 0;
        while (j < this.lPoints) {
            this.x3[j] = x3[j];
            ++j;
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        i = 0;
        while (i < this.nPoints) {
            int j2 = 0;
            while (j2 < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    this.y[i][j2][k] = y[i][j2][k];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        double[][] yTempml = new double[this.mPoints][this.lPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j3 = 0;
            while (j3 < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    yTempml[j3][k] = y[i2][j3][k];
                    ++k;
                }
                ++j3;
            }
            this.bcsn[i2].resetData(x2, x3, yTempml);
            this.d2ydx2inner[i2] = this.bcsn[i2].getDeriv();
            ++i2;
        }
        this.derivCalculated = true;
    }

    public TriCubicSpline(int nP, int mP, int lP) {
        this.nPoints = nP;
        this.mPoints = mP;
        this.lPoints = lP;
        if (this.nPoints < 3 || this.mPoints < 3 || this.lPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.lPoints];
        this.y = new double[this.nPoints][this.mPoints][this.lPoints];
        this.d2ydx2inner = new double[this.nPoints][this.mPoints][this.lPoints];
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        TriCubicSpline.potentialRoundingError = potentialRoundingError;
        BiCubicSpline.potentialRoundingError(potentialRoundingError);
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        int i = 0;
        while (i < this.bcsn.length) {
            this.bcsn[i].averageIdenticalAbscissae();
            ++i;
        }
        CubicSpline.averageIdenticalAbscissae();
    }

    public static TriCubicSpline zero(int nP, int mP, int lP) {
        if (nP < 3 || mP < 3 || lP < 3) {
            throw new IllegalArgumentException("A minimum of three x three x three data points is needed");
        }
        TriCubicSpline aa = new TriCubicSpline(nP, mP, lP);
        return aa;
    }

    public static TriCubicSpline[] oneDarray(int nP, int mP, int lP, int kP) {
        if (mP < 3 || lP < 3 || kP < 3) {
            throw new IllegalArgumentException("A minimum of three x three x three data points is needed");
        }
        TriCubicSpline[] a = new TriCubicSpline[nP];
        int i = 0;
        while (i < nP) {
            a[i] = TriCubicSpline.zero(mP, lP, kP);
            ++i;
        }
        return a;
    }

    public void resetData(double[] x1, double[] x2, double[] x3, double[][][] y) {
        if (x1.length != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y row are of different length");
        }
        if (x2.length != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y column are of different length");
        }
        if (x3.length != y[0][0].length) {
            throw new IllegalArgumentException("Arrays x3 and y column are of different length");
        }
        if (this.nPoints != x1.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.mPoints != x2.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        if (this.lPoints != x3.length) {
            throw new IllegalArgumentException("Original array length not matched by new array length");
        }
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        i = 0;
        while (i < this.mPoints) {
            this.x2[i] = x2[i];
            ++i;
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        i = 0;
        while (i < this.lPoints) {
            this.x3[i] = x3[i];
            ++i;
        }
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        i = 0;
        while (i < this.nPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    this.y[i][j][k] = y[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.csm = new CubicSpline(this.nPoints);
        this.bcsn = BiCubicSpline.oneDarray(this.nPoints, this.mPoints, this.lPoints);
        double[][] yTempml = new double[this.mPoints][this.lPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.lPoints) {
                    yTempml[j][k] = y[i2][j][k];
                    ++k;
                }
                ++j;
            }
            this.bcsn[i2].resetData(x2, x3, yTempml);
            this.d2ydx2inner[i2] = this.bcsn[i2].getDeriv();
            ++i2;
        }
        this.derivCalculated = true;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        int i = 0;
        while (i < 3) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
            ++i;
        }
        System.out.println(" ");
    }

    public double interpolate(double xx1, double xx2, double xx3) {
        double[] yTempm = new double[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            yTempm[i] = this.bcsn[i].interpolate(xx2, xx3);
            ++i;
        }
        this.csm.resetData(this.x1, yTempm);
        return this.csm.interpolate(xx1);
    }

    public double[][][] getDeriv() {
        return this.d2ydx2inner;
    }

    public void setDeriv(double[][][] d2ydx2) {
        this.d2ydx2inner = d2ydx2;
        this.derivCalculated = true;
    }
}

