/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;

class GumbelFunction
implements RegressionFunction {
    public boolean scaleOption = true;
    public double scaleFactor = 1.0;
    public int typeFlag = 0;

    GumbelFunction() {
    }

    @Override
    public double function(double[] p, double[] x2) {
        double y = 0.0;
        double arg = 0.0;
        double yScale = this.scaleFactor;
        switch (this.typeFlag) {
            case 0: {
                arg = (x2[0] - p[0]) / p[1];
                if (this.scaleOption) {
                    yScale = p[2];
                }
                y = yScale / p[1] * Math.exp(arg) * Math.exp(-Math.exp(arg));
                break;
            }
            case 1: {
                arg = (p[0] - x2[0]) / p[1];
                if (this.scaleOption) {
                    yScale = p[2];
                }
                y = yScale / p[1] * Math.exp(arg) * Math.exp(-Math.exp(arg));
                break;
            }
            case 2: {
                arg = x2[0] / p[0];
                if (this.scaleOption) {
                    yScale = p[1];
                }
                y = yScale / p[0] * Math.exp(arg) * Math.exp(-Math.exp(arg));
                break;
            }
            case 3: {
                arg = -x2[0] / p[0];
                if (this.scaleOption) {
                    yScale = p[1];
                }
                y = yScale / p[0] * Math.exp(arg) * Math.exp(-Math.exp(arg));
                break;
            }
            case 4: {
                if (this.scaleOption) {
                    yScale = p[0];
                }
                y = yScale * Math.exp(x2[0]) * Math.exp(-Math.exp(x2[0]));
                break;
            }
            case 5: {
                if (this.scaleOption) {
                    yScale = p[0];
                }
                y = yScale * Math.exp(-x2[0]) * Math.exp(-Math.exp(-x2[0]));
            }
        }
        return y;
    }
}

