/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import java.text.DateFormat;
import java.util.Date;

public class Cronbach
extends Scores {
    private double rawAlpha = Double.NaN;
    private boolean rawAlphaCalculated = false;
    private double standardizedAlpha = Double.NaN;
    private boolean standardizedAlphaCalculated = false;
    private int deletedItemIndex = -1;
    private String deletedFilename = null;

    public double rawAlpha() {
        if (!this.rawAlphaCalculated) {
            if (this.nItems == 1) {
                System.out.println("Method rawAlpha: only one item - alpha cannot be calculated - NaN returned");
                this.rawAlpha = Double.NaN;
            } else {
                if (!this.dataPreprocessed) {
                    this.preprocessData();
                }
                double rawAllResponsesTotalAllSquared = this.rawAllResponsesTotal * this.rawAllResponsesTotal;
                double sumOfEachScoreSquared = 0.0;
                int i = 0;
                while (i < this.nItems) {
                    int j = 0;
                    while (j < this.nPersons) {
                        sumOfEachScoreSquared += this.scores1[j][i] * this.scores1[j][i];
                        ++j;
                    }
                    ++i;
                }
                double reducedItemTotalsSquared = 0.0;
                int i2 = 0;
                while (i2 < this.nItems) {
                    reducedItemTotalsSquared += this.rawItemTotals[i2] * this.rawItemTotals[i2] / (double)this.nPersons;
                    ++i2;
                }
                double reducedPersonTotalsSquared = 0.0;
                int i3 = 0;
                while (i3 < this.nPersons) {
                    reducedPersonTotalsSquared += this.rawPersonTotals[i3] * this.rawPersonTotals[i3] / (double)this.nItems;
                    ++i3;
                }
                double sumOfSquaresWithinPersons = reducedPersonTotalsSquared - rawAllResponsesTotalAllSquared / (double)this.nScores;
                double sumOfSquareErrors = sumOfEachScoreSquared - reducedItemTotalsSquared - reducedPersonTotalsSquared + rawAllResponsesTotalAllSquared / (double)this.nScores;
                int dfItems = this.nItems - 1;
                int dfPersons = this.nPersons - 1;
                int dfErrors = dfItems * dfPersons;
                double reducedSquarePersons = sumOfSquaresWithinPersons / (double)dfPersons;
                double reducedSquareErrors = sumOfSquareErrors / (double)dfErrors;
                this.rawAlpha = (reducedSquarePersons - reducedSquareErrors) / reducedSquarePersons;
                this.rawAlphaCalculated = true;
            }
        }
        return this.rawAlpha;
    }

    public double standardizedAlpha() {
        if (!this.standardizedAlphaCalculated) {
            if (this.nItems == 1) {
                System.out.println("Method standardizedAlpha: only one item - alpha cannot be calculated - NaN returned");
                this.rawAlpha = Double.NaN;
            } else {
                if (!this.dataPreprocessed) {
                    this.preprocessData();
                }
                if (!this.covariancesCalculated) {
                    this.covariancesAndCorrelationCoefficients();
                }
                this.standardizedAlpha = (double)this.nItems * this.rawMeanRhoWithoutTotals / (1.0 + (double)(this.nItems - 1) * this.rawMeanRhoWithoutTotals);
                this.standardizedAlphaCalculated = true;
            }
        }
        return this.standardizedAlpha;
    }

    public double standardisedAlpha() {
        return this.standardizedAlpha();
    }

    public void analysis() {
        this.outputFilename = "CronbachOutput";
        this.outputFilename = this.fileOption == 1 ? String.valueOf(this.outputFilename) + ".txt" : String.valueOf(this.outputFilename) + ".xls";
        String message1 = "Output file name for the analysis details:";
        String message2 = "\nEnter the required name (as a single word) and click OK ";
        String message3 = "\nor simply click OK for default value";
        String message = String.valueOf(message1) + message2 + message3;
        String defaultName = this.outputFilename;
        this.outputFilename = Db.readLine(message, defaultName);
        this.analysis(this.outputFilename);
    }

    public void analysis(String filename) {
        this.outputFilename = filename;
        String outputFilenameWithoutExtension = null;
        String extension = null;
        int pos = filename.indexOf(46);
        if (pos == -1) {
            outputFilenameWithoutExtension = filename;
            this.outputFilename = this.fileOption == 1 ? String.valueOf(this.outputFilename) + ".txt" : String.valueOf(this.outputFilename) + ".xls";
        } else {
            int opt2;
            int defaultBox;
            String[] boxTitles;
            String[] comments;
            String message;
            String headerComment;
            String message2;
            String message1;
            extension = filename.substring(pos).trim();
            outputFilenameWithoutExtension = filename.substring(0, pos).trim();
            if (extension.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .xls";
                    message2 = "\nbut you have chosen a .txt output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .txt [text file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".txt"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (extension.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .txt";
                    message2 = "\nbut you have chosen a .xls output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .xls [Excel file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".xls"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!extension.equalsIgnoreCase(".txt") && !extension.equalsIgnoreCase(".xls")) {
                message1 = "Your extension is " + extension;
                message2 = "\n    Do you wish to retain it:";
                message = String.valueOf(message1) + message2;
                headerComment = "Your output file name extension";
                comments = new String[]{message, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                boxTitles = new String[]{"Retain", ".txt", ".xls"};
                defaultBox = 1;
                opt2 = Db.optionBox(headerComment, comments, boxTitles, defaultBox);
                switch (opt2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (this.fileOption == 1) {
            this.analysisText();
        } else {
            this.analysisExcel();
        }
    }

    private void analysisExcel() {
        int j;
        int j2;
        int i;
        FileOutput fout = null;
        fout = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.rawAlphaCalculated) {
            this.rawAlpha();
        }
        if (!this.standardizedAlphaCalculated) {
            this.standardizedAlpha();
        }
        fout.println("CRONBACH'S ALPHA RELIABILITY ESTIMATOR");
        fout.println("Program: Cronbach - Analysis Output");
        int i2 = 0;
        while (i2 < this.titleLines) {
            fout.println(this.title[i2]);
            ++i2;
        }
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        fout.println("RELIABILITY ESTIMATORS");
        fout.println("Cronbach's coefficient alpha");
        fout.printtab("Raw data                  ");
        fout.println(Fmath.truncate(this.rawAlpha, this.trunc));
        fout.printtab("Standardized data           ");
        fout.println(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fout.println();
        fout.println("Average of the inter-item correlation coefficients, excluding item totals");
        fout.printtab("Raw data                  ");
        fout.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fout.printtab("Standardized data           ");
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fout.println();
        fout.println("Average of the inter-item correlation coefficients, including item totals");
        fout.printtab("Raw data                  ");
        fout.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fout.printtab("Standardized data           ");
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.println();
        fout.println("'NO RESPONSE' DELETIONS AND REPLACEMENTS");
        boolean deletionFlag = false;
        if (this.nDeletedPersons != 0) {
            deletionFlag = true;
            fout.printtab("Number of persons deleted ");
            fout.println(this.nDeletedPersons);
            fout.printtab("Indices of deleted persons: ");
            i = 0;
            while (i < this.nDeletedPersons) {
                fout.printtab(this.deletedPersonsIndices[i] + 1);
                ++i;
            }
            fout.println();
        } else {
            fout.println("No persons were deleted ");
        }
        if (this.nDeletedItems != 0) {
            deletionFlag = true;
            fout.printtab("Number of items deleted ");
            fout.println(this.nDeletedItems);
            fout.printtab("Names of deleted items: ");
            i = 0;
            while (i < this.nDeletedItems) {
                fout.printtab(this.originalItemNames[this.deletedItemsIndices[i]]);
                ++i;
            }
            fout.println();
        } else {
            fout.println("No items were deleted ");
        }
        if (this.nReplacements != 0) {
            fout.printtab("Number of 'no responses' replaced ");
            fout.println(this.nReplacements);
            fout.printtab("Item name and person index of replacements: ");
            i = 0;
            while (i < this.nReplacements) {
                fout.printtab(String.valueOf(this.replacementIndices[i]) + " ");
                ++i;
            }
            fout.println();
            fout.printtab("Replacement option: ");
            fout.println(this.replacementOptionNames[this.replacementOption - 1]);
            fout.println();
        } else if (deletionFlag) {
            fout.println("No 'no response' replacements, other than any above deletions, were made ");
        } else {
            fout.println("No 'no response' replacements were made ");
        }
        fout.println();
        fout.printtab("Number of items used         ");
        fout.println(this.nItems);
        fout.printtab("Number of persons used   ");
        fout.println(this.nPersons);
        fout.println();
        fout.println("CORRELATION COEFFICIENTS");
        fout.println("Correlation coefficients between items  -  raw data");
        fout.printtab("    ");
        i = 0;
        while (i <= this.nItems) {
            fout.printtab(this.itemNames[i]);
            ++i;
        }
        fout.println();
        i = 0;
        while (i <= this.nItems) {
            fout.printtab(this.itemNames[i]);
            j2 = 0;
            while (j2 <= this.nItems) {
                fout.printtab(Fmath.truncate(this.rawCorrelationCoefficients[i][j2], this.trunc));
                ++j2;
            }
            fout.println();
            ++i;
        }
        fout.println();
        fout.print("Average inter-item correlation coefficient (excluding total)                    ");
        fout.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (excluding total)  ");
        fout.println(Fmath.truncate(this.rawStandardDeviationRhoWithoutTotals, this.trunc));
        fout.print("Average inter-item correlation coefficient (including total)                    ");
        fout.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (including total)  ");
        fout.println(Fmath.truncate(this.rawStandardDeviationRhoWithTotals, this.trunc));
        fout.println();
        fout.println("Correlation coefficients between items  -  standardized data");
        fout.printtab("    ");
        i = 0;
        while (i <= this.nItems) {
            fout.printtab(this.itemNames[i]);
            ++i;
        }
        fout.println();
        i = 0;
        while (i <= this.nItems) {
            fout.printtab(this.itemNames[i]);
            j2 = 0;
            while (j2 <= this.nItems) {
                fout.printtab(Fmath.truncate(this.standardizedCorrelationCoefficients[i][j2], this.trunc));
                ++j2;
            }
            fout.println();
            ++i;
        }
        fout.println();
        fout.print("Average inter-item correlation coefficient (excluding total)                    ");
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (excluding total)  ");
        fout.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithoutTotals, this.trunc));
        fout.print("Average inter-item correlation coefficient (including total)                    ");
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (including total)  ");
        fout.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithTotals, this.trunc));
        fout.println();
        fout.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fout.println("Raw data");
        fout.printtab("item ");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("moment");
        fout.printtab("median");
        fout.printtab("quartile");
        fout.printtab("kurtosis");
        fout.println("dichotomous");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.printtab("excess  ");
        fout.println("percentage");
        i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            fout.printtab(Fmath.truncate(this.rawItemMeans[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemStandardDeviations[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemMomentSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemMedianSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemQuartileSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemKurtosisExcess[i], this.trunc));
            fout.println(Fmath.truncate(this.dichotomousPercentage[i], 1));
            ++i;
        }
        fout.println();
        fout.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fout.println("raw data");
        fout.printtab("item ");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("median");
        fout.printtab("range");
        fout.printtab("total");
        fout.println("dichotomous");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("percentage");
        i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            fout.printtab(Fmath.truncate(this.rawItemMinima[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemMaxima[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemMedians[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemRanges[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rawItemTotals[i], this.trunc));
            fout.println(Fmath.truncate(this.dichotomousPercentage[i], 1));
            ++i;
        }
        fout.println();
        fout.printtab("item");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("variance");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.println("range");
        fout.printtab("statistic    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("     ");
        fout.printtab("item means");
        fout.printtab(Fmath.truncate(this.rawItemMeansMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMeansSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMeansVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMeansMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMeansMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemMeansRange, this.trunc));
        fout.printtab("item standard deviations");
        fout.printtab(Fmath.truncate(this.rawItemStandardDeviationsMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemStandardDeviationsSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemStandardDeviationsVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemStandardDeviationsMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemStandardDeviationsMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemStandardDeviationsRange, this.trunc));
        fout.printtab("item variances");
        fout.printtab(Fmath.truncate(this.rawItemVariancesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemVariancesSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemVariancesVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemVariancesMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemVariancesMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemVariancesRange, this.trunc));
        fout.printtab("item mimima");
        fout.printtab(Fmath.truncate(this.rawItemMinimaMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMinimaSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMinimaVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMinimaMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMinimaMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemMinimaRange, this.trunc));
        fout.printtab("item maxima");
        fout.printtab(Fmath.truncate(this.rawItemMaximaMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMaximaSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMaximaVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMaximaMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMaximaMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemMaximaRange, this.trunc));
        fout.printtab("item medians");
        fout.printtab(Fmath.truncate(this.rawItemMediansMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMediansSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMediansVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMediansMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemMediansMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fout.printtab("item ranges");
        fout.printtab(Fmath.truncate(this.rawItemRangesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemRangesSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemRangesVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemRangesMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemRangesMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemRangesRange, this.trunc));
        fout.printtab("item totals");
        fout.printtab(Fmath.truncate(this.rawItemTotalsMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemTotalsSd, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemTotalsVar, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemTotalsMin, this.trunc));
        fout.printtab(Fmath.truncate(this.rawItemTotalsMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemTotalsRange, this.trunc));
        fout.println();
        fout.println("Standardized data");
        fout.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fout.printtab("item ");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("moment");
        fout.printtab("median");
        fout.printtab("quartile");
        fout.println("kurtosis");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.printtab("skewness");
        fout.println("excess  ");
        i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            fout.printtab(Fmath.truncate(this.standardizedItemMeans[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviations[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemMomentSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemMedianSkewness[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemQuartileSkewness[i], this.trunc));
            fout.println(Fmath.truncate(this.standardizedItemKurtosisExcess[i], this.trunc));
            ++i;
        }
        fout.println();
        fout.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fout.println("Standardized data");
        fout.printtab("item ");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("median");
        fout.printtab("range");
        fout.println("total");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("     ");
        i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            fout.printtab(Fmath.truncate(this.standardizedItemMinima[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemMaxima[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemMedians[i], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedItemRanges[i], this.trunc));
            fout.println(Fmath.truncate(this.standardizedItemTotals[i], this.trunc));
            ++i;
        }
        fout.println();
        fout.printtab("item");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("variance");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.println("range");
        fout.printtab("statistic    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("     ");
        fout.printtab("item means");
        fout.printtab(Fmath.truncate(this.standardizedItemMeansMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMeansSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMeansVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMeansMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMeansMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemMeansRange, this.trunc));
        fout.printtab("item standard deviations");
        fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemStandardDeviationsMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemStandardDeviationsRange, this.trunc));
        fout.printtab("item variances");
        fout.printtab(Fmath.truncate(this.standardizedItemVariancesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemVariancesSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemVariancesVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemVariancesMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemVariancesMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemVariancesRange, this.trunc));
        fout.printtab("item mimima");
        fout.printtab(Fmath.truncate(this.standardizedItemMinimaMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMinimaSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMinimaVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMinimaMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMinimaMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemMinimaRange, this.trunc));
        fout.printtab("item maxima");
        fout.printtab(Fmath.truncate(this.standardizedItemMaximaMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMaximaSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMaximaVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMaximaMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemMaximaMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemMaximaRange, this.trunc));
        fout.print("item medians");
        fout.print(Fmath.truncate(this.rawItemMediansMean, this.trunc));
        fout.print(Fmath.truncate(this.rawItemMediansSd, this.trunc));
        fout.print(Fmath.truncate(this.rawItemMediansVar, this.trunc));
        fout.print(Fmath.truncate(this.rawItemMediansMin, this.trunc));
        fout.print(Fmath.truncate(this.rawItemMediansMax, this.trunc));
        fout.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fout.printtab("item ranges");
        fout.printtab(Fmath.truncate(this.standardizedItemRangesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemRangesSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemRangesVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemRangesMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemRangesMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemRangesRange, this.trunc));
        fout.printtab("item totals");
        fout.printtab(Fmath.truncate(this.standardizedItemTotalsMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemTotalsSd, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemTotalsVar, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemTotalsMin, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedItemTotalsMax, this.trunc));
        fout.println(Fmath.truncate(this.standardizedItemTotalsRange, this.trunc));
        fout.println();
        fout.println("DELETION OF ITEMS");
        fout.printtab("                ");
        fout.printtab("Raw data        ");
        fout.printtab("                ");
        fout.printtab("                ");
        fout.printtab("                ");
        fout.println("Standardized data");
        fout.printtab("Deleted item");
        fout.printtab("Alpha       ");
        fout.printtab("Correlation ");
        fout.printtab("Average     ");
        fout.printtab("Average     ");
        fout.printtab("Alpha       ");
        fout.printtab("Correlation ");
        fout.printtab("Average     ");
        fout.println("Average     ");
        fout.printtab("           ");
        fout.printtab("           ");
        fout.printtab("coefficient");
        fout.printtab("inter-item ");
        fout.printtab("inter-item ");
        fout.printtab("           ");
        fout.printtab("coefficient ");
        fout.printtab("inter-item ");
        fout.println("inter-item ");
        fout.printtab("           ");
        fout.printtab("           ");
        fout.printtab("with total ");
        fout.printtab("correlation");
        fout.printtab("correlation");
        fout.printtab("           ");
        fout.printtab("with total ");
        fout.printtab("correlation");
        fout.println("correlation");
        fout.printtab("           ");
        fout.printtab("           ");
        fout.printtab("           ");
        fout.printtab("coefficient");
        fout.printtab("coefficient");
        fout.printtab("           ");
        fout.printtab("           ");
        fout.printtab("coefficient");
        fout.println("coefficient");
        fout.printtab("              ");
        fout.printtab("              ");
        fout.printtab("              ");
        fout.printtab("without totals");
        fout.printtab("with totals   ");
        fout.printtab("              ");
        fout.printtab("              ");
        fout.printtab("without totals");
        fout.println("with totals   ");
        double[] newRawAlpha = new double[this.nItems];
        double[] newStandardizedAlpha = new double[this.nItems];
        double[] newRawRho = new double[this.nItems];
        double[] newStandardizedRho = new double[this.nItems];
        int i3 = 0;
        while (i3 < this.nItems) {
            double standardizedRhoAgainstTotalsD;
            double standardizedAlphaD;
            double rawRhoAgainstTotalsD;
            double rawAlphaD;
            int index2 = i3 + 1;
            double[][] newScore1 = this.deleteItem(index2);
            Cronbach cr = new Cronbach();
            cr.enterScoresAsRowPerPerson(newScore1);
            newRawAlpha[i3] = rawAlphaD = cr.rawAlpha();
            double rawMeanRhoWithTotalsD = cr.rawAverageCorrelationCoefficientsWithTotals();
            double rawMeanRhoWithoutTotalsD = cr.rawAverageCorrelationCoefficients();
            double[] rawPersonTotalsD = cr.rawPersonTotals();
            newRawRho[i3] = rawRhoAgainstTotalsD = Stat.corrCoeff(rawPersonTotalsD, this.scores0[i3]);
            newStandardizedAlpha[i3] = standardizedAlphaD = cr.standardizedAlpha();
            double standardizedMeanRhoWithTotalsD = cr.standardizedAverageCorrelationCoefficientsWithTotals();
            double standardizedMeanRhoWithoutTotalsD = cr.standardizedAverageCorrelationCoefficients();
            double[] standardizedPersonTotalsD = cr.standardizedPersonTotals();
            newStandardizedRho[i3] = standardizedRhoAgainstTotalsD = Stat.corrCoeff(standardizedPersonTotalsD, this.scores0[i3]);
            fout.printtab(this.itemNames[i3]);
            fout.printtab(Fmath.truncate(rawAlphaD, this.trunc));
            fout.printtab(Fmath.truncate(rawRhoAgainstTotalsD, this.trunc));
            fout.printtab(Fmath.truncate(rawMeanRhoWithoutTotalsD, this.trunc));
            fout.printtab(Fmath.truncate(rawMeanRhoWithTotalsD, this.trunc));
            fout.printtab(Fmath.truncate(standardizedAlphaD, this.trunc));
            fout.printtab(Fmath.truncate(standardizedRhoAgainstTotalsD, this.trunc));
            fout.printtab(Fmath.truncate(standardizedMeanRhoWithoutTotalsD, this.trunc));
            fout.println(Fmath.truncate(standardizedMeanRhoWithTotalsD, this.trunc));
            ++i3;
        }
        fout.println();
        fout.printtab("No item deleted");
        fout.printtab(Fmath.truncate(this.rawAlpha, this.trunc));
        fout.printtab("   ");
        fout.printtab(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fout.printtab(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fout.printtab("   ");
        fout.printtab(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.println();
        this.deletedItemDataFile(newRawAlpha, newRawRho, newStandardizedAlpha, newStandardizedRho);
        fout.println("INDIVIDUALS - raw data");
        fout.printtab("person ");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("range");
        fout.printtab("total");
        fout.println("scores:");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        i3 = 0;
        while (i3 < this.nItems) {
            fout.printtab(this.itemNames[i3]);
            ++i3;
        }
        fout.println();
        i3 = 0;
        while (i3 < this.nPersons) {
            fout.printtab(this.personIndices[i3] + 1);
            fout.printtab(Fmath.truncate(this.rawPersonMeans[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.rawPersonStandardDeviations[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.rawPersonMinima[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.rawPersonMaxima[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.rawPersonRanges[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.rawPersonTotals[i3], this.trunc));
            j = 0;
            while (j < this.nItems) {
                fout.printtab(Fmath.truncate(this.scores1[i3][j], this.trunc));
                ++j;
            }
            fout.println();
            ++i3;
        }
        fout.println();
        fout.println("INDIVIDUALS - standardized data");
        fout.printtab("person ");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("range");
        fout.printtab("total");
        fout.println("scores:");
        fout.printtab("    ");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        i3 = 0;
        while (i3 < this.nItems) {
            fout.printtab(this.itemNames[i3]);
            ++i3;
        }
        fout.println();
        i3 = 0;
        while (i3 < this.nPersons) {
            fout.printtab(this.personIndices[i3] + 1);
            fout.printtab(Fmath.truncate(this.standardizedPersonMeans[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedPersonStandardDeviations[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedPersonMinima[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedPersonMaxima[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedPersonRanges[i3], this.trunc));
            fout.printtab(Fmath.truncate(this.standardizedPersonTotals[i3], this.trunc));
            j = 0;
            while (j < this.nItems) {
                fout.printtab(Fmath.truncate(this.standardizedScores1[i3][j], this.trunc));
                ++j;
            }
            fout.println();
            ++i3;
        }
        fout.println();
        fout.println("ALL SCORES - raw data");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("range");
        fout.println("overall");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("total");
        fout.printtab(Fmath.truncate(this.rawAllResponsesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.rawAllResponsesStandardDeviation, this.trunc));
        fout.printtab(Fmath.truncate(this.rawAllResponsesMinimum, this.trunc));
        fout.printtab(Fmath.truncate(this.rawAllResponsesMaximum, this.trunc));
        fout.printtab(Fmath.truncate(this.rawAllResponsesRange, this.trunc));
        fout.println(Fmath.truncate(this.rawAllResponsesTotal, this.trunc));
        fout.println();
        fout.println("ALL SCORES - standardized data");
        fout.printtab("mean");
        fout.printtab("standard");
        fout.printtab("minimum");
        fout.printtab("maximum");
        fout.printtab("range");
        fout.println("overall");
        fout.printtab("    ");
        fout.printtab("deviation");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.printtab("     ");
        fout.println("total");
        fout.printtab(Fmath.truncate(this.standardizedAllResponsesMean, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedAllResponsesStandardDeviation, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedAllResponsesMinimum, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedAllResponsesMaximum, this.trunc));
        fout.printtab(Fmath.truncate(this.standardizedAllResponsesRange, this.trunc));
        fout.println(Fmath.truncate(this.standardizedAllResponsesTotal, this.trunc));
        fout.println();
        fout.close();
    }

    private void analysisText() {
        int j;
        int i;
        FileOutput fout = null;
        fout = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.rawAlphaCalculated) {
            this.rawAlpha();
        }
        if (!this.standardizedAlphaCalculated) {
            this.standardizedAlpha();
        }
        fout.println("CRONBACH'S ALPHA RELIABILITY ESTIMATOR");
        fout.println("Program: Cronbach - Analysis Output");
        int i2 = 0;
        while (i2 < this.titleLines) {
            fout.println(this.title[i2]);
            ++i2;
        }
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        int field2 = 36;
        fout.println("RELIABILITY ESTIMATORS");
        fout.println("Cronbach's coefficient alpha");
        fout.print("Raw data ", field2);
        fout.println(Fmath.truncate(this.rawAlpha, this.trunc));
        fout.print("Standardized data ", field2);
        fout.println(Fmath.truncate(this.standardizedAlpha, this.trunc));
        fout.println();
        fout.println("Average of the inter-item correlation coefficients, excluding item totals");
        fout.print("Raw data ", field2);
        fout.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fout.print("Standardized data ", field2);
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fout.println();
        fout.println("Average of the inter-item correlation coefficients, including item totals");
        fout.print("Raw data ", field2);
        fout.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fout.print("Standardized data ", field2);
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.println();
        fout.println("'NO RESPONSE' DELETIONS AND REPLACEMENTS");
        field2 = 34;
        int fieldInt = 6;
        boolean deletionFlag = false;
        if (this.nDeletedPersons != 0) {
            deletionFlag = true;
            fout.print("Number of persons deleted ", field2);
            fout.println(this.nDeletedPersons);
            fout.print("Indices of deleted persons: ", field2);
            i = 0;
            while (i < this.nDeletedPersons) {
                fout.print(this.deletedPersonsIndices[i] + 1, fieldInt);
                ++i;
            }
            fout.println();
        } else {
            fout.println("No persons were deleted ");
        }
        if (this.nDeletedItems != 0) {
            deletionFlag = true;
            fout.print("Number of items deleted ", field2);
            fout.println(this.nDeletedItems);
            fout.print("Names of deleted items: ", field2);
            i = 0;
            while (i < this.nDeletedItems) {
                fout.print(this.originalItemNames[this.deletedItemsIndices[i]], fieldInt);
                ++i;
            }
            fout.println();
        } else {
            fout.println("No items were deleted ");
        }
        if (this.nReplacements != 0) {
            fout.printtab("Number of 'no responses' replaced ");
            fout.println(this.nReplacements);
            fout.print("Item name and person index of replacements: ", 50);
            i = 0;
            while (i < this.nReplacements) {
                fout.print(String.valueOf(this.replacementIndices[i]) + " ", fieldInt);
                ++i;
            }
            fout.println();
            fout.print("Replacement option: ", field2);
            fout.println(this.replacementOptionNames[this.replacementOption - 1]);
            fout.println();
        } else if (deletionFlag) {
            fout.println("No 'no response' replacements, other than any above deletions, were made ");
        } else {
            fout.println("No 'no response' replacements were made ");
        }
        fout.println();
        fout.print("Number of items used", 35);
        fout.println(this.nItems);
        fout.print("Number of persons used", 35);
        fout.println(this.nPersons);
        fout.println();
        int len = this.trunc + 8;
        int fieldItemName = 0;
        int i3 = 0;
        while (i3 <= this.nItems) {
            if (this.itemNames[i3].length() > fieldItemName) {
                fieldItemName = this.itemNames[i3].length();
            }
            ++i3;
        }
        int fieldItemNumber = fieldItemName;
        if (len > fieldItemNumber) {
            fieldItemNumber = len;
        }
        ++fieldItemNumber;
        fout.println("CORRELATION COEFFICIENTS");
        fout.println("Correlation coefficients between items  -  raw data");
        fout.print("    ", ++fieldItemName);
        int i4 = 0;
        while (i4 <= this.nItems) {
            fout.print(this.itemNames[i4], fieldItemNumber);
            ++i4;
        }
        fout.println();
        i4 = 0;
        while (i4 <= this.nItems) {
            fout.print(this.itemNames[i4], fieldItemName);
            j = 0;
            while (j <= this.nItems) {
                fout.print(Fmath.truncate(this.rawCorrelationCoefficients[i4][j], this.trunc), fieldItemNumber);
                ++j;
            }
            fout.println();
            ++i4;
        }
        fout.println();
        fout.print("Average inter-item correlation coefficient (excluding total) ", 80);
        fout.println(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (excluding total) ", 80);
        fout.println(Fmath.truncate(this.rawStandardDeviationRhoWithoutTotals, this.trunc));
        fout.print("Average inter-item correlation coefficient (including total) ", 80);
        fout.println(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (including total) ", 80);
        fout.println(Fmath.truncate(this.rawStandardDeviationRhoWithTotals, this.trunc));
        fout.println();
        fout.println("Correlation coefficients between items  -  standardized data");
        fout.print("    ", fieldItemName);
        i4 = 0;
        while (i4 <= this.nItems) {
            fout.print(this.itemNames[i4], fieldItemNumber);
            ++i4;
        }
        fout.println();
        i4 = 0;
        while (i4 <= this.nItems) {
            fout.print(this.itemNames[i4], fieldItemName);
            j = 0;
            while (j <= this.nItems) {
                fout.print(Fmath.truncate(this.standardizedCorrelationCoefficients[i4][j], this.trunc), fieldItemNumber);
                ++j;
            }
            fout.println();
            ++i4;
        }
        fout.println();
        fout.print("Average inter-item correlation coefficient (excluding total) ", 80);
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (excluding total) ", 80);
        fout.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithoutTotals, this.trunc));
        fout.print("Average inter-item correlation coefficient (including total) ", 80);
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.print("Standard deviation of the inter-item correlation coefficient (including total) ", 80);
        fout.println(Fmath.truncate(this.standardizedStandardDeviationRhoWithTotals, this.trunc));
        fout.println();
        if (fieldItemNumber < 12) {
            fieldItemNumber = 12;
        }
        fout.println("ITEMS: MEANS, STANDARD DEVIATIONS, SKEWNESS AND KURTOSIS");
        fout.println("Raw data");
        fout.print("item ", fieldItemName);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("moment", fieldItemNumber);
        fout.print("median", fieldItemNumber);
        fout.print("quartile", fieldItemNumber);
        fout.print("kurtosis", fieldItemNumber);
        fout.println("dichotomous");
        fout.print("    ", fieldItemName);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.print("excess  ", fieldItemNumber);
        fout.println("percentage");
        i4 = 0;
        while (i4 < this.nItems) {
            fout.print(this.itemNames[i4], fieldItemName);
            fout.print(Fmath.truncate(this.rawItemMeans[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemStandardDeviations[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemMomentSkewness[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemMedianSkewness[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemQuartileSkewness[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemKurtosisExcess[i4], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.dichotomousPercentage[i4], 1));
            ++i4;
        }
        fout.println();
        fout.println("ITEMS: MINIMA, MAXIMA, MEDIANS, RANGES AND TOTALS");
        fout.println("Raw data");
        fout.print("item ", fieldItemName);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("median", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.print("total", fieldItemNumber);
        fout.println("dichotomous");
        fout.print("    ", fieldItemName);
        fout.print("    ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("percentage");
        i4 = 0;
        while (i4 < this.nItems) {
            fout.print(this.itemNames[i4], fieldItemName);
            fout.print(Fmath.truncate(this.rawItemMinima[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemMaxima[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemMedians[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemRanges[i4], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawItemTotals[i4], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.dichotomousPercentage[i4], 1));
            ++i4;
        }
        fout.println();
        int fieldItemSName = 25;
        fout.print("item", fieldItemSName);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("variance", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.println("range");
        fout.print("statistic    ", fieldItemSName);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("     ");
        fout.print("item means", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemMeansMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMeansSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMeansVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMeansMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMeansMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemMeansRange, this.trunc));
        fout.print("item standard deviations", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemStandardDeviationsMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemStandardDeviationsSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemStandardDeviationsVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemStandardDeviationsMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemStandardDeviationsMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemStandardDeviationsRange, this.trunc));
        fout.print("item variances", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemVariancesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemVariancesSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemVariancesVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemVariancesMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemVariancesMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemVariancesRange, this.trunc));
        fout.print("item mimima", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemMinimaMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMinimaSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMinimaVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMinimaMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMinimaMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemMinimaRange, this.trunc));
        fout.print("item maxima", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemMaximaMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMaximaSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMaximaVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMaximaMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMaximaMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemMaximaRange, this.trunc));
        fout.print("item medians", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemMediansMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMediansSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMediansVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMediansMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemMediansMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemMediansRange, this.trunc));
        fout.print("item ranges", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemRangesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemRangesSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemRangesVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemRangesMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemRangesMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemRangesRange, this.trunc));
        fout.print("item totals", fieldItemSName);
        fout.print(Fmath.truncate(this.rawItemTotalsMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemTotalsSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemTotalsVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemTotalsMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawItemTotalsMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawItemTotalsRange, this.trunc));
        fout.println();
        fout.println("standardized data");
        fout.print("item ", fieldItemName);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("moment", fieldItemNumber);
        fout.print("median", fieldItemNumber);
        fout.print("quartile", fieldItemNumber);
        fout.println("kurtosis");
        fout.print("    ", fieldItemName);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.print("skewness", fieldItemNumber);
        fout.println("excess  ");
        int i5 = 0;
        while (i5 < this.nItems) {
            fout.print(this.itemNames[i5], fieldItemName);
            fout.print(Fmath.truncate(this.standardizedItemMeans[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemStandardDeviations[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemMomentSkewness[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemMedianSkewness[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemQuartileSkewness[i5], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.standardizedItemKurtosisExcess[i5], this.trunc));
            ++i5;
        }
        fout.println();
        fout.print("item ", fieldItemName);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("median", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.println("total");
        fout.print("    ", fieldItemName);
        fout.print("    ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("     ");
        i5 = 0;
        while (i5 < this.nItems) {
            fout.print(this.itemNames[i5], fieldItemName);
            fout.print(Fmath.truncate(this.standardizedItemMinima[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemMaxima[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemMedians[i5], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedItemRanges[i5], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.standardizedItemTotals[i5], this.trunc));
            ++i5;
        }
        fout.println();
        fout.print("item", fieldItemSName);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("variance", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.println("range");
        fout.print("statistic    ", fieldItemSName);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("     ");
        fout.print("item means", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemMeansMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMeansSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMeansVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMeansMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMeansMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemMeansRange, this.trunc));
        fout.print("item standard deviations", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemStandardDeviationsMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemStandardDeviationsSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemStandardDeviationsVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemStandardDeviationsMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemStandardDeviationsMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemStandardDeviationsRange, this.trunc));
        fout.print("item variances", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemVariancesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemVariancesSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemVariancesVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemVariancesMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemVariancesMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemVariancesRange, this.trunc));
        fout.print("item mimima", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemMinimaMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMinimaSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMinimaVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMinimaMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMinimaMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemMinimaRange, this.trunc));
        fout.print("item maxima", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemMaximaMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMaximaSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMaximaVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMaximaMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMaximaMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemMaximaRange, this.trunc));
        fout.print("item medians", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemMediansMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMediansSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMediansVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMediansMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemMediansMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemMediansRange, this.trunc));
        fout.print("item ranges", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemRangesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemRangesSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemRangesVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemRangesMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemRangesMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemRangesRange, this.trunc));
        fout.print("item totals", fieldItemSName);
        fout.print(Fmath.truncate(this.standardizedItemTotalsMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemTotalsSd, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemTotalsVar, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemTotalsMin, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedItemTotalsMax, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedItemTotalsRange, this.trunc));
        fout.println();
        fout.println("DELETION OF ITEMS");
        int fieldDitem = 16;
        if (fieldItemName > fieldDitem) {
            fieldDitem = fieldItemName;
        }
        fout.print("   ", fieldDitem);
        fout.print("Raw data", fieldItemNumber);
        fout.print("   ", fieldItemNumber);
        fout.print("   ", fieldItemNumber);
        fout.print("   ", fieldItemNumber);
        fout.println("Standardized data");
        fout.print("Deleted item", fieldDitem);
        fout.print("Alpha", fieldItemNumber);
        fout.print("Correlation", fieldItemNumber);
        fout.print("Average", fieldItemNumber);
        fout.print("Average", fieldItemNumber);
        fout.print("Alpha", fieldItemNumber);
        fout.print("Correlation", fieldItemNumber);
        fout.print("Average", fieldItemNumber);
        fout.println("Average");
        fout.print("       ", fieldDitem);
        fout.print("       ", fieldItemNumber);
        fout.print("coefficient", fieldItemNumber);
        fout.print("inter-item", fieldItemNumber);
        fout.print("inter-item", fieldItemNumber);
        fout.print("      ", fieldItemNumber);
        fout.print("coefficient", fieldItemNumber);
        fout.print("inter-item", fieldItemNumber);
        fout.println("inter-item");
        fout.print("       ", fieldDitem);
        fout.print("       ", fieldItemNumber);
        fout.print("with total", fieldItemNumber);
        fout.print("correlation", fieldItemNumber);
        fout.print("correlation", fieldItemNumber);
        fout.print("      ", fieldItemNumber);
        fout.print("with total", fieldItemNumber);
        fout.print("correlation", fieldItemNumber);
        fout.println("correlation");
        fout.print("       ", fieldDitem);
        fout.print("       ", fieldItemNumber);
        fout.print("       ", fieldItemNumber);
        fout.print("coefficient", fieldItemNumber);
        fout.print("coefficient", fieldItemNumber);
        fout.print("        ", fieldItemNumber);
        fout.print("        ", fieldItemNumber);
        fout.print("coefficient", fieldItemNumber);
        fout.println("coefficient");
        fout.print("       ", fieldDitem);
        fout.print("       ", fieldItemNumber);
        fout.print("       ", fieldItemNumber);
        fout.print("without totals", fieldItemNumber);
        fout.print("with totals", fieldItemNumber);
        fout.print("        ", fieldItemNumber);
        fout.print("        ", fieldItemNumber);
        fout.print("without totals", fieldItemNumber);
        fout.println("with totals");
        double[] newRawAlpha = new double[this.nItems];
        double[] newStandardizedAlpha = new double[this.nItems];
        double[] newRawRho = new double[this.nItems];
        double[] newStandardizedRho = new double[this.nItems];
        int i6 = 0;
        while (i6 < this.nItems) {
            double standardizedAlphaD;
            double rawAlphaD;
            int index2 = i6 + 1;
            double[][] newScore1 = this.deleteItem(index2);
            Cronbach cr = new Cronbach();
            cr.enterScoresAsRowPerPerson(newScore1);
            newRawAlpha[i6] = rawAlphaD = cr.rawAlpha();
            double rawMeanRhoWithTotalsD = cr.rawAverageCorrelationCoefficientsWithTotals();
            double[] rawPersonTotalsD = cr.rawPersonTotals();
            double rawRhoAgainstTotalsD = Stat.corrCoeff(rawPersonTotalsD, this.scores0[i6]);
            double rawMeanRhoWithoutTotalsD = cr.rawAverageCorrelationCoefficients();
            newRawRho[i6] = rawRhoAgainstTotalsD;
            newStandardizedAlpha[i6] = standardizedAlphaD = cr.standardizedAlpha();
            double standardizedMeanRhoWithTotalsD = cr.standardizedAverageCorrelationCoefficients();
            double[] standardizedPersonTotalsD = cr.standardizedPersonTotals();
            double standardizedRhoAgainstTotalsD = Stat.corrCoeff(standardizedPersonTotalsD, this.scores0[i6]);
            double standardizedMeanRhoWithoutTotalsD = cr.standardizedAverageCorrelationCoefficients();
            newStandardizedRho[i6] = standardizedRhoAgainstTotalsD;
            fout.print(this.itemNames[i6], fieldDitem);
            fout.print(Fmath.truncate(rawAlphaD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(rawRhoAgainstTotalsD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(rawMeanRhoWithoutTotalsD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(rawMeanRhoWithTotalsD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(standardizedAlphaD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(standardizedRhoAgainstTotalsD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(standardizedMeanRhoWithoutTotalsD, this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(standardizedMeanRhoWithTotalsD, this.trunc), fieldItemNumber);
            fout.println();
            ++i6;
        }
        fout.println();
        fout.print("No item deleted", fieldDitem);
        fout.print(Fmath.truncate(this.rawAlpha, this.trunc), fieldItemNumber);
        fout.print("   ", fieldItemNumber);
        fout.print(Fmath.truncate(this.rawMeanRhoWithoutTotals, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawMeanRhoWithTotals, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedAlpha, this.trunc), fieldItemNumber);
        fout.print("   ", fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedMeanRhoWithoutTotals, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedMeanRhoWithTotals, this.trunc));
        fout.println();
        this.deletedItemDataFile(newRawAlpha, newRawRho, newStandardizedAlpha, newStandardizedRho);
        int fieldInd = 12;
        fout.println("INDIVIDUALS - raw data");
        fout.print("person", fieldInd);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.println("total");
        fout.print("    ", fieldInd);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("     ");
        int fieldScore = 0;
        int i7 = 0;
        while (i7 < this.nItems) {
            int j2 = 0;
            while (j2 < this.nPersons) {
                int sl = Double.toString(this.scores0[i7][j2]).length();
                if (sl > fieldScore) {
                    fieldScore = sl;
                }
                ++j2;
            }
            ++i7;
        }
        if (++fieldScore < fieldItemName) {
            fieldScore = fieldItemName;
        }
        i7 = 0;
        while (i7 < this.nPersons) {
            fout.print(this.personIndices[i7] + 1, fieldInd);
            fout.print(Fmath.truncate(this.rawPersonMeans[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawPersonStandardDeviations[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawPersonMinima[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawPersonMaxima[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.rawPersonRanges[i7], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.rawPersonTotals[i7], this.trunc));
            ++i7;
        }
        fout.println();
        fout.println("scores:");
        fout.print("person ", fieldInd);
        i7 = 0;
        while (i7 < this.nItems) {
            fout.print(this.itemNames[i7], fieldItemNumber);
            ++i7;
        }
        fout.println();
        i7 = 0;
        while (i7 < this.nPersons) {
            fout.print(this.personIndices[i7] + 1, fieldInd);
            int j3 = 0;
            while (j3 < this.nItems) {
                fout.print(Fmath.truncate(this.scores1[i7][j3], this.trunc), fieldItemNumber);
                ++j3;
            }
            fout.println();
            ++i7;
        }
        fout.println();
        fout.println("INDIVIDUALS - standardized data");
        fout.print("person ", fieldInd);
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.println("total");
        fout.print("    ", fieldInd);
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("     ");
        i7 = 0;
        while (i7 < this.nPersons) {
            fout.print(this.personIndices[i7] + 1, fieldInd);
            fout.print(Fmath.truncate(this.standardizedPersonMeans[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedPersonStandardDeviations[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedPersonMinima[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedPersonMaxima[i7], this.trunc), fieldItemNumber);
            fout.print(Fmath.truncate(this.standardizedPersonRanges[i7], this.trunc), fieldItemNumber);
            fout.println(Fmath.truncate(this.standardizedPersonTotals[i7], this.trunc));
            ++i7;
        }
        fout.println();
        fout.println("scores:");
        fout.print("person ", fieldInd);
        i7 = 0;
        while (i7 < this.nItems) {
            fout.print(this.itemNames[i7], fieldItemNumber);
            ++i7;
        }
        fout.println();
        i7 = 0;
        while (i7 < this.nPersons) {
            fout.print(this.personIndices[i7] + 1, fieldInd);
            int j4 = 0;
            while (j4 < this.nItems) {
                fout.print(Fmath.truncate(this.standardizedScores1[i7][j4], this.trunc), fieldItemNumber);
                ++j4;
            }
            fout.println();
            ++i7;
        }
        fout.println();
        fout.println("ALL SCORES - raw data");
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.println("overall");
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("total");
        fout.print(Fmath.truncate(this.rawAllResponsesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawAllResponsesStandardDeviation, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawAllResponsesMinimum, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawAllResponsesMaximum, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.rawAllResponsesRange, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.rawAllResponsesTotal, this.trunc));
        fout.println();
        fout.println("ALL SCORES - standardized data");
        fout.print("mean", fieldItemNumber);
        fout.print("standard", fieldItemNumber);
        fout.print("minimum", fieldItemNumber);
        fout.print("maximum", fieldItemNumber);
        fout.print("range", fieldItemNumber);
        fout.println("overall");
        fout.print("    ", fieldItemNumber);
        fout.print("deviation", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.print("     ", fieldItemNumber);
        fout.println("total");
        fout.print(Fmath.truncate(this.standardizedAllResponsesMean, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedAllResponsesStandardDeviation, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedAllResponsesMinimum, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedAllResponsesMaximum, this.trunc), fieldItemNumber);
        fout.print(Fmath.truncate(this.standardizedAllResponsesRange, this.trunc), fieldItemNumber);
        fout.println(Fmath.truncate(this.standardizedAllResponsesTotal, this.trunc));
        fout.println();
        fout.close();
    }

    private void deletedItemDataFile(double[] newRawAlpha, double[] newRawRho, double[] newStandardizedAlpha, double[] newStandardizedRho) {
        ArrayMaths am = new ArrayMaths(newRawAlpha);
        int index1 = am.maximumIndex();
        am = new ArrayMaths(newStandardizedAlpha);
        int index2 = am.maximumIndex();
        am = new ArrayMaths(newRawRho);
        int index3 = am.minimumIndex();
        am = new ArrayMaths(newStandardizedRho);
        int index4 = am.minimumIndex();
        this.deletedItemIndex = index3;
        if (index1 == index2 && index1 == index3 && index1 == index4) {
            this.deletedItemIndex = index1;
        } else if (index1 == index2 && (index1 == index3 || index1 == index4)) {
            this.deletedItemIndex = index1;
        } else if (index4 == index3 && (index4 == index1 || index4 == index2)) {
            this.deletedItemIndex = index4;
        } else if (index1 == index2 && index3 == index4) {
            this.deletedItemIndex = index3;
        } else if (index1 == index3 && index2 == index4) {
            this.deletedItemIndex = index1;
        } else if (index1 != index2 && index2 != index3 && index3 != index4) {
            this.deletedItemIndex = index3;
        }
        this.deletedFilename = null;
        if (this.inputFilename != null) {
            this.deletedFilename = this.inputFilename;
            int pos = this.deletedFilename.indexOf(".");
            if (pos != -1) {
                this.deletedFilename = this.deletedFilename.substring(0, pos);
            }
            this.deletedFilename = String.valueOf(this.deletedFilename) + "_" + this.itemNames[this.deletedItemIndex] + "_deleted";
            this.deletedFilename = String.valueOf(this.deletedFilename) + ".txt";
        } else {
            this.deletedFilename = "DeletedItemFile.txt";
        }
        FileOutput dfout = new FileOutput(this.deletedFilename);
        String newTitle = String.valueOf(this.title[0]) + " - Item " + this.itemNames[this.deletedItemIndex] + " deleted";
        dfout.println(newTitle);
        dfout.println(this.nItems - 1);
        dfout.println(this.nPersons);
        int i = 0;
        while (i < this.nItems) {
            if (i != this.deletedItemIndex) {
                dfout.printtab(this.itemNames[i]);
            }
            ++i;
        }
        dfout.println();
        if (this.originalDataType == 0) {
            i = 0;
            while (i < this.nItems) {
                if (i != this.deletedItemIndex) {
                    int j = 0;
                    while (j < this.nPersons) {
                        dfout.printtab(this.scores0[i][j]);
                        ++j;
                    }
                    dfout.println();
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.nPersons) {
                int i2 = 0;
                while (i2 < this.nItems) {
                    if (i2 != this.deletedItemIndex) {
                        dfout.printtab(this.scores1[j][i2]);
                    }
                    ++i2;
                }
                dfout.println();
                ++j;
            }
        }
        dfout.close();
    }

    public String getDeletionFileName() {
        return this.deletedFilename;
    }

    public String getLeastConsistentItemName() {
        return this.itemNames[this.deletedItemIndex];
    }
}

