/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.BoxCoxFunction;
import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Maximization;
import flanagan.math.MaximizationFunction;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class BoxCox {
    private double[] originalData = null;
    private double[] sortedOriginalData = null;
    private double[] standardizedOriginalData = null;
    private Stat sod = null;
    private double[] shiftedStandardizedOriginalData = null;
    private int[] originalIndices = null;
    private int nData = 0;
    private double originalRange = 0.0;
    private double originalMinimum = 0.0;
    private double originalMaximum = 0.0;
    private double originalMean = 0.0;
    private double originalMedian = 0.0;
    private double originalStandardDeviation = 0.0;
    private double originalVariance = 0.0;
    private double originalMomentSkewness = 0.0;
    private double originalMedianSkewness = 0.0;
    private double originalQuartileSkewness = 0.0;
    private double originalExcessKurtosis = 0.0;
    private double standardizedOriginalRange = 0.0;
    private double standardizedOriginalMinimum = 0.0;
    private double standardizedOriginalMaximum = 0.0;
    private double standardizedOriginalMean = 0.0;
    private double standardizedOriginalMedian = 0.0;
    private double standardizedOriginalStandardDeviation = 1.0;
    private double standardizedOriginalVariance = 1.0;
    private double standardizedOriginalMomentSkewness = 0.0;
    private double standardizedOriginalMedianSkewness = 0.0;
    private double standardizedOriginalQuartileSkewness = 0.0;
    private double standardizedOriginalExcessKurtosis = 0.0;
    private double originalSampleR = 0.0;
    private double originalIntercept = 0.0;
    private double originalGradient = 0.0;
    private double originalInterceptError = 0.0;
    private double originalGradientError = 0.0;
    private boolean initializationDone = false;
    private double[] transformedData = null;
    private double[] standardizedTransformedData = null;
    private double[] scaledTransformedData = null;
    private double[] sortedScaledTransformedData = null;
    private double transformedRange = 0.0;
    private double transformedMinimum = 0.0;
    private double transformedMaximum = 0.0;
    private double transformedMean = 0.0;
    private double transformedStandardDeviation = 0.0;
    private double transformedMedian = 0.0;
    private double transformedVariance = 0.0;
    private double transformedMomentSkewness = 0.0;
    private double transformedMedianSkewness = 0.0;
    private double transformedQuartileSkewness = 0.0;
    private double transformedExcessKurtosis = 0.0;
    private double standardizedTransformedRange = 0.0;
    private double standardizedTransformedMinimum = 0.0;
    private double standardizedTransformedMaximum = 0.0;
    private double standardizedTransformedMean = 0.0;
    private double standardizedTransformedMedian = 0.0;
    private double standardizedTransformedStandardDeviation = 1.0;
    private double standardizedTransformedVariance = 1.0;
    private double standardizedTransformedMomentSkewness = 0.0;
    private double standardizedTransformedMedianSkewness = 0.0;
    private double standardizedTransformedQuartileSkewness = 0.0;
    private double standardizedTransformedExcessKurtosis = 0.0;
    private double[] inverseData = null;
    private double lambdaThree = 0.0;
    private double lambdaOne = 0.0;
    private double lambdaTwo = 0.0;
    private double transformedSampleR = 0.0;
    private double transformedIntercept = 0.0;
    private double transformedGradient = 0.0;
    private double transformedInterceptError = 0.0;
    private double transformedGradientError = 0.0;
    private double[] uniformOrderMedians = null;
    private double[] gaussianOrderMedians = null;
    private boolean transformDone = false;
    private boolean inverseDone = false;

    public BoxCox(double[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(float[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(int[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(long[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(short[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(byte[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(BigDecimal[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(BigInteger[] originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(Stat originalData) {
        this.sod = originalData;
    }

    public BoxCox(ArrayMaths amoriginalData) {
        double[] ama = amoriginalData.array();
        this.sod = new Stat(ama);
    }

    public BoxCox(ArrayList<Object> originalData) {
        this.sod = new Stat(originalData);
    }

    public BoxCox(Vector<Object> originalData) {
        this.sod = new Stat(originalData);
    }

    public void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    private void initialize() {
        this.originalData = this.sod.array_as_double();
        this.originalMinimum = this.sod.minimum();
        this.originalMaximum = this.sod.maximum();
        this.originalMedian = this.sod.median();
        if (this.originalMinimum == this.originalMaximum) {
            throw new IllegalArgumentException("A Box-Cox transformation cannot be performed on a data array of identical values");
        }
        this.originalRange = this.originalMaximum - this.originalMinimum;
        this.originalMean = this.sod.mean();
        this.originalStandardDeviation = this.sod.standardDeviation();
        this.originalVariance = this.sod.variance();
        this.originalMomentSkewness = this.sod.momentSkewness();
        this.originalMedianSkewness = this.sod.medianSkewness();
        this.originalQuartileSkewness = this.sod.quartileSkewness();
        this.originalExcessKurtosis = this.sod.excessKurtosis();
        ArrayMaths sorted2 = this.sod.sort();
        this.sortedOriginalData = sorted2.array();
        this.originalIndices = sorted2.originalIndices();
        this.standardizedOriginalData = this.sod.standardize();
        this.standardizedOriginalMinimum = this.sod.minimum();
        this.standardizedOriginalMaximum = this.sod.maximum();
        this.standardizedOriginalMedian = this.sod.median();
        this.standardizedOriginalRange = this.standardizedOriginalMaximum - this.standardizedOriginalMinimum;
        this.standardizedOriginalMean = 0.0;
        this.standardizedOriginalStandardDeviation = 1.0;
        this.standardizedOriginalVariance = 1.0;
        this.standardizedOriginalMomentSkewness = this.sod.momentSkewness();
        this.standardizedOriginalMedianSkewness = this.sod.medianSkewness();
        this.standardizedOriginalQuartileSkewness = this.sod.quartileSkewness();
        this.standardizedOriginalExcessKurtosis = this.sod.excessKurtosis();
        this.nData = this.originalData.length;
        this.uniformOrderMedians = Stat.uniformOrderStatisticMedians(this.nData);
        this.gaussianOrderMedians = Stat.gaussianOrderStatisticMedians(this.nData);
        Regression reg = new Regression(this.gaussianOrderMedians, new ArrayMaths(this.standardizedOriginalData).sort().array());
        reg.linear();
        this.originalSampleR = reg.getSampleR();
        double[] coeff = reg.getBestEstimates();
        this.originalIntercept = coeff[0];
        this.originalGradient = coeff[1];
        coeff = reg.getBestEstimatesErrors();
        this.originalInterceptError = coeff[0];
        this.originalGradientError = coeff[1];
        this.initializationDone = true;
    }

    private double[] transform() {
        int i;
        if (!this.initializationDone) {
            this.initialize();
        }
        this.lambdaTwo = 0.1 * this.standardizedOriginalRange - this.standardizedOriginalMinimum;
        ArrayMaths st1 = this.sod.plus(this.lambdaTwo);
        this.shiftedStandardizedOriginalData = st1.getArray_as_double();
        BoxCoxFunction bcf = new BoxCoxFunction();
        bcf.shiftedData = this.shiftedStandardizedOriginalData;
        bcf.nData = this.nData;
        bcf.yTransform = new double[this.nData];
        bcf.gaussianOrderMedians = this.gaussianOrderMedians;
        Maximization max2 = new Maximization();
        double[] start = new double[]{1.0};
        double[] step2 = new double[]{0.3};
        double maxzTol = 1.0E-9;
        max2.nelderMead((MaximizationFunction)bcf, start, step2, maxzTol);
        double[] coeff = max2.getParamValues();
        double lambda1 = coeff[0];
        double sampleR1 = max2.getMaximum();
        start[0] = lambda1 - (start[0] - lambda1);
        max2.nelderMead((MaximizationFunction)bcf, start, step2, maxzTol);
        coeff = max2.getParamValues();
        this.lambdaOne = coeff[0];
        this.transformedSampleR = max2.getMaximum();
        if (sampleR1 > this.transformedSampleR) {
            this.transformedSampleR = sampleR1;
            this.lambdaOne = lambda1;
        }
        this.transformedData = new double[this.nData];
        if (this.lambdaOne == 0.0) {
            i = 0;
            while (i < this.nData) {
                this.transformedData[i] = Math.exp(this.shiftedStandardizedOriginalData[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nData) {
                this.transformedData[i] = (Math.pow(this.shiftedStandardizedOriginalData[i], this.lambdaOne) - 1.0) / this.lambdaOne;
                ++i;
            }
        }
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        ArrayMaths st4 = new ArrayMaths(this.standardizedTransformedData);
        st4 = st4.sort();
        double[] ordered = st4.array();
        Regression reg = new Regression(this.gaussianOrderMedians, ordered);
        reg.linear();
        coeff = reg.getBestEstimates();
        this.transformedIntercept = coeff[0];
        this.transformedGradient = coeff[1];
        coeff = reg.getBestEstimatesErrors();
        this.transformedInterceptError = coeff[0];
        this.transformedGradientError = coeff[1];
        this.scaledTransformedData = Stat.scale(this.standardizedTransformedData, this.originalMean, this.originalStandardDeviation);
        this.transformedDataStatistics(this.scaledTransformedData);
        this.transformDone = true;
        return this.transformedData;
    }

    private void transformedDataStatistics(double[] data2) {
        Stat st2 = new Stat(data2);
        this.transformedMinimum = st2.minimum();
        this.transformedMaximum = st2.maximum();
        this.transformedMedian = st2.median();
        this.transformedRange = this.transformedMaximum - this.transformedMinimum;
        this.transformedMean = st2.mean();
        this.transformedStandardDeviation = st2.standardDeviation();
        this.transformedVariance = st2.variance();
        this.transformedMomentSkewness = st2.momentSkewness();
        this.transformedMedianSkewness = st2.medianSkewness();
        this.transformedQuartileSkewness = st2.quartileSkewness();
        this.transformedExcessKurtosis = st2.excessKurtosis();
        Stat st5 = new Stat(data2);
        this.sortedScaledTransformedData = st5.sort().array();
    }

    private void standardizedTransformedDataStatistics(double[] data2) {
        Stat st3 = new Stat(data2);
        this.standardizedTransformedMinimum = st3.minimum();
        this.standardizedTransformedMaximum = st3.maximum();
        this.standardizedTransformedMedian = st3.median();
        this.standardizedTransformedRange = this.standardizedTransformedMaximum - this.standardizedTransformedMinimum;
        this.standardizedTransformedMean = 0.0;
        this.standardizedTransformedStandardDeviation = 1.0;
        this.standardizedTransformedVariance = 1.0;
        this.standardizedTransformedMomentSkewness = st3.momentSkewness();
        this.standardizedTransformedMedianSkewness = st3.medianSkewness();
        this.standardizedTransformedQuartileSkewness = st3.quartileSkewness();
        this.standardizedTransformedExcessKurtosis = st3.excessKurtosis();
    }

    public double[] inverseTransform(double lambdaOne, double lambdaTwo) {
        int i;
        this.lambdaOne = lambdaOne;
        this.lambdaTwo = lambdaTwo;
        if (!this.initializationDone) {
            this.initialize();
        }
        if (this.originalData == null) {
            throw new IllegalArgumentException("No data has been entered (via a constructor)");
        }
        this.inverseData = new double[this.nData];
        double[] shiftedData = Conv.copy(this.originalData);
        if (this.originalMinimum < 0.0 && Fmath.isNaN(Math.pow(this.originalMinimum * this.lambdaOne + 1.0, 1.0 / this.lambdaOne))) {
            this.lambdaThree = -0.999 / this.lambdaOne - this.originalMinimum;
            i = 0;
            while (i < this.nData) {
                int n = i++;
                shiftedData[n] = shiftedData[n] + this.lambdaThree;
            }
        }
        if (this.lambdaOne == 0.0) {
            i = 0;
            while (i < this.nData) {
                this.inverseData[i] = Math.exp(shiftedData[i]) - this.lambdaTwo;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nData) {
                this.inverseData[i] = Math.pow(shiftedData[i] * this.lambdaOne + 1.0, 1.0 / this.lambdaOne) - this.lambdaTwo;
                ++i;
            }
        }
        this.transformedData = Conv.copy(this.inverseData);
        this.transformedDataStatistics(this.inverseData);
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        this.inverseDone = true;
        return this.inverseData;
    }

    public double[] inverseTransform(double lambdaOne) {
        return this.inverseTransform(lambdaOne, 0.0);
    }

    public double[] fixedValueTransform(double lambdaOne, double lambdaTwo) {
        int i;
        this.lambdaOne = lambdaOne;
        this.lambdaTwo = lambdaTwo;
        if (!this.initializationDone) {
            this.initialize();
        }
        if (this.originalData == null) {
            throw new IllegalArgumentException("No data has been entered (via a constructor)");
        }
        if (this.originalMinimum + this.lambdaTwo < 0.0) {
            throw new IllegalArgumentException("Negative (data plus lambdaTwo) value, " + (this.originalMinimum + this.lambdaTwo));
        }
        this.transformedData = new double[this.nData];
        if (this.lambdaOne == 0.0) {
            i = 0;
            while (i < this.nData) {
                this.transformedData[i] = Math.exp(this.shiftedStandardizedOriginalData[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nData) {
                this.transformedData[i] = (Math.pow(this.shiftedStandardizedOriginalData[i], this.lambdaOne) - 1.0) / this.lambdaOne;
                ++i;
            }
        }
        this.standardizedTransformedData = new Stat(this.transformedData).standardize();
        this.standardizedTransformedDataStatistics(this.standardizedTransformedData);
        ArrayMaths st4 = new ArrayMaths(this.standardizedTransformedData);
        st4 = st4.sort();
        double[] ordered = st4.array();
        Regression reg = new Regression(this.gaussianOrderMedians, ordered);
        reg.linear();
        double[] coeff = reg.getBestEstimates();
        this.transformedIntercept = coeff[0];
        this.transformedGradient = coeff[1];
        this.scaledTransformedData = Stat.scale(this.standardizedTransformedData, this.originalMean, this.originalStandardDeviation);
        this.transformedDataStatistics(this.scaledTransformedData);
        this.transformDone = true;
        return this.transformedData;
    }

    public double[] fixedValueTransform(double lambdaOne) {
        return this.fixedValueTransform(lambdaOne, 0.0);
    }

    public double lambdaOne() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.lambdaOne;
    }

    public double lambdaTwo() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.lambdaTwo;
    }

    public double lambdaThree() {
        if (!this.inverseDone) {
            System.out.println("BoxCox: method lambdaThree: no inverse transform has been performed, zero returned");
        }
        return this.lambdaThree;
    }

    public double transformedCorrelationCoefficient() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedSampleR;
    }

    public double transformedGradient() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedGradient;
    }

    public double transformedGradientError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedGradientError;
    }

    public double transformedIntercept() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedIntercept;
    }

    public double transformedInterceptError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedInterceptError;
    }

    public double originalCorrelationCoefficient() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalSampleR;
    }

    public double originalGradient() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalGradient;
    }

    public double originalGradientError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalGradientError;
    }

    public double originalIntercept() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalIntercept;
    }

    public double originalInterceptError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalInterceptError;
    }

    public double[] originalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalData;
    }

    public double[] standardizedOriginalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.standardizedOriginalData;
    }

    public double[] sortedOriginalData() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.sortedOriginalData;
    }

    public double[] shiftedStandardizedOriginalata() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.shiftedStandardizedOriginalData;
    }

    public double[] transformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedData;
    }

    public double[] scaledTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.scaledTransformedData;
    }

    public double[] standardizedTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.standardizedTransformedData;
    }

    public double[] orderedTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        ArrayMaths am = new ArrayMaths(this.transformedData);
        double[] ordered = am.sort().array();
        return ordered;
    }

    public double[] orderedScaledTransformedData() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.sortedScaledTransformedData;
    }

    public double originalMean() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMean;
    }

    public double originalMedian() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMedian;
    }

    public double originalStandardDeviation() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalStandardDeviation;
    }

    public double originalStandardError() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalStandardDeviation / Math.sqrt(this.nData);
    }

    public double originalVariance() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalVariance;
    }

    public double originalMomentSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMomentSkewness;
    }

    public double originalMedianSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMedianSkewness;
    }

    public double originalQuartiletSkewness() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalQuartileSkewness;
    }

    public double originalExcessKurtosis() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalExcessKurtosis;
    }

    public double originalMaximum() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMaximum;
    }

    public double originalMinimum() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalMinimum;
    }

    public double originalRange() {
        if (!this.initializationDone) {
            this.initialize();
        }
        return this.originalRange;
    }

    public double transformedMean() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMean;
    }

    public double transformedMedian() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMedian;
    }

    public double transformedStandardDeviation() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedStandardDeviation;
    }

    public double transformedStandardError() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedStandardDeviation / Math.sqrt(this.nData);
    }

    public double transformedVariance() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedVariance;
    }

    public double transformedMomentSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMomentSkewness;
    }

    public double transformedMedianSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMedianSkewness;
    }

    public double transformedQuartileSkewness() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedQuartileSkewness;
    }

    public double transformedExcessKurtosis() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedExcessKurtosis;
    }

    public double transformedMaximum() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMaximum;
    }

    public double transformedMinimum() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedMinimum;
    }

    public double transformedRange() {
        if (!this.transformDone) {
            this.transform();
        }
        return this.transformedRange;
    }

    public void transformedProbabilityPlot() {
        if (!this.transformDone) {
            this.transform();
        }
        double[][] data2 = PlotGraph.data(2, this.nData);
        data2[0] = this.gaussianOrderMedians;
        data2[1] = new ArrayMaths(this.standardizedTransformedData).sort().array();
        data2[2] = this.gaussianOrderMedians;
        int i = 0;
        while (i < this.nData) {
            data2[3][i] = this.transformedIntercept + this.transformedGradient * this.gaussianOrderMedians[i];
            ++i;
        }
        PlotGraph pg = new PlotGraph(data2);
        int[] nArray = new int[2];
        nArray[0] = 4;
        int[] points = nArray;
        pg.setPoint(points);
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        int[] lines2 = nArray2;
        pg.setLine(lines2);
        pg.setXaxisLegend("Gaussian [0,1] Order Statistic Medians");
        pg.setYaxisLegend("Ordered Response Values");
        String legend1 = "Gausssian probability plot:  Box-Cox transformed data";
        String legend2 = "lambdaOne = " + Fmath.truncate(this.lambdaOne, 4) + ",  lambdaTwo = " + Fmath.truncate(this.lambdaTwo, 4) + ",   gradient = " + Fmath.truncate(this.transformedGradient, 4) + ", intercept = " + Fmath.truncate(this.transformedIntercept, 4) + ",  R = " + Fmath.truncate(this.transformedSampleR, 4);
        pg.setGraphTitle(legend1);
        pg.setGraphTitle2(legend2);
        pg.plot();
    }

    public void originalProbabilityPlot() {
        if (!this.initializationDone) {
            this.initialize();
        }
        double[][] data2 = PlotGraph.data(2, this.nData);
        data2[0] = this.gaussianOrderMedians;
        data2[1] = new ArrayMaths(this.standardizedOriginalData).sort().array();
        data2[2] = this.gaussianOrderMedians;
        int i = 0;
        while (i < this.nData) {
            data2[3][i] = this.originalIntercept + this.originalGradient * this.gaussianOrderMedians[i];
            ++i;
        }
        PlotGraph pg = new PlotGraph(data2);
        int[] nArray = new int[2];
        nArray[0] = 4;
        int[] points = nArray;
        pg.setPoint(points);
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        int[] lines2 = nArray2;
        pg.setLine(lines2);
        pg.setXaxisLegend("Gaussian [0,1] Order Statistic Medians");
        pg.setYaxisLegend("Ordered Response Values");
        String legend1 = "Gausssian probability plot: original data for a Box-Cox transformation";
        String legend2 = "gradient = " + Fmath.truncate(this.originalGradient, 4) + ", intercept = " + Fmath.truncate(this.originalIntercept, 4) + ",  R = " + Fmath.truncate(this.originalSampleR, 4);
        pg.setGraphTitle(legend1);
        pg.setGraphTitle2(legend2);
        pg.plot();
    }

    public void analysis() {
        this.analysis("BoxCoxAnalysis.txt");
    }

    public void analysis(String title) {
        if (!this.transformDone) {
            this.transform();
        }
        this.originalProbabilityPlot();
        this.transformedProbabilityPlot();
        int posdot = title.indexOf(".");
        if (posdot == -1) {
            title = String.valueOf(title) + ".txt";
        }
        FileOutput fout = new FileOutput(title);
        fout.println("Box-Cox Analysis");
        fout.println("File name:   " + title);
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        int field1 = 30;
        int field2 = 15;
        fout.print("Box-Cox lambda one", field1);
        fout.println(Fmath.truncate(this.lambdaOne, 4));
        fout.print("Box-Cox lambda two", field1);
        fout.println(Fmath.truncate(this.lambdaTwo, 4));
        fout.println();
        fout.print("  ", field1);
        fout.print("Transformed", field2);
        fout.print("  ", field2);
        fout.println("Original   ");
        fout.print("  ", field1);
        fout.print("scaled data", field2);
        fout.print("  ", field2);
        fout.println("data   ");
        fout.println();
        fout.print("                            ", field1);
        fout.print("Value", field2);
        fout.print("Error", field2);
        fout.print("Value", field2);
        fout.println("Error");
        fout.println();
        fout.println("Gaussian Probability plot ");
        fout.print("  Correlation coefficient", field1);
        fout.print(Fmath.truncate(this.transformedSampleR, 4), field2);
        fout.print(" ", field2);
        fout.println(Fmath.truncate(this.originalSampleR, 4));
        fout.print("  Gradient", field1);
        fout.print(Fmath.truncate(this.transformedGradient, 4), field2);
        fout.print(Fmath.truncate(this.transformedGradientError, 4), field2);
        fout.print(Fmath.truncate(this.originalGradient, 4), field2);
        fout.println(Fmath.truncate(this.originalGradientError, 4));
        fout.print("  Intercept", field1);
        fout.print(Fmath.truncate(this.transformedIntercept, 4), field2);
        fout.print(Fmath.truncate(this.transformedInterceptError, 4), field2);
        fout.print(Fmath.truncate(this.originalIntercept, 4), field2);
        fout.println(Fmath.truncate(this.originalInterceptError, 4));
        fout.println();
        fout.print("Data ");
        fout.println();
        fout.print("  Mean", field1);
        fout.print(Fmath.truncate(this.transformedMean, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMean, 4));
        fout.print("  Median", field1);
        fout.print(Fmath.truncate(this.transformedMedian, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMedian, 4));
        fout.print("  Standard deviation", field1);
        fout.print(Fmath.truncate(this.transformedStandardDeviation, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalStandardDeviation, 4));
        fout.print("  Standard error", field1);
        fout.print(Fmath.truncate(this.transformedStandardDeviation / Math.sqrt(this.nData), 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalStandardDeviation / Math.sqrt(this.nData), 4));
        fout.print("  Moment skewness", field1);
        fout.print(Fmath.truncate(this.transformedMomentSkewness, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMomentSkewness, 4));
        fout.print("  Median skewness", field1);
        fout.print(Fmath.truncate(this.transformedMedianSkewness, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMedianSkewness, 4));
        fout.print("  Quartile skewness", field1);
        fout.print(Fmath.truncate(this.transformedQuartileSkewness, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalQuartileSkewness, 4));
        fout.print("  Excess kurtosis", field1);
        fout.print(Fmath.truncate(this.transformedExcessKurtosis, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalExcessKurtosis, 4));
        fout.print("  Minimum", field1);
        fout.print(Fmath.truncate(this.transformedMinimum, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMinimum, 4));
        fout.print("  Maximum", field1);
        fout.print(Fmath.truncate(this.transformedMaximum, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalMaximum, 4));
        fout.print("  Range", field1);
        fout.print(Fmath.truncate(this.transformedRange, 4), field2);
        fout.print("  ", field2);
        fout.println(Fmath.truncate(this.originalRange, 4));
        fout.close();
    }
}

