/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigObject;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

final class PropertiesParser {
    PropertiesParser() {
    }

    static AbstractConfigObject parse(Reader reader, ConfigOrigin configOrigin) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return PropertiesParser.fromProperties(configOrigin, properties);
    }

    static String lastElement(String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return string2;
        }
        return string2.substring(n + 1);
    }

    static String exceptLastElement(String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string2.substring(0, n);
    }

    static Path pathFromPropertyKey(String string2) {
        String string3 = PropertiesParser.lastElement(string2);
        String string4 = PropertiesParser.exceptLastElement(string2);
        Path path = new Path(string3, null);
        while (string4 != null) {
            string3 = PropertiesParser.lastElement(string4);
            string4 = PropertiesParser.exceptLastElement(string4);
            path = new Path(string3, path);
        }
        return path;
    }

    static AbstractConfigObject fromProperties(ConfigOrigin configOrigin, Properties properties) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof String)) continue;
            Path path = PropertiesParser.pathFromPropertyKey((String)object);
            hashMap.put(path, entry.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, true);
    }

    static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<?, ?> map2) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object obj = entry.getKey();
            if (!(obj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            Path path = Path.newPath((String)obj);
            hashMap.put(path, entry.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, false);
    }

    private static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<Path, Object> map2, boolean bl) {
        AbstractConfigValue abstractConfigValue;
        Object object;
        Object object2;
        HashMap hashMap;
        Serializable serializable2;
        Object object3;
        HashSet<Path> hashSet = new HashSet<Path>();
        HashSet<Path> hashSet2 = new HashSet<Path>();
        for (Path serializable32 : map2.keySet()) {
            hashSet2.add(serializable32);
            for (object3 = serializable32.parent(); object3 != null; object3 = ((Path)object3).parent()) {
                hashSet.add((Path)object3);
            }
        }
        if (bl) {
            hashSet2.removeAll(hashSet);
        } else {
            for (Path path : hashSet2) {
                if (!hashSet.contains(path)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path.render() + "' occurs as both the parent object of a value and as a value. " + "Because Map has no defined ordering, this is a broken situation.");
            }
        }
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Path path : hashSet) {
            serializable2 = new HashMap();
            hashMap3.put(path, serializable2);
        }
        for (Path path : hashSet2) {
            serializable2 = path.parent();
            hashMap = serializable2 != null ? (Map)hashMap3.get(serializable2) : hashMap2;
            object2 = path.last();
            object = map2.get(path);
            abstractConfigValue = bl ? new ConfigString(configOrigin, (String)object) : ConfigImpl.fromAnyRef(map2.get(path), configOrigin, FromMapMode.KEYS_ARE_PATHS);
            hashMap.put(object2, abstractConfigValue);
        }
        object3 = new ArrayList();
        object3.addAll(hashSet);
        Collections.sort(object3, new Comparator<Path>(){

            @Override
            public int compare(Path path, Path path2) {
                return path2.length() - path.length();
            }
        });
        Iterator iterator2 = object3.iterator();
        while (iterator2.hasNext()) {
            serializable2 = (Path)iterator2.next();
            hashMap = (Map)hashMap3.get(serializable2);
            object2 = ((Path)serializable2).parent();
            object = object2 != null ? (Map)hashMap3.get(object2) : hashMap2;
            abstractConfigValue = new SimpleConfigObject(configOrigin, hashMap, ResolveStatus.RESOLVED, false);
            object.put(((Path)serializable2).last(), abstractConfigValue);
        }
        return new SimpleConfigObject(configOrigin, hashMap2, ResolveStatus.RESOLVED, false);
    }
}

