/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.parameters;

import com.googlecode.charts4j.parameters.AbstractParameter;

final class MarginsParameter
extends AbstractParameter {
    private static final String URL_PARAMETER_KEY = "chma";
    private int leftMargin = 0;
    private int rightMargin = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private LegendMargins legendMargins;

    MarginsParameter() {
    }

    void setMargins(int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    void setLegendMargins(int width, int height) {
        this.legendMargins = new LegendMargins(width, height);
    }

    public String getKey() {
        return URL_PARAMETER_KEY;
    }

    public String getValue() {
        String legendMarginsString = this.legendMargins != null ? "|" + this.legendMargins.width + "," + this.legendMargins.height : "";
        return this.leftMargin + "," + this.rightMargin + "," + this.topMargin + "," + this.bottomMargin + legendMarginsString;
    }

    private static class LegendMargins {
        private final int height;
        private final int width;

        private LegendMargins(int height, int width) {
            this.height = height;
            this.width = width;
        }
    }
}

