/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AbstractLineChart;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.Plot;
import com.googlecode.charts4j.PlotImpl;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Sets;
import com.googlecode.charts4j.parameters.ChartType;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYLineChart
extends AbstractLineChart {
    private final ImmutableList<Plot> xylines;

    XYLineChart(ImmutableList<? extends Plot> xylines) {
        super(xylines);
        this.xylines = Lists.copyOf(xylines);
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        for (Plot xyl : this.xylines) {
            PlotImpl xyline = (PlotImpl)xyl;
            PlotImpl xy = this.removeDuplicatePoints(xyline);
            this.parameterManager.addData(xy.getXData());
            this.parameterManager.addData(xy.getYData());
        }
        this.parameterManager.setChartTypeParameter(ChartType.XY_LINE_CHART);
    }

    private PlotImpl removeDuplicatePoints(PlotImpl xyline) {
        double[] yData;
        double[] xData = xyline.getXData().getData();
        if (xData.length != (yData = xyline.getYData().getData()).length) {
            return xyline;
        }
        Set<XYPoint> set = Sets.newLinkedHashSet();
        for (int i = 0; i < xData.length; ++i) {
            set.add(new XYPoint(xData[i], yData[i]));
        }
        double[] x2 = new double[set.size()];
        double[] y = new double[set.size()];
        int i = 0;
        for (XYPoint point : set) {
            x2[i] = point.x;
            y[i] = point.y;
            ++i;
        }
        return new PlotImpl(Data.newData(x2), Data.newData(y));
    }

    private static final class XYPoint {
        private final double x;
        private final double y;

        private XYPoint(double x2, double y) {
            this.x = x2;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof XYPoint)) {
                return false;
            }
            XYPoint objA = (XYPoint)obj;
            return this.x == objA.x && this.y == objA.y;
        }

        public int hashCode() {
            int hash2 = 1;
            hash2 = hash2 * 31 + Double.valueOf(this.x).hashCode();
            hash2 = hash2 * 31 + Double.valueOf(this.y).hashCode();
            return hash2;
        }
    }
}

