/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.DataUtil;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data {
    public static final double MIN_VALUE = 0.0;
    public static final double MAX_VALUE = 100.0;
    public static final Data INVALID = Data.newData(-1.0);
    private final double[] data;

    public Data(double ... data2) {
        Preconditions.checkNotNull(data2, "data is null or contents of data is null.");
        this.data = (double[])data2.clone();
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public final double[] getData() {
        return (double[])this.data.clone();
    }

    public final int getSize() {
        return this.data.length;
    }

    public static Data newData(double ... data2) {
        return new Data(data2);
    }

    public static Data newData(List<? extends Number> data2) {
        Preconditions.checkContentsNotNull(data2, "data is null or contents of data is null.");
        return new Data(DataUtil.toDoubleArray(Lists.copyOf(data2)));
    }
}

