/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.util;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.StringCharacterIterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Gpr {
    public static final int NUM_CORES = Runtime.getRuntime().availableProcessors();
    public static final String HOME = System.getProperty("user.home");

    public static String baseName(String file) {
        File f2 = new File(file);
        return f2.getName();
    }

    public static String baseName(String file, String ext) {
        File f2 = new File(file);
        String base = f2.getName();
        if (base.endsWith(ext)) {
            return base.substring(0, base.length() - ext.length());
        }
        return base;
    }

    public static String bin64(long l) {
        String bl = Long.toBinaryString(l);
        String out = "";
        int i = bl.length();
        while (i < 64) {
            out = String.valueOf(out) + "0";
            ++i;
        }
        return String.valueOf(out) + bl;
    }

    public static boolean canRead(String fileName) {
        File inputFile = new File(fileName);
        if (inputFile.exists()) {
            return true;
        }
        inputFile = new File(String.valueOf(fileName) + ".gz");
        return inputFile.exists();
    }

    public static int countLines(String file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int lines2 = 0;
            while (reader.readLine() != null) {
                ++lines2;
            }
            reader.close();
            return lines2;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void debug(Object obj) {
        Gpr.debug(obj, 1, true);
    }

    public static void debug(Object obj, int offset) {
        Gpr.debug(obj, offset, true);
    }

    public static void debug(Object obj, int offset, boolean newLine) {
        StackTraceElement ste = new Exception().getStackTrace()[1 + offset];
        String steStr = ste.getClassName();
        int ind = steStr.lastIndexOf(46);
        steStr = steStr.substring(ind + 1);
        steStr = String.valueOf(steStr) + "." + ste.getMethodName() + "(" + ste.getLineNumber() + "):\t" + (obj == null ? null : obj.toString());
        if (newLine) {
            System.err.println(steStr);
        } else {
            System.err.print(steStr);
        }
    }

    public static String dirName(String file) {
        File f2 = new File(file);
        return f2.getParent();
    }

    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static String extName(String file) {
        String base = Gpr.baseName(file);
        int idx = base.lastIndexOf(46);
        if (idx >= 0) {
            return base.substring(idx + 1);
        }
        return "";
    }

    public static Paint[] getPaints(int num) {
        return Gpr.getPaints(num, false);
    }

    public static Paint[] getPaints(int num, boolean goUp) {
        int jumpb;
        Paint[] paints = new Paint[num];
        int jump = 1;
        while (jump * jump * jump <= num) {
            ++jump;
        }
        int jumpr = jumpb;
        int jumpg = jumpb = jump;
        if ((jumpr - 1) * jumpg * jumpb <= num) {
            --jumpr;
        }
        if (jumpr * (jumpg - 1) * jumpb <= num) {
            --jumpg;
        }
        jumpr = jumpr > 1 ? 255 / (jumpr - 1) : 255;
        jumpg = jumpg > 1 ? 255 / (jumpg - 1) : 255;
        jumpb = jumpb > 1 ? 255 / (jumpb - 1) : 255;
        if (goUp) {
            int i = 0;
            int r = 0;
            while (r <= 255 && i < num) {
                int g = 0;
                while (g <= 255 && i < num) {
                    int b = 0;
                    while (b <= 255 && i < num) {
                        paints[i] = new Color(r, g, b);
                        b += jumpb;
                        ++i;
                    }
                    g += jumpg;
                }
                r += jumpr;
            }
        } else {
            int i = 0;
            int r = 255;
            while (r >= 0 && i < num) {
                int g = 255;
                while (g >= 0 && i < num) {
                    int b = 255;
                    while (b >= 0 && i < num) {
                        paints[i] = new Color(r, g, b);
                        b -= jumpb;
                        ++i;
                    }
                    g -= jumpg;
                }
                r -= jumpr;
            }
        }
        return paints;
    }

    public static StringBuffer inputStream2StringBuffer(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer file = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            file.append(String.valueOf(line) + "\n");
            line = reader.readLine();
        }
        return file;
    }

    public static boolean isInvalidRid(int rid) {
        return !Gpr.isValidRid(rid);
    }

    public static boolean isSimilName(String name1, String name2) {
        return name1.contains(name2) || name2.contains(name1);
    }

    public static boolean isValidInvoiceNumber(String invoiceNumber) {
        if (invoiceNumber == null || invoiceNumber.equals("")) {
            return false;
        }
        if (invoiceNumber.indexOf("-") == -1) {
            return false;
        }
        if (invoiceNumber.length() < 3) {
            return false;
        }
        String[] parts = invoiceNumber.split("-");
        if (parts.length != 2) {
            return false;
        }
        if (parts[0].length() > 4 || parts[0].length() < 1) {
            return false;
        }
        if (parts[1].length() > 8 || parts[1].length() < 1) {
            return false;
        }
        try {
            Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        try {
            int tmp = Integer.parseInt(parts[1]);
            return tmp != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidIp(String ip) {
        if (ip == null) {
            return false;
        }
        String[] ipSplitted = ip.split("\\.");
        if (ipSplitted.length != 4) {
            return false;
        }
        int i = 0;
        while (i < ipSplitted.length) {
            if (ipSplitted[i].length() > 3) {
                return false;
            }
            try {
                int ipPart = Integer.parseInt(ipSplitted[i]);
                if (ipPart < 0 || ipPart > 255) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidRid(int i) {
        return i > 0;
    }

    public static String noSpaces(String str) {
        String[] lines2 = str.split("\n");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines2;
        int n = lines2.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            sb.append(String.valueOf(line.trim().replaceAll("\\s", "")) + "\n");
            ++n2;
        }
        return sb.toString();
    }

    public static boolean parseBoolSafe(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static double parseDoubleSafe(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static float parseFloatSafe(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static int parseIntSafe(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long parseLongSafe(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static BufferedReader reader(String fileName) {
        return Gpr.reader(fileName, false);
    }

    public static BufferedReader reader(String fileName, boolean gzip) {
        BufferedReader reader = null;
        try {
            if (fileName.equals("-")) {
                return new BufferedReader(new InputStreamReader(System.in));
            }
            if (fileName.endsWith(".gz") || gzip) {
                File inputFile = new File(fileName);
                if (inputFile.exists()) {
                    return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(fileName)))));
                }
                throw new RuntimeException("File not found '" + fileName + "'");
            }
            File inputFile = new File(fileName);
            if (inputFile.exists()) {
                return new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));
            }
            String fileNameGz = String.valueOf(fileName) + ".gz";
            inputFile = new File(fileNameGz);
            if (inputFile.exists()) {
                return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(fileNameGz)))));
            }
            throw new RuntimeException("File not found '" + fileName + "'");
        }
        catch (FileNotFoundException e) {
            reader = null;
            Gpr.debug(e);
        }
        catch (IOException e) {
            reader = null;
            Gpr.debug(e);
        }
        return reader;
    }

    public static String readFile(String fileName) {
        StringBuffer strb = new StringBuffer();
        char[] buff = new char[10240];
        int len = 0;
        try {
            BufferedReader inFile = Gpr.reader(fileName);
            while ((len = inFile.read(buff)) >= 0) {
                strb.append(buff, 0, len);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return strb.toString();
    }

    public static Object readFileSerialized(String fileName) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readFileSerializedGz(String fileName) {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object readFileSerializedGzThrow(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    public static String removeExt(String file) {
        int lastDot = file.lastIndexOf(46);
        if (lastDot >= 0) {
            return file.substring(0, lastDot);
        }
        return file;
    }

    public static String removeExt(String file, String[] fileExtensions) {
        String[] stringArray = fileExtensions;
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (file.toLowerCase().endsWith(ext)) {
                return file.substring(0, file.length() - ext.length());
            }
            ++n2;
        }
        return file;
    }

    public static void showMark(int i, int showEvery) {
        if (showEvery <= 0) {
            return;
        }
        if (i % showEvery == 0) {
            if (i % (100 * showEvery) == 0) {
                System.err.print(".\n" + i + "\t");
            } else {
                System.err.print('.');
            }
        }
    }

    public static void showMarkStderr(int i, int showEvery) {
        if (i % showEvery == 0) {
            if (i % (100 * showEvery) == 0) {
                System.err.print(".\n" + i + "\t");
            } else {
                System.err.print('.');
            }
        }
    }

    public static void showStackTrace(int steps) {
        Gpr.showStackTrace(steps, 1);
    }

    public static void showStackTrace(int steps, int offset) {
        Exception e = new Exception();
        String sep = "";
        int i = 0;
        while (i < steps) {
            int num = i + offset + 1;
            if (num < e.getStackTrace().length) {
                StackTraceElement ste = e.getStackTrace()[num];
                String steStr = ste.getClassName();
                int ind = steStr.lastIndexOf(46);
                steStr = steStr.substring(ind + 1);
                steStr = String.valueOf(steStr) + "." + ste.getMethodName() + "(" + ste.getLineNumber() + "):";
                System.err.println(String.valueOf(sep) + steStr);
                sep = "\t";
            }
            ++i;
        }
    }

    public static String[] split(String value2, char delim) {
        if (value2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value2, delim);
        return st.tokens(String.class);
    }

    public static String tabs(int tabs) {
        String t2 = "";
        int i = 0;
        while (i < tabs) {
            t2 = String.valueOf(t2) + "\t";
            ++i;
        }
        return t2;
    }

    public static void toFile(String fileName, Object obj) {
        Gpr.toFile(fileName, obj, false);
    }

    public static void toFile(String fileName, Object obj, boolean append2) {
        try {
            BufferedWriter outFile = new BufferedWriter(new FileWriter(fileName, append2));
            outFile.write(obj.toString());
            outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileGz(String fileName, Object obj) {
        try {
            PrintStream outFile = new PrintStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            outFile.print(obj.toString());
            outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileSerialize(String fileName, Object obj) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(fileName));
            out.writeObject(obj);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFileSerializeGz(String fileName, Object obj) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            out.writeObject(obj);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StringTokenizer {
        String string = null;
        int tokens = 0;
        int[] separatorPosition = new int[1000];

        StringTokenizer(String value2, char delim) {
            this.string = value2;
            StringCharacterIterator sci = new StringCharacterIterator(this.string);
            char c = sci.first();
            while (c != '\uffff') {
                if (c == delim) {
                    this.separatorPosition[this.tokens] = sci.getIndex();
                    ++this.tokens;
                    if (this.tokens >= this.separatorPosition.length) {
                        int[] copy = new int[this.separatorPosition.length * 10];
                        System.arraycopy(this.separatorPosition, 0, copy, 0, this.separatorPosition.length);
                        this.separatorPosition = copy;
                    }
                }
                c = sci.next();
            }
            ++this.tokens;
        }

        <T> T[] tokens(Class<T> componentType) {
            Constructor<T> ctor;
            Object[] r = (Object[])Array.newInstance(componentType, this.tokens);
            try {
                ctor = componentType.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot create an array of type [" + componentType + "] from an array of String. The type [" + componentType.getSimpleName() + "] must define a single arg constructor that takes a String.class instance.");
            }
            String currentValue = null;
            int i = 0;
            try {
                int start = 0;
                i = 0;
                while (i < this.tokens) {
                    int length;
                    int nextStart = this.separatorPosition[i];
                    if (i == this.tokens - 1) {
                        nextStart = this.string.length();
                    }
                    if ((length = nextStart - start) > 0) {
                        currentValue = this.string.substring(start, nextStart);
                        r[i] = ctor.newInstance(currentValue);
                    }
                    start = nextStart + 1;
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create an instance of type [" + componentType + "] from the " + i + "th string value [" + currentValue + "].", e);
            }
            return r;
        }
    }
}

