/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.IntStats;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;

public class AlleleFrequencyStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    IntStats count = new IntStats();

    public IntStats getCount() {
        return this.count;
    }

    @Override
    public boolean hasData() {
        return this.count.isValidData();
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (!vcfEntry.isSnp() || !vcfEntry.isVariant()) {
            return;
        }
        int genotypes = vcfEntry.getVcfGenotypes().size();
        String[] alts = vcfEntry.getAlts();
        int[] countGenotypes = new int[alts.length + 1];
        if (genotypes > 0) {
            for (VcfGenotype vcfGenotype : vcfEntry) {
                if (!vcfGenotype.isVariant()) continue;
                int[] gens = vcfGenotype.getGenotype();
                if (gens == null) {
                    gens = GENOTYPE_SINGLE_ALT_CHANGE;
                }
                int[] nArray = gens;
                int n = gens.length;
                int n2 = 0;
                while (n2 < n) {
                    int gen = nArray[n2];
                    if (gen > 0) {
                        int n3 = gen;
                        countGenotypes[n3] = countGenotypes[n3] + 1;
                    }
                    ++n2;
                }
            }
            int[] nArray = countGenotypes;
            int n = countGenotypes.length;
            int n4 = 0;
            while (n4 < n) {
                int c = nArray[n4];
                if (c > 0) {
                    this.count.sample(c);
                }
                ++n4;
            }
        } else {
            this.count.sample(1);
        }
    }

    public String toString() {
        return this.count.toString();
    }
}

