/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.stats.FisherExactTest;
import ca.mcgill.mcb.pcingola.stats.Hypergeometric;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesHypergeometric
extends TestCase {
    boolean verbose = true;
    double threshold = 0.01;
    int numTests = 100;
    int MAX = 1000;
    Random rand;

    public TestCasesHypergeometric() {
        this.initRand();
    }

    void compareFisherDown(int k, int N, int D, int n, double result2) {
        double p = FisherExactTest.get().pValueDown(k, N, D, n, this.threshold);
        double abs = Math.abs(p - result2);
        double diff2 = abs / Math.min(p, result2);
        if (abs > 1.0E-300 && diff2 > 1.0E-5) {
            String err2 = "Difference:" + diff2 + "\n\t\tpValue:\t" + p + "\n\tExpected:\t" + result2 + "\n\tR: " + FisherExactTest.get().toR(k, N, D, n, true);
            Gpr.debug(err2);
            throw new RuntimeException(err2);
        }
    }

    void compareFisherUp(int k, int N, int D, int n, double result2) {
        double p = FisherExactTest.get().pValueUp(k, N, D, n, this.threshold);
        double abs = Math.abs(p - result2);
        double diff2 = abs / Math.min(p, result2);
        if (abs > 1.0E-300 && diff2 > 1.0E-5) {
            String err2 = "Difference:" + diff2 + "\n\t\tpValue:\t" + p + "\n\tExpected:\t" + result2 + "\n\tR: " + FisherExactTest.get().toR(k, N, D, n, false);
            Gpr.debug(err2);
            throw new RuntimeException(err2);
        }
    }

    void compareHypergeometric(int k, int N, int D, int n, double result2) {
        double p = Hypergeometric.get().hypergeometric(k, N, D, n);
        double abs = Math.abs(p - result2);
        double diff2 = abs / Math.min(p, result2);
        if (abs > 1.0E-300 && diff2 > 1.0E-5) {
            throw new RuntimeException("Difference:" + diff2 + "\t\t" + p + " != " + result2);
        }
    }

    public void generate_test() {
        boolean lowerTail = true;
        int i = 0;
        while (i < this.numTests) {
            double p;
            int N = this.rand.nextInt(this.MAX) + 1;
            int D = this.rand.nextInt(N) + 1;
            int n = this.rand.nextInt(N) + 1;
            int k = Math.max(this.rand.nextInt(Math.min(n, D)), 1);
            if (!Hypergeometric.get().checkHypergeometricParams(k, N, D, n) || !((p = FisherExactTest.get().pValueDown(k, N, D, n, this.threshold)) < this.threshold)) continue;
            System.out.print("\t print ( paste( 'compareFisher( " + k + ", " + N + ", " + D + ", " + n + ", ' , " + FisherExactTest.get().toR(k, N, D, n, lowerTail) + " , ');' ) );");
            System.out.println("");
            ++i;
        }
    }

    void initRand() {
        this.rand = new Random(20110124L);
    }

    public void test_0() {
    }

    public void test_01_hyper() {
        this.compareHypergeometric(1, 19, 2, 12, 0.4912281);
        this.compareHypergeometric(1, 70, 51, 1, 0.7285714);
        this.compareHypergeometric(7, 73, 9, 38, 0.0773475);
        this.compareHypergeometric(4, 45, 11, 5, 0.00918348);
        this.compareHypergeometric(4, 33, 17, 14, 0.02327653);
        this.compareHypergeometric(3, 28, 5, 7, 0.07478632);
        this.compareHypergeometric(1, 73, 31, 2, 0.4954338);
        this.compareHypergeometric(1, 2, 1, 2, 1.0);
        this.compareHypergeometric(1, 10, 1, 3, 0.3);
        this.compareHypergeometric(1, 78, 57, 11, 2.584604E-6);
        this.compareHypergeometric(3, 45, 17, 23, 5.133975E-4);
        this.compareHypergeometric(4, 86, 59, 11, 0.01652058);
        this.compareHypergeometric(1, 28, 5, 22, 0.003357753);
        this.compareHypergeometric(1, 42, 4, 30, 0.05896542);
        this.compareHypergeometric(12, 95, 13, 49, 0.001216176);
        this.compareHypergeometric(1, 45, 2, 27, 0.4909091);
        this.compareHypergeometric(1, 38, 3, 14, 0.458037);
        this.compareHypergeometric(1, 43, 22, 5, 0.1367861);
        this.compareHypergeometric(1, 25, 2, 6, 0.38);
        this.compareHypergeometric(7, 80, 34, 13, 0.1598987);
        this.compareHypergeometric(1, 78, 34, 3, 0.4227877);
        this.compareHypergeometric(1, 88, 9, 70, 5.361089E-6);
        this.compareHypergeometric(1, 13, 11, 2, 0.2820513);
        this.compareHypergeometric(1, 36, 4, 22, 0.1359477);
        this.compareHypergeometric(1, 20, 6, 7, 0.2324303);
        this.compareHypergeometric(1, 21, 9, 4, 0.3308271);
        this.compareHypergeometric(1, 39, 6, 1, 0.1538462);
        this.compareHypergeometric(5, 19, 9, 12, 0.3000714);
        this.compareHypergeometric(1, 1, 1, 1, 1.0);
        this.compareHypergeometric(1, 10, 5, 3, 0.4166667);
        this.compareHypergeometric(1, 86, 2, 67, 0.34829);
        this.compareHypergeometric(1, 21, 4, 6, 0.4561404);
        this.compareHypergeometric(29, 92, 43, 55, 0.06424561);
        this.compareHypergeometric(1, 23, 2, 21, 0.1660079);
        this.compareHypergeometric(5, 72, 7, 24, 0.03254646);
        this.compareHypergeometric(19, 64, 29, 54, 1.322347E-4);
        this.compareHypergeometric(1, 40, 3, 35, 0.0354251);
        this.compareHypergeometric(6, 18, 7, 13, 0.2696078);
        this.compareHypergeometric(1, 8, 2, 5, 0.5357143);
        this.compareHypergeometric(15, 80, 31, 21, 4.160716E-4);
        this.compareHypergeometric(3, 32, 18, 13, 0.002351405);
        this.compareHypergeometric(13, 35, 22, 18, 0.1410843);
        this.compareHypergeometric(7, 63, 45, 15, 0.01625885);
        this.compareHypergeometric(1, 17, 14, 4, 0.005882353);
        this.compareHypergeometric(2, 20, 6, 15, 0.01354489);
        this.compareHypergeometric(1, 10, 8, 2, 0.3555556);
        this.compareHypergeometric(1, 2, 1, 2, 1.0);
        this.compareHypergeometric(1, 94, 2, 93, 0.0212766);
        this.compareHypergeometric(11, 49, 22, 25, 0.2238699);
        this.compareHypergeometric(11, 95, 20, 27, 0.003754185);
        this.compareHypergeometric(1, 21, 9, 2, 0.5142857);
        this.compareHypergeometric(1, 6, 2, 2, 0.5333333);
        this.compareHypergeometric(2, 18, 9, 7, 0.1425339);
        this.compareHypergeometric(16, 61, 40, 36, 1.500428E-5);
        this.compareHypergeometric(2, 54, 7, 5, 0.1076724);
        this.compareHypergeometric(1, 89, 1, 47, 0.5280899);
        this.compareHypergeometric(2, 26, 5, 13, 0.3391304);
        this.compareHypergeometric(1, 75, 1, 24, 0.32);
        this.compareHypergeometric(2, 21, 10, 12, 0.001684074);
        this.compareHypergeometric(1, 64, 8, 7, 0.4181274);
        this.compareHypergeometric(16, 89, 45, 48, 3.430746E-4);
        this.compareHypergeometric(26, 56, 39, 37, 0.2367166);
        this.compareHypergeometric(10, 30, 16, 11, 0.002052307);
        this.compareHypergeometric(11, 92, 30, 68, 4.373004E-8);
        this.compareHypergeometric(17, 61, 46, 19, 0.06186141);
        this.compareHypergeometric(15, 70, 28, 17, 4.092152E-6);
        this.compareHypergeometric(6, 55, 19, 33, 0.001963553);
        this.compareHypergeometric(18, 71, 57, 31, 3.427275E-5);
        this.compareHypergeometric(48, 95, 62, 66, 0.01405199);
        this.compareHypergeometric(3, 46, 8, 34, 0.01816302);
        this.compareHypergeometric(3, 26, 8, 20, 0.00437823);
        this.compareHypergeometric(4, 69, 9, 47, 0.08288145);
        this.compareHypergeometric(13, 78, 57, 28, 1.087879E-4);
        this.compareHypergeometric(20, 68, 24, 37, 3.32827E-4);
        this.compareHypergeometric(5, 89, 7, 23, 0.01047522);
        this.compareHypergeometric(3, 12, 5, 10, 0.1515152);
        this.compareHypergeometric(16, 65, 29, 47, 0.005136288);
        this.compareHypergeometric(5, 76, 12, 6, 2.318555E-4);
        this.compareHypergeometric(2, 43, 15, 8, 0.2727957);
        this.compareHypergeometric(3, 46, 12, 35, 9.25133E-6);
        this.compareHypergeometric(3, 92, 18, 4, 0.02161083);
        this.compareHypergeometric(2, 87, 47, 7, 0.1217291);
        this.compareHypergeometric(1, 26, 6, 11, 0.1434783);
        this.compareHypergeometric(1, 36, 3, 28, 0.1098039);
        this.compareHypergeometric(1, 34, 1, 24, 0.7058824);
        this.compareHypergeometric(1, 88, 1, 81, 0.9204545);
        this.compareHypergeometric(1, 2, 2, 1, 1.0);
        this.compareHypergeometric(5, 23, 12, 7, 0.1776821);
        this.compareHypergeometric(1, 21, 3, 2, 0.2571429);
        this.compareHypergeometric(4, 83, 30, 55, 3.705065E-15);
        this.compareHypergeometric(1, 63, 1, 61, 0.968254);
        this.compareHypergeometric(1, 99, 20, 5, 0.420144);
        this.compareHypergeometric(1, 73, 2, 36, 0.5068493);
        this.compareHypergeometric(1, 65, 38, 2, 0.4932692);
        this.compareHypergeometric(1, 54, 1, 51, 0.9444444);
        this.compareHypergeometric(1, 5, 1, 4, 0.8);
        this.compareHypergeometric(1, 1, 1, 1, 1.0);
        this.compareHypergeometric(1, 48, 1, 10, 0.2083333);
        this.compareHypergeometric(1, 71, 63, 2, 0.2028169);
        this.compareHypergeometric(1, 46, 6, 20, 0.1404532);
        this.compareHypergeometric(1, 70, 1, 65, 0.9285714);
        this.compareHypergeometric(31, 70, 34, 60, 0.1259187);
        this.compareHypergeometric(1, 17, 1, 5, 0.2941176);
        this.compareHypergeometric(5, 30, 9, 13, 0.214093);
        this.compareHypergeometric(1, 26, 4, 15, 0.1655518);
        this.compareHypergeometric(30, 93, 51, 57, 0.1471864);
        this.compareHypergeometric(11, 17, 13, 13, 0.1966387);
        this.compareHypergeometric(1, 25, 4, 2, 0.28);
        this.compareHypergeometric(1, 5, 4, 1, 0.8);
        this.compareHypergeometric(27, 89, 40, 28, 5.527519E-12);
        this.compareHypergeometric(9, 53, 25, 25, 0.06875583);
        this.compareHypergeometric(2, 18, 12, 6, 0.05332902);
        this.compareHypergeometric(1, 40, 21, 18, 3.167218E-8);
    }

    public void test_02_hyper() {
        this.compareHypergeometric(57, 470, 141, 281, 1.507456E-8);
        this.compareHypergeometric(152, 912, 754, 203, 4.373848E-4);
        this.compareHypergeometric(44, 682, 324, 82, 0.04638736);
        this.compareHypergeometric(21, 373, 32, 294, 0.03056803);
        this.compareHypergeometric(59, 545, 136, 95, 7.273835E-18);
        this.compareHypergeometric(36, 345, 190, 41, 2.082751E-6);
        this.compareHypergeometric(46, 770, 68, 535, 0.1018642);
        this.compareHypergeometric(129, 833, 418, 241, 0.02855101);
        this.compareHypergeometric(3, 28, 5, 7, 0.07478632);
        this.compareHypergeometric(14, 873, 552, 42, 4.038633E-5);
        this.compareHypergeometric(97, 202, 133, 105, 1.128978E-17);
        this.compareHypergeometric(152, 610, 181, 333, 8.438052E-23);
        this.compareHypergeometric(135, 444, 142, 138, 6.925182E-101);
        this.compareHypergeometric(7, 486, 25, 51, 0.00781056);
        this.compareHypergeometric(1, 42, 4, 30, 0.05896542);
        this.compareHypergeometric(41, 145, 82, 72, 0.1323862);
        this.compareHypergeometric(152, 738, 203, 446, 2.215361E-7);
        this.compareHypergeometric(16, 911, 728, 164, 1.023263E-115);
        this.compareHypergeometric(37, 243, 54, 187, 0.03645426);
        this.compareHypergeometric(2, 152, 51, 41, 8.419947E-7);
        this.compareHypergeometric(117, 480, 274, 253, 1.791619E-7);
        this.compareHypergeometric(247, 578, 388, 283, 3.29638E-25);
        this.compareHypergeometric(429, 888, 817, 446, 1.650871E-6);
        this.compareHypergeometric(1, 913, 749, 4, 0.01879589);
        this.compareHypergeometric(4, 236, 192, 10, 0.003181798);
        this.compareHypergeometric(1, 620, 6, 207, 0.2627278);
        this.compareHypergeometric(269, 351, 311, 287, 1.610554E-8);
        this.compareHypergeometric(27, 521, 155, 357, 3.076794E-60);
        this.compareHypergeometric(7, 461, 151, 184, 7.18484E-32);
        this.compareHypergeometric(5, 924, 236, 23, 0.1826543);
        this.compareHypergeometric(30, 601, 236, 60, 0.0224787);
        this.compareHypergeometric(29, 510, 305, 203, 5.85835E-71);
        this.compareHypergeometric(29, 92, 43, 55, 0.06424561);
        this.compareHypergeometric(12, 634, 42, 295, 0.006764663);
        this.compareHypergeometric(13, 237, 88, 156, 2.39519E-40);
        this.compareHypergeometric(91, 523, 106, 234, 1.382574E-22);
        this.compareHypergeometric(89, 572, 403, 188, 6.492409E-17);
        this.compareHypergeometric(35, 964, 146, 102, 1.617078E-7);
        this.compareHypergeometric(23, 470, 58, 108, 0.001111836);
        this.compareHypergeometric(65, 755, 119, 162, 1.070822E-18);
        this.compareHypergeometric(15, 380, 151, 21, 0.002024582);
        this.compareHypergeometric(24, 173, 63, 55, 0.0544751);
        this.compareHypergeometric(29, 707, 33, 649, 0.1576592);
        this.compareHypergeometric(27, 335, 172, 173, 4.587644E-46);
        this.compareHypergeometric(8, 117, 36, 18, 0.08555023);
        this.compareHypergeometric(17, 206, 36, 50, 5.816399E-4);
        this.compareHypergeometric(1, 10, 8, 2, 0.3555556);
        this.compareHypergeometric(33, 149, 48, 87, 0.03005922);
        this.compareHypergeometric(1, 402, 343, 30, 1.218651E-26);
        this.compareHypergeometric(109, 521, 110, 472, 6.95748E-5);
        this.compareHypergeometric(66, 306, 122, 206, 3.471764E-5);
        this.compareHypergeometric(16, 61, 40, 36, 1.500428E-5);
        this.compareHypergeometric(32, 554, 163, 301, 3.947078E-27);
        this.compareHypergeometric(30, 789, 310, 52, 0.00249105);
        this.compareHypergeometric(42, 726, 155, 45, 4.110391E-27);
        this.compareHypergeometric(293, 803, 481, 450, 1.804299E-4);
        this.compareHypergeometric(131, 375, 151, 249, 1.094179E-12);
        this.compareHypergeometric(210, 321, 274, 246, 0.1475397);
        this.compareHypergeometric(8, 789, 388, 277, 3.078242E-96);
        this.compareHypergeometric(260, 556, 539, 277, 5.566594E-6);
        this.compareHypergeometric(82, 130, 116, 91, 0.2064143);
        this.compareHypergeometric(3, 461, 374, 7, 0.02295504);
        this.compareHypergeometric(2, 890, 10, 796, 4.312254E-7);
        this.compareHypergeometric(42, 770, 308, 367, 6.205572E-58);
        this.compareHypergeometric(6, 55, 19, 33, 0.001963553);
        this.compareHypergeometric(4, 171, 92, 47, 3.491095E-14);
        this.compareHypergeometric(310, 995, 327, 976, 3.646995E-7);
        this.compareHypergeometric(2, 184, 34, 28, 0.05393918);
        this.compareHypergeometric(82, 669, 183, 338, 0.01339627);
        this.compareHypergeometric(1, 278, 3, 152, 0.3379183);
        this.compareHypergeometric(183, 868, 584, 305, 2.243882E-4);
        this.compareHypergeometric(13, 112, 93, 30, 2.834419E-10);
        this.compareHypergeometric(26, 143, 33, 81, 0.001992269);
        this.compareHypergeometric(19, 146, 20, 71, 3.193124E-6);
        this.compareHypergeometric(73, 392, 154, 304, 4.244224E-32);
        this.compareHypergeometric(2, 87, 47, 7, 0.1217291);
        this.compareHypergeometric(13, 336, 15, 256, 0.1726304);
        this.compareHypergeometric(1, 385, 30, 144, 7.79075E-6);
        this.compareHypergeometric(35, 488, 97, 57, 1.079242E-13);
        this.compareHypergeometric(2, 302, 168, 7, 0.1104994);
        this.compareHypergeometric(5, 23, 12, 7, 0.1776821);
        this.compareHypergeometric(119, 983, 628, 145, 1.421082E-7);
        this.compareHypergeometric(324, 663, 403, 541, 0.05047842);
        this.compareHypergeometric(1, 99, 20, 5, 0.420144);
        this.compareHypergeometric(1, 741, 671, 2, 0.1713171);
        this.compareHypergeometric(1, 73, 2, 36, 0.5068493);
        this.compareHypergeometric(47, 554, 101, 407, 8.9411E-11);
        this.compareHypergeometric(1, 152, 59, 4, 0.3582004);
        this.compareHypergeometric(18, 505, 326, 129, 2.489987E-44);
        this.compareHypergeometric(45, 148, 53, 50, 5.759724E-24);
        this.compareHypergeometric(19, 446, 46, 26, 1.422818E-15);
        this.compareHypergeometric(1, 178, 3, 142, 0.09679974);
        this.compareHypergeometric(607, 770, 734, 620, 2.162936E-9);
        this.compareHypergeometric(185, 546, 206, 407, 1.97752E-11);
        this.compareHypergeometric(136, 917, 169, 294, 7.691036E-48);
        this.compareHypergeometric(31, 321, 108, 43, 2.813547E-8);
        this.compareHypergeometric(16, 515, 475, 39, 3.418161E-19);
        this.compareHypergeometric(91, 926, 340, 335, 1.576175E-6);
        this.compareHypergeometric(97, 396, 167, 106, 1.4462E-35);
        this.compareHypergeometric(7, 305, 14, 51, 0.002821931);
    }

    public void test_03_fisher() {
        this.compareFisherUp(59, 545, 136, 95, 8.28958173422445E-18);
        this.compareFisherUp(36, 345, 190, 41, 2.40265087580901E-6);
        this.compareFisherUp(97, 202, 133, 105, 1.18466240918432E-17);
        this.compareFisherUp(152, 610, 181, 333, 9.77424907183547E-23);
        this.compareFisherUp(135, 444, 142, 138, 6.928747246508E-101);
        this.compareFisherUp(152, 738, 203, 446, 3.67088986300015E-7);
        this.compareFisherUp(247, 578, 388, 283, 3.79404002619577E-25);
        this.compareFisherUp(429, 888, 817, 446, 2.26456109642847E-6);
        this.compareFisherUp(269, 351, 311, 287, 1.82978544974049E-8);
        this.compareFisherUp(91, 523, 106, 234, 1.50955326758971E-22);
        this.compareFisherUp(35, 964, 146, 102, 2.21430371305547E-7);
        this.compareFisherUp(23, 470, 58, 108, 0.00174305424896066);
        this.compareFisherUp(65, 755, 119, 162, 1.25368328189431E-18);
        this.compareFisherUp(15, 380, 151, 21, 0.00257864863363782);
        this.compareFisherUp(17, 206, 36, 50, 7.67632652092611E-4);
        this.compareFisherUp(109, 521, 110, 472, 7.4260450370284E-5);
        this.compareFisherUp(30, 789, 310, 52, 0.00423623853376874);
        this.compareFisherUp(42, 726, 155, 45, 4.16785300462029E-27);
        this.compareFisherUp(293, 803, 481, 450, 4.38131577741957E-4);
        this.compareFisherUp(131, 375, 151, 249, 1.30995155177008E-12);
        this.compareFisherUp(26, 143, 33, 81, 0.00262084046420338);
        this.compareFisherUp(19, 146, 20, 71, 3.30381924570966E-6);
        this.compareFisherUp(35, 488, 97, 57, 1.20102019250494E-13);
        this.compareFisherUp(119, 983, 628, 145, 2.10926932575014E-7);
        this.compareFisherUp(45, 148, 53, 50, 5.81512027352164E-24);
        this.compareFisherUp(19, 446, 46, 26, 1.45759552943497E-15);
        this.compareFisherUp(607, 770, 734, 620, 2.4342390531863E-9);
        this.compareFisherUp(185, 546, 206, 407, 2.49420910249361E-11);
        this.compareFisherUp(136, 917, 169, 294, 8.2186630995667E-48);
        this.compareFisherUp(31, 321, 108, 43, 3.27189426625206E-8);
        this.compareFisherUp(97, 396, 167, 106, 1.48934787720076E-35);
        this.compareFisherUp(7, 305, 14, 51, 0.00331494622577636);
        this.compareFisherUp(71, 835, 75, 483, 7.2876824125444E-14);
        this.compareFisherUp(37, 461, 70, 181, 0.00876705910701063);
        this.compareFisherUp(198, 761, 318, 432, 0.00580370806914619);
        this.compareFisherUp(133, 936, 378, 195, 8.99332118627283E-19);
        this.compareFisherUp(23, 291, 65, 50, 3.31838151428692E-5);
        this.compareFisherUp(63, 560, 67, 190, 2.1131322965245E-28);
        this.compareFisherUp(44, 115, 71, 49, 3.89847129521515E-8);
        this.compareFisherUp(153, 800, 195, 527, 9.21709696267346E-6);
        this.compareFisherUp(37, 397, 67, 156, 0.00285215778284655);
        this.compareFisherUp(94, 433, 212, 130, 1.18080726821783E-10);
        this.compareFisherUp(629, 915, 873, 636, 5.48138806189002E-13);
        this.compareFisherUp(225, 687, 254, 282, 3.86407484833323E-91);
        this.compareFisherUp(187, 550, 221, 305, 2.28319162936954E-31);
        this.compareFisherUp(183, 812, 194, 725, 0.00473364047467412);
        this.compareFisherUp(75, 531, 142, 193, 1.99243069292124E-6);
        this.compareFisherUp(133, 897, 158, 661, 4.4883940423697E-4);
        this.compareFisherUp(168, 973, 227, 599, 5.28590254525447E-6);
        this.compareFisherUp(266, 492, 375, 276, 5.17872981915267E-35);
        this.compareFisherUp(142, 814, 161, 579, 1.1947296127053E-8);
        this.compareFisherUp(114, 713, 149, 177, 3.80835210298479E-54);
        this.compareFisherUp(49, 174, 61, 92, 5.76190646498642E-8);
        this.compareFisherUp(70, 361, 243, 88, 0.00300291746372154);
        this.compareFisherUp(11, 417, 31, 56, 9.8764195265165E-4);
        this.compareFisherUp(36, 537, 157, 41, 4.94220221304424E-16);
        this.compareFisherUp(115, 471, 182, 175, 1.56291175266919E-20);
        this.compareFisherUp(495, 881, 523, 763, 2.98889043133355E-17);
        this.compareFisherUp(241, 674, 307, 457, 3.14514846186333E-8);
        this.compareFisherUp(200, 443, 303, 242, 1.08062874506896E-12);
        this.compareFisherUp(353, 987, 554, 366, 3.06547860908313E-101);
        this.compareFisherUp(11, 300, 71, 20, 0.00172542325090638);
        this.compareFisherUp(42, 252, 204, 44, 0.00318184189489258);
        this.compareFisherUp(51, 305, 80, 53, 1.47808357334896E-34);
        this.compareFisherUp(34, 313, 176, 46, 0.0062078519294078);
        this.compareFisherUp(24, 373, 25, 268, 0.0021702822049755);
        this.compareFisherUp(47, 677, 141, 48, 3.36388120818521E-34);
        this.compareFisherUp(41, 328, 65, 89, 5.84598356867524E-12);
        this.compareFisherUp(65, 559, 190, 81, 2.05254736770733E-20);
        this.compareFisherUp(75, 984, 299, 165, 5.27613211166751E-6);
        this.compareFisherUp(92, 270, 95, 240, 0.00107752920684479);
        this.compareFisherUp(203, 969, 612, 220, 1.65237135169329E-28);
        this.compareFisherUp(168, 255, 194, 194, 3.59390288867635E-11);
        this.compareFisherUp(25, 395, 74, 31, 4.64779278697149E-15);
        this.compareFisherUp(154, 621, 171, 426, 3.32248893082949E-14);
        this.compareFisherUp(12, 327, 148, 15, 0.00569010303563112);
        this.compareFisherUp(80, 772, 97, 245, 1.60368435504478E-28);
        this.compareFisherUp(21, 654, 138, 25, 1.04540516516679E-11);
        this.compareFisherUp(119, 432, 121, 285, 8.46674711440474E-24);
        this.compareFisherUp(200, 672, 245, 202, 3.72458025046742E-123);
        this.compareFisherUp(13, 675, 19, 137, 5.33314581564644E-6);
        this.compareFisherUp(48, 299, 70, 119, 2.51027306645499E-8);
        this.compareFisherUp(197, 694, 250, 432, 4.58839930028976E-12);
        this.compareFisherUp(103, 823, 210, 295, 3.59407139405134E-6);
        this.compareFisherUp(73, 235, 108, 102, 3.222899986319E-12);
        this.compareFisherUp(565, 848, 684, 623, 2.88228387511532E-31);
        this.compareFisherUp(364, 582, 426, 384, 6.72059678081954E-61);
        this.compareFisherUp(39, 781, 42, 145, 2.07138402016061E-27);
        this.compareFisherUp(179, 371, 184, 302, 1.23670887007989E-16);
        this.compareFisherUp(159, 541, 459, 170, 4.77152383854613E-5);
        this.compareFisherUp(137, 675, 190, 233, 5.40690104095474E-37);
        this.compareFisherUp(360, 800, 406, 372, 1.17796424900086E-155);
        this.compareFisherUp(281, 736, 303, 620, 3.36267010147432E-8);
        this.compareFisherUp(504, 795, 644, 606, 0.0044212941820773);
        this.compareFisherUp(141, 450, 183, 209, 5.03306096804749E-28);
        this.compareFisherUp(247, 968, 390, 299, 2.01859193466352E-74);
        this.compareFisherUp(25, 172, 51, 54, 0.00131684344612187);
        this.compareFisherUp(54, 757, 220, 71, 6.58948512308768E-18);
        this.compareFisherUp(70, 301, 180, 97, 0.00172465566053411);
        this.compareFisherUp(194, 683, 500, 204, 1.56219065349161E-20);
    }

    public void test_04_fisher() {
        this.compareFisherDown(57, 470, 141, 281, 6.6866974987128E-9);
        this.compareFisherDown(152, 912, 754, 203, 4.40144803784442E-4);
        this.compareFisherDown(14, 873, 552, 42, 1.37118944858872E-5);
        this.compareFisherDown(16, 911, 728, 164, 5.41965575482104E-118);
        this.compareFisherDown(2, 152, 51, 41, 5.37265914345806E-8);
        this.compareFisherDown(117, 480, 274, 253, 1.05549713246985E-7);
        this.compareFisherDown(4, 236, 192, 10, 3.93391860642947E-4);
        this.compareFisherDown(27, 521, 155, 357, 7.1546179587792E-62);
        this.compareFisherDown(7, 461, 151, 184, 2.67218847522338E-33);
        this.compareFisherDown(29, 510, 305, 203, 1.10542140757286E-72);
        this.compareFisherDown(13, 237, 88, 156, 1.71630737398072E-42);
        this.compareFisherDown(89, 572, 403, 188, 1.58248960811606E-17);
        this.compareFisherDown(27, 335, 172, 173, 1.00022714178528E-47);
        this.compareFisherDown(1, 402, 343, 30, 3.55291842099265E-29);
        this.compareFisherDown(66, 306, 122, 206, 1.87164960370351E-5);
        this.compareFisherDown(16, 61, 40, 36, 4.57273382026378E-7);
        this.compareFisherDown(32, 554, 163, 301, 4.8225896336559E-28);
        this.compareFisherDown(8, 789, 388, 277, 3.18813457308328E-98);
        this.compareFisherDown(2, 890, 10, 796, 1.04769809538842E-8);
        this.compareFisherDown(42, 770, 308, 367, 4.38024039390092E-59);
        this.compareFisherDown(6, 55, 19, 33, 2.96863410300295E-4);
        this.compareFisherDown(4, 171, 92, 47, 1.31758038623838E-15);
        this.compareFisherDown(310, 995, 327, 976, 1.92919081042295E-8);
        this.compareFisherDown(183, 868, 584, 305, 3.13284475334555E-4);
        this.compareFisherDown(13, 112, 93, 30, 5.09345032728386E-12);
        this.compareFisherDown(73, 392, 154, 304, 1.16596572422222E-33);
        this.compareFisherDown(1, 385, 30, 144, 3.82323826836252E-7);
        this.compareFisherDown(47, 554, 101, 407, 2.47909349507427E-11);
        this.compareFisherDown(18, 505, 326, 129, 9.10158234925755E-46);
        this.compareFisherDown(16, 515, 475, 39, 8.60004121044127E-21);
        this.compareFisherDown(91, 926, 340, 335, 1.56179857832206E-6);
        this.compareFisherDown(49, 953, 389, 335, 2.84436360391136E-37);
        this.compareFisherDown(2, 763, 61, 554, 7.7377635214529E-36);
        this.compareFisherDown(1, 40, 21, 18, 1.67577669149464E-10);
        this.compareFisherDown(12, 772, 45, 579, 2.42945701198204E-13);
        this.compareFisherDown(22, 347, 82, 279, 1.58907702327229E-41);
        this.compareFisherDown(2, 446, 273, 111, 1.52663791438916E-57);
        this.compareFisherDown(46, 391, 323, 91, 1.8448381164756E-18);
        this.compareFisherDown(52, 556, 247, 163, 3.76060089022952E-5);
        this.compareFisherDown(2, 282, 189, 85, 3.85835151779573E-60);
        this.compareFisherDown(29, 130, 62, 89, 3.17545503454762E-8);
        this.compareFisherDown(63, 629, 201, 264, 6.5881507974015E-5);
        this.compareFisherDown(200, 732, 471, 397, 5.29538922431954E-19);
        this.compareFisherDown(49, 517, 403, 105, 9.86612011417267E-17);
        this.compareFisherDown(12, 530, 38, 376, 3.04971603958179E-8);
        this.compareFisherDown(18, 656, 67, 587, 2.68818158736483E-44);
        this.compareFisherDown(16, 242, 40, 187, 1.93661820051305E-9);
        this.compareFisherDown(89, 698, 546, 149, 1.14195550706473E-9);
        this.compareFisherDown(8, 556, 440, 95, 3.14204784057095E-68);
        this.compareFisherDown(5, 431, 44, 152, 3.39929178807456E-5);
        this.compareFisherDown(32, 915, 156, 574, 1.77058007272689E-33);
        this.compareFisherDown(26, 627, 461, 135, 3.93976550346058E-55);
        this.compareFisherDown(59, 619, 460, 131, 4.10650753885808E-17);
        this.compareFisherDown(10, 399, 72, 155, 7.996152169811E-8);
        this.compareFisherDown(77, 445, 250, 169, 1.41929399394228E-4);
        this.compareFisherDown(60, 821, 522, 197, 1.24193470803979E-28);
        this.compareFisherDown(15, 627, 29, 495, 1.76997186877898E-4);
        this.compareFisherDown(51, 362, 296, 85, 4.83200953355619E-9);
        this.compareFisherDown(65, 736, 240, 460, 1.68636888045595E-44);
        this.compareFisherDown(8, 551, 35, 419, 5.79043383485544E-13);
        this.compareFisherDown(31, 181, 52, 141, 6.371377257703E-5);
        this.compareFisherDown(155, 931, 546, 410, 1.57141011213516E-31);
        this.compareFisherDown(49, 370, 120, 200, 1.31263672590605E-4);
        this.compareFisherDown(19, 215, 168, 47, 4.78138299321588E-12);
        this.compareFisherDown(10, 567, 424, 29, 4.27769623511992E-7);
        this.compareFisherDown(51, 372, 313, 107, 1.36720312068375E-34);
        this.compareFisherDown(13, 393, 155, 97, 3.42880198036781E-11);
        this.compareFisherDown(28, 452, 192, 278, 3.07029863124219E-81);
        this.compareFisherDown(34, 812, 594, 112, 8.01635155599195E-26);
        this.compareFisherDown(100, 637, 474, 179, 1.91831046845406E-11);
        this.compareFisherDown(5, 425, 279, 115, 6.3490979346593E-65);
        this.compareFisherDown(54, 838, 243, 263, 7.04361587049744E-5);
        this.compareFisherDown(3, 825, 376, 55, 8.19330754927712E-13);
        this.compareFisherDown(15, 109, 80, 35, 1.65593752618442E-7);
        this.compareFisherDown(73, 674, 543, 118, 2.97539829045907E-8);
        this.compareFisherDown(309, 699, 344, 650, 3.10818727006591E-4);
        this.compareFisherDown(46, 469, 85, 335, 4.61477161937294E-5);
        this.compareFisherDown(115, 551, 515, 143, 1.62070097654381E-12);
        this.compareFisherDown(3, 162, 8, 144, 1.98324541560583E-5);
        this.compareFisherDown(72, 528, 260, 271, 1.87125928237604E-28);
        this.compareFisherDown(21, 589, 439, 84, 1.26356949684138E-26);
        this.compareFisherDown(8, 997, 545, 86, 1.79712562732956E-21);
        this.compareFisherDown(1, 153, 5, 120, 3.62873598189044E-4);
        this.compareFisherDown(155, 476, 237, 380, 6.80742086958635E-17);
        this.compareFisherDown(12, 243, 32, 173, 3.46251414041836E-6);
        this.compareFisherDown(2, 69, 30, 20, 1.84777897818333E-5);
        this.compareFisherDown(10, 621, 137, 319, 1.2359893210442E-36);
        this.compareFisherDown(13, 908, 418, 101, 9.79596645147574E-15);
        this.compareFisherDown(59, 519, 227, 260, 1.35995478816319E-23);
        this.compareFisherDown(81, 866, 215, 463, 2.63951613872026E-8);
        this.compareFisherDown(2, 669, 482, 20, 2.29978215266672E-10);
        this.compareFisherDown(1, 255, 28, 87, 3.61797690526272E-6);
        this.compareFisherDown(25, 509, 204, 94, 8.67040874821994E-4);
        this.compareFisherDown(1, 128, 40, 25, 2.40252924022306E-5);
        this.compareFisherDown(189, 964, 348, 621, 3.35004927065627E-7);
        this.compareFisherDown(11, 158, 133, 23, 7.06584015934966E-7);
        this.compareFisherDown(65, 358, 114, 267, 8.50412154506876E-8);
        this.compareFisherDown(179, 775, 414, 507, 6.06818418807189E-49);
    }

    public void test_05_fisher() {
        this.compareFisherDown(1, 100, 50, 0, 1.0);
        this.compareFisherDown(1, 100, 0, 20, 1.0);
        this.compareFisherDown(0, 100, 50, 0, 0.0);
        this.compareFisherDown(0, 100, 0, 20, 0.0);
    }
}

