/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaAndQualitySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequencePe;
import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.fileIterator.FastqFileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesDnaSequence
extends TestCase {
    public static boolean verbose = false;

    String change(String sequence2, int numChanges, Random rand) {
        HashSet<Integer> changedPos = new HashSet<Integer>();
        char[] chars = sequence2.toCharArray();
        int i = 0;
        while (i < numChanges) {
            int pos = rand.nextInt(chars.length);
            if (changedPos.contains(pos)) continue;
            int newCode = rand.nextInt() & 3;
            char newBase = DnaCoder.get().toBase(newCode);
            if (chars[pos] == newBase) continue;
            chars[pos] = newBase;
            changedPos.add(pos);
            ++i;
        }
        return new String(chars);
    }

    public void randDnaSeqGetBasesTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        int t2 = 0;
        while (t2 < numTests) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaSequence bseq = new DnaSequence(seq2);
            int i = 0;
            while (i < numTestsPerSeq) {
                int randPos = rand.nextInt(len);
                int randLen = rand.nextInt(len - randPos);
                String basesOri = seq2.substring(randPos, randPos + randLen);
                String basesBin = bseq.getBases(randPos, randLen);
                Assert.assertEquals(basesOri, basesBin);
                if (verbose) {
                    System.out.println("randDnaSeqGetBasesTest:\tPos: " + randPos + "\t" + "Len: " + randLen + "\t'" + basesOri + "'\t=\t'" + basesBin + "'");
                }
                ++i;
            }
            ++t2;
        }
    }

    public void randDnaSeqGetBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        int t2 = 0;
        while (t2 < numTests) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaSequence test:" + t2 + "\tlen:" + len + "\t" + seq2);
            }
            DnaSequence bseq = new DnaSequence(seq2);
            int i = 0;
            while (i < numTestsPerSeq) {
                int randPos = rand.nextInt(len);
                char baseOri = seq2.charAt(randPos);
                char baseBin = bseq.getBase(randPos);
                Assert.assertEquals(baseOri, baseBin);
                ++i;
            }
            ++t2;
        }
    }

    public void randDnaSeqTest(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        int t2 = 0;
        while (t2 < numTests) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaSequence test:" + t2 + "\tlen:" + len + "\t" + seq2);
            }
            DnaSequence bseq = new DnaSequence(seq2);
            Assert.assertEquals(seq2, bseq.toString());
            ++t2;
        }
    }

    String randQual(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            int r = rand.nextInt() & 0x28;
            char qchar = (char)(33 + r);
            sb.append(qchar);
            ++i;
        }
        return sb.toString();
    }

    public void randReplaceBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        int t2 = 0;
        while (t2 < numTests) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaSequence bseq = new DnaSequence(seq2);
            if (verbose) {
                System.out.println("randReplaceBaseTest\nOri    :\t" + seq2);
            }
            int i = 0;
            while (i < numTestsPerSeq) {
                char baseOri;
                int randPos = rand.nextInt(len);
                char randBase = baseOri = seq2.charAt(randPos);
                while (randBase == baseOri) {
                    int r = rand.nextInt() & 3;
                    randBase = DnaCoder.get().toBase(r);
                }
                char[] seqChars = seq2.toCharArray();
                seqChars[randPos] = randBase;
                seq2 = new String(seqChars);
                bseq.setBase(randPos, randBase);
                if (verbose) {
                    System.out.println("Changed:\t" + seq2 + "\tpos: " + randPos + "\trandbase: " + randBase + "\n\t\t" + bseq);
                }
                Assert.assertEquals(seq2, bseq.toString());
                ++i;
            }
            ++t2;
        }
    }

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
            ++i;
        }
        return sb.toString();
    }

    public void randTestQual(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        int t2 = 0;
        while (t2 < numTests) {
            DnaAndQualitySequence bseq;
            String seq2 = "";
            String qual = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            qual = this.randQual(len, rand);
            String fullSeq = String.valueOf(seq2) + "\t" + qual;
            if (verbose) {
                System.out.println("DnaAndQualitySequence test:" + t2 + "\tlen:" + len + "\t" + seq2);
            }
            if (!fullSeq.equals((bseq = new DnaAndQualitySequence(seq2, qual, FastqVariant.FASTQ_SANGER)).toString())) {
                throw new RuntimeException("Sequences do not match:\n\tOriginal:\t" + fullSeq + "\n\tDnaAndQSeq:\t" + bseq);
            }
            ++t2;
        }
    }

    public void test_01_short() {
        long seed = 20100615L;
        int lenMask = 255;
        int numTests = 1000;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    public void test_01_short_getBase() {
        long seed = 20110217L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_01_short_getBases() {
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_01_short_replaceBase() {
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long() {
        long seed = 20100614L;
        int lenMask = 65535;
        int numTests = 10;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    public void test_02_long_getBase() {
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long_getBases() {
        long seed = 20110218L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long_replaceBase() {
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_04_Pe() {
        int numTests = 1000;
        Random rand = new Random(20100617L);
        int t2 = 0;
        while (t2 < numTests) {
            String gapStr = "";
            int gap = rand.nextInt(50) + 1;
            int i = 0;
            while (i < gap) {
                gapStr = String.valueOf(gapStr) + "N";
                ++i;
            }
            int len1 = rand.nextInt(100) + 1;
            String seq1 = this.randSeq(len1, rand);
            int len2 = rand.nextInt(100) + 1;
            String seq2 = this.randSeq(len2, rand);
            String seq3 = String.valueOf(seq1) + gapStr + seq2;
            DnaSequencePe bseqpe = new DnaSequencePe(seq1, seq2, gap);
            if (verbose) {
                System.out.println("PE test: " + t2 + "\t" + bseqpe);
            }
            if (!bseqpe.toString().equals(seq3)) {
                throw new RuntimeException("Sequences do not match:\n\t" + seq3 + "\n\t" + bseqpe);
            }
            ++t2;
        }
    }

    public void test_05_fastqReader() {
        String txt;
        String fastqFileName = "tests/fastq_test.fastq";
        String txtFileName = "tests/fastq_test.txt";
        StringBuilder sb = new StringBuilder();
        for (Fastq fq : new FastqFileIterator(fastqFileName, FastqVariant.FASTQ_ILLUMINA)) {
            sb.append(String.valueOf(fq.getSequence()) + "\t" + fq.getQuality() + "\n");
        }
        if (verbose) {
            System.out.println("Fastq test:\n" + sb);
        }
        if ((txt = Gpr.readFile(txtFileName)).equals(sb.toString())) {
            throw new RuntimeException("Sequences from fastq file does not match expected results:\n----- Fastq file -----" + sb + "\n----- Txt file -----" + txt + "-----");
        }
    }

    public void test_05_quality_short() {
        long seed = 20100804L;
        int lenMask = 255;
        int numTests = 1000;
        this.randTestQual(numTests, lenMask, seed);
    }

    public void test_06_quality_long() {
        long seed = 20100804L;
        int lenMask = 65535;
        int numTests = 10;
        this.randTestQual(numTests, lenMask, seed);
    }
}

