/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeBedFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;

public class SnpEffCmdClosestExon
extends SnpEff {
    public static final String CLOSEST_EXON = "CLOSEST_EXON";
    public static final String INFO_LINE = "##INFO=<ID=CLOSEST_EXON,Number=4,Type=String,Description=\"Closest exon: Distance (bases), exons Id, transcript Id, gene name\">";
    boolean verbose = false;
    boolean bedFormat = false;
    String configFile = "snpEff.config";
    String genomeVer = "";
    String inFile = "";
    Config config;
    IntervalForest intervalForest;

    public SnpEffCmdClosestExon() {
        this.command = "closestExon";
    }

    public SnpEffCmdClosestExon(Config config) {
        this.command = "closestExon";
        this.config = config;
        this.inFile = config.getFileNameProteins();
    }

    void addHeaderLines(VcfFileIterator vcf) {
        vcf.addHeader("##SnpEffVersion=\"SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani\"");
        vcf.addHeader("##SnpEffCmd=\"" + this.commandLineStr(false) + "\"");
        vcf.addHeader(INFO_LINE);
    }

    void bedIterate() {
        SeqChangeBedFileIterator bfi = new SeqChangeBedFileIterator(this.inFile, this.config.getGenome(), 0);
        bfi.setCreateChromos(true);
        for (SeqChange bed : bfi) {
            try {
                Exon exon = (Exon)this.findClosestExons(bed);
                String id = bed.getId();
                if (exon != null) {
                    int dist = exon.distance(bed);
                    Transcript tr = (Transcript)exon.getParent();
                    Gene gene = (Gene)tr.getParent();
                    id = String.valueOf(id.isEmpty() ? "" : String.valueOf(bed.getId()) + ";") + dist + "," + exon.getId() + "," + tr.getId() + "," + gene.getGeneName();
                }
                System.out.println(String.valueOf(bed.getChromosomeName()) + "\t" + bed.getStart() + "\t" + (bed.getEnd() + 1) + "\t" + id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    IntervalForest createForest() {
        if (this.verbose) {
            Timer.showStdErr("Creating interval forest...");
        }
        this.intervalForest = new IntervalForest();
        HashSet<String> exons = new HashSet<String>();
        Comparator<Transcript> mRnaLenComp = new Comparator<Transcript>(){

            @Override
            public int compare(Transcript t1, Transcript t2) {
                return t2.mRna().length() - t1.mRna().length();
            }
        };
        int countAdded = 0;
        int countSkipped = 0;
        for (Gene gene : this.config.getGenome().getGenes()) {
            ArrayList<Transcript> transcripts = new ArrayList<Transcript>();
            for (Transcript tr : gene) {
                transcripts.add(tr);
            }
            Collections.sort(transcripts, mRnaLenComp);
            for (Transcript tr : transcripts) {
                for (Exon exon : tr) {
                    String key = String.valueOf(exon.getChromosomeName()) + ":" + exon.getStart() + "-" + exon.getEnd();
                    if (!exons.contains(key)) {
                        this.intervalForest.add(exon);
                        exons.add(key);
                        ++countAdded;
                        continue;
                    }
                    ++countSkipped;
                }
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Done. Added " + countAdded + " exons. Skipped " + countSkipped + " (redundant exons).");
        }
        return this.intervalForest;
    }

    Marker findClosestExons(Marker inputInterval) {
        int initialExtension = 1000;
        Chromosome chr = inputInterval.getChromosome();
        if (chr.size() > 0) {
            int extend = initialExtension;
            while (extend < chr.size()) {
                int start = Math.max(inputInterval.getStart() - extend, 0);
                int end = inputInterval.getEnd() + extend;
                Marker extended = new Marker(chr, start, end, 1, "");
                Markers markers = this.intervalForest.query(extended);
                int minDist = Integer.MAX_VALUE;
                Marker minDistMarker = null;
                for (Marker m : markers) {
                    int dist = m.distance(inputInterval);
                    if (dist < minDist) {
                        minDistMarker = m;
                        minDist = dist;
                    }
                    if (minDist > 0) continue;
                    return minDistMarker;
                }
                if (minDistMarker != null) {
                    return minDistMarker;
                }
                extend *= 2;
            }
        } else {
            Gpr.debug("CHROMOSOME LENGTH IS " + chr.size());
        }
        return null;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-bed")) {
                    this.bedFormat = true;
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
            } else if (this.inFile.isEmpty()) {
                this.inFile = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.inFile.isEmpty()) {
            this.usage("Missing protein_file parameter");
        }
    }

    @Override
    public boolean run() {
        if (this.config == null) {
            if (this.verbose) {
                Timer.showStdErr("Reading configuration...");
            }
            this.config = new Config(this.genomeVer, this.configFile);
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Loading predictor...");
        }
        this.config.loadSnpEffectPredictor();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.createForest();
        if (this.verbose) {
            Timer.showStdErr("Reading file '" + this.inFile + "'");
        }
        if (this.bedFormat) {
            this.bedIterate();
        } else {
            this.vcfIterate();
        }
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        return true;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff closestExon [options] genome_version file.vcf");
        System.err.println("\nOptions:");
        System.err.println("\t-bed          : Input format is BED. Default: VCF");
        System.err.println("\t-c , -config  : Specify config file");
        System.err.println("\t-noLog        : Do not report usage statistics to server");
        System.err.println("\t-v , -verbose : Verbose mode");
        System.exit(-1);
    }

    void vcfIterate() {
        VcfFileIterator vcf = new VcfFileIterator(this.inFile, this.config.getGenome());
        vcf.setCreateChromos(true);
        boolean header = true;
        for (VcfEntry ve : vcf) {
            try {
                Exon exon;
                if (header) {
                    this.addHeaderLines(vcf);
                    System.out.println(vcf.getHeader());
                    header = false;
                }
                if ((exon = (Exon)this.findClosestExons(ve)) != null) {
                    int dist = exon.distance(ve);
                    Transcript tr = (Transcript)exon.getParent();
                    Gene gene = (Gene)tr.getParent();
                    String value2 = String.valueOf(dist) + "," + exon.getId() + "," + tr.getId() + "," + gene.getGeneName();
                    ve.addInfo(CLOSEST_EXON, value2);
                }
                System.out.println(ve);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

