/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChangeDel;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChangeIns;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChangeInterval;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChangeMnp;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChangeSnp;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CodonChange {
    public static int SHOW_CODONS_AROUND_CHANGE = 0;
    public static boolean showCodonChange = true;
    public static final int CODON_SIZE = 3;
    boolean returnNow = false;
    boolean requireNetCdsChange = false;
    SeqChange seqChange;
    Transcript transcript;
    Exon exon = null;
    ChangeEffect changeEffect;
    int codonNum = -1;
    int codonIndex = -1;
    String codonsOld = "";
    String codonsNew = "";
    String aaOld = "";
    String aaNew = "";
    String netCdsChange = "";

    public CodonChange(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        this.seqChange = seqChange;
        this.transcript = transcript;
        this.changeEffect = changeEffect;
    }

    public List<ChangeEffect> calculate() {
        ArrayList<ChangeEffect> changes = new ArrayList<ChangeEffect>();
        int i = 0;
        while (i < this.seqChange.getChangeOptionCount()) {
            ChangeEffect changeEffectNew = this.changeEffect.clone();
            SeqChange seqChangeNew = this.seqChange.getSeqChangeOption(i);
            if (seqChangeNew != null) {
                CodonChange codonChange = this.factory(seqChangeNew, this.transcript, changeEffectNew);
                changes.addAll(codonChange.codonChange());
            }
            ++i;
        }
        return changes;
    }

    int cdsBaseNumber(int pos) {
        int cdsbn = this.transcript.cdsBaseNumber(pos, true);
        if (cdsbn < 0) {
            if (pos <= this.transcript.getCdsStart()) {
                if (this.transcript.isStrandPlus()) {
                    return 0;
                }
                return this.transcript.cds().length();
            }
            if (this.transcript.isStrandPlus()) {
                return this.transcript.cds().length();
            }
            return 0;
        }
        return cdsbn;
    }

    List<ChangeEffect> codonChange() {
        ArrayList<ChangeEffect> changes = new ArrayList<ChangeEffect>();
        if (!this.transcript.intersects(this.seqChange)) {
            return changes;
        }
        List exons = this.transcript.sortedStrand();
        int cdsStart = this.transcript.getCdsStart();
        this.netCdsChange = this.netCdsChange();
        int firstCdsBaseInExon = 0;
        Iterator iterator2 = exons.iterator();
        while (iterator2.hasNext()) {
            Exon exon;
            this.exon = exon = (Exon)iterator2.next();
            if (exon.intersects(this.seqChange)) {
                int cdsBaseInExon;
                if (this.transcript.isStrandPlus()) {
                    int firstSeqChangeBaseInExon = Math.max(this.seqChange.getStart(), Math.max(exon.getStart(), cdsStart));
                    cdsBaseInExon = firstSeqChangeBaseInExon - Math.max(exon.getStart(), cdsStart);
                } else {
                    int lastSeqChangeBaseInExon = Math.min(this.seqChange.getEnd(), Math.min(exon.getEnd(), cdsStart));
                    cdsBaseInExon = Math.min(exon.getEnd(), cdsStart) - lastSeqChangeBaseInExon;
                }
                if (cdsBaseInExon < 0) {
                    cdsBaseInExon = 0;
                }
                this.codonNum = (firstCdsBaseInExon + cdsBaseInExon) / 3;
                this.codonIndex = (firstCdsBaseInExon + cdsBaseInExon) % 3;
                boolean hasChanged = false;
                ChangeEffect changeEffectNew = this.changeEffect.clone();
                hasChanged = this.codonChangeSingle(changeEffectNew, exon);
                if (hasChanged) {
                    this.codonsAround(this.seqChange, changeEffectNew, this.codonNum);
                    changes.add(changeEffectNew);
                }
                if (this.returnNow) {
                    return changes;
                }
            }
            if (this.transcript.isStrandPlus()) {
                firstCdsBaseInExon += Math.max(0, exon.getEnd() - Math.max(exon.getStart(), cdsStart) + 1);
                continue;
            }
            firstCdsBaseInExon += Math.max(0, Math.min(cdsStart, exon.getEnd()) - exon.getStart() + 1);
        }
        return changes;
    }

    boolean codonChangeSingle(ChangeEffect changeEffect, Exon exon) {
        throw new RuntimeException("Unimplemented method for this thype of seqChange: " + (Object)((Object)this.seqChange.getType()));
    }

    void codonsAround(SeqChange seqChange, ChangeEffect changeEffect, int codonNum) {
        if (SHOW_CODONS_AROUND_CHANGE <= 0) {
            return;
        }
        String cdsSeq = this.transcript.cds();
        int changeSizeInCodons = seqChange.size() / 3;
        int codonMinBasePos = Math.max(0, codonNum - SHOW_CODONS_AROUND_CHANGE) * 3;
        int codonStartBasePos = codonNum * 3;
        int codonEndBasePos = Math.min(cdsSeq.length(), codonStartBasePos + (1 + changeSizeInCodons) * 3);
        int codonMaxBasePos = Math.min(cdsSeq.length(), codonEndBasePos + SHOW_CODONS_AROUND_CHANGE * 3);
        String codonsLeft = cdsSeq.substring(codonMinBasePos, codonStartBasePos);
        String codonsRight = cdsSeq.substring(codonEndBasePos, codonMaxBasePos);
        changeEffect.setCodonsAround(codonsLeft, codonsRight);
    }

    String codonsNew() {
        throw new RuntimeException("Unimplemented method for this thype of CodonChange: " + this.getClass().getSimpleName());
    }

    public String codonsOld() {
        return this.codonsOld(1);
    }

    protected String codonsOld(int numCodons) {
        String cds = this.transcript.cds();
        String codon = "";
        int start = this.codonNum * 3;
        int end = start + numCodons * 3;
        int len = cds.length();
        if (start >= cds.length()) {
            start = len;
        }
        if (end >= cds.length()) {
            end = len;
        }
        if ((codon = cds.substring(start, end)).length() % 3 == 1) {
            codon = String.valueOf(codon) + "NN";
        } else if (codon.length() % 3 == 2) {
            codon = String.valueOf(codon) + "N";
        }
        return codon;
    }

    CodonChange factory(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        if (seqChange.isSnp()) {
            return new CodonChangeSnp(seqChange, transcript, changeEffect);
        }
        if (seqChange.isIns()) {
            return new CodonChangeIns(seqChange, transcript, changeEffect);
        }
        if (seqChange.isDel()) {
            return new CodonChangeDel(seqChange, transcript, changeEffect);
        }
        if (seqChange.isMnp()) {
            return new CodonChangeMnp(seqChange, transcript, changeEffect);
        }
        if (seqChange.isInterval()) {
            return new CodonChangeInterval(seqChange, transcript, changeEffect);
        }
        throw new RuntimeException("Unimplemented factory for SeqChange: " + seqChange);
    }

    protected String netCdsChange() {
        if (!this.requireNetCdsChange) {
            return "";
        }
        if (this.seqChange.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Exon exon : this.transcript.sortedStrand()) {
                sb.append(this.seqChange.netChange(exon));
            }
            return sb.toString();
        }
        return this.seqChange.netChange(this.transcript.getStrand());
    }
}

