/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Downstream;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.IntervalAndSubIntervals;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.MarkerUtil;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Upstream;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.interval.Utr3prime;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.stats.ObservedOverExpectedCpG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Transcript
extends IntervalAndSubIntervals<Exon> {
    private static final long serialVersionUID = -2665025617916107311L;
    ArrayList<Utr> utrs = new ArrayList();
    ArrayList<Cds> cdss = new ArrayList();
    Upstream upstream;
    Downstream downstream;
    String cds = null;
    String bioType = "";
    int cdsStart = -1;
    int cdsEnd = -1;
    boolean proteinCoding = false;

    protected Transcript() {
        this.type = ChangeEffect.EffectType.TRANSCRIPT;
    }

    public Transcript(Marker gene, int start, int end, int strand, String id) {
        super(gene, start, end, strand, id);
        this.type = ChangeEffect.EffectType.TRANSCRIPT;
    }

    @Override
    public void add(Cds cdsInt) {
        this.cdss.add(cdsInt);
        this.cds = null;
    }

    @Override
    public void add(Utr utr) {
        this.utrs.add(utr);
        this.cds = null;
    }

    boolean addMissingUtrs(Markers missingUtrs, boolean verbose) {
        missingUtrs.sort(false, this.strand < 0);
        int minCds = Integer.MAX_VALUE;
        int maxCds = 0;
        for (Cds c : this.cdss) {
            minCds = Math.min(minCds, c.getStart());
            maxCds = Math.max(maxCds, c.getEnd());
        }
        if (verbose) {
            System.out.println("Transcript '" + this.id + "' has missing UTRs. Strand: " + this.strand + " (minCds: " + minCds + " , maxCds: " + maxCds + "):");
        }
        boolean retVal = false;
        for (Marker mu : missingUtrs) {
            Exon eint = this.intersectingExon(mu);
            if (eint == null) {
                throw new RuntimeException("Cannot find exon for UTR: " + mu);
            }
            Utr toAdd = null;
            if (this.isStrandPlus()) {
                if (mu.getEnd() <= minCds) {
                    toAdd = new Utr5prime(eint, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
                } else if (mu.getStart() >= maxCds) {
                    toAdd = new Utr3prime(this, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
                }
            } else if (mu.getStart() >= maxCds) {
                toAdd = new Utr5prime(eint, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
            } else if (mu.getEnd() <= minCds) {
                toAdd = new Utr3prime(this, mu.getStart(), mu.getEnd(), (int)this.strand, mu.getId());
            }
            if (toAdd == null) continue;
            this.add(toAdd);
            if (verbose) {
                System.out.println("\tAdding " + toAdd);
            }
            retVal = true;
        }
        return retVal;
    }

    public boolean adjust() {
        byte newStrand;
        boolean changed = false;
        int strandSumTr = 0;
        int newStart = this.start;
        int newEnd = this.end;
        if (newStart == 0 && newEnd == 0) {
            newStart = Integer.MAX_VALUE;
            newEnd = Integer.MIN_VALUE;
        }
        for (Exon exon : this.sortedStrand()) {
            newStart = Math.min(newStart, exon.getStart());
            newEnd = Math.max(newEnd, exon.getEnd());
            strandSumTr += exon.getStrand();
        }
        for (Utr utr : this.getUtrs()) {
            newStart = Math.min(newStart, utr.getStart());
            newEnd = Math.max(newEnd, utr.getEnd());
        }
        byte by2 = newStrand = strandSumTr >= 0 ? (byte)1 : -1;
        if (this.strand != newStrand) {
            this.strand = newStrand;
            changed = true;
        }
        if (this.start != newStart) {
            this.start = newStart;
            changed = true;
        }
        if (this.end != newEnd) {
            this.end = newEnd;
            changed = true;
        }
        return changed;
    }

    synchronized void calcCdsStartEnd() {
        block7: {
            if (this.cdsStart >= 0) break block7;
            if (this.utrs.isEmpty()) {
                this.cdsStart = this.isStrandPlus() ? this.end : this.start;
                this.cdsEnd = this.isStrandPlus() ? this.start : this.end;
                for (Exon ex : this) {
                    if (this.isStrandPlus()) {
                        this.cdsStart = Math.min(this.cdsStart, ex.getStart());
                        this.cdsEnd = Math.max(this.cdsEnd, ex.getEnd());
                        continue;
                    }
                    this.cdsStart = Math.max(this.cdsStart, ex.getEnd());
                    this.cdsEnd = Math.min(this.cdsEnd, ex.getStart());
                }
            } else {
                this.cdsStart = this.isStrandPlus() ? this.start : this.end;
                this.cdsEnd = this.isStrandPlus() ? this.end : this.start;
                for (Utr utr : this.utrs) {
                    if (utr instanceof Utr5prime) {
                        if (this.isStrandPlus()) {
                            this.cdsStart = Math.max(this.cdsStart, utr.getEnd() + 1);
                            continue;
                        }
                        this.cdsStart = Math.min(this.cdsStart, utr.getStart() - 1);
                        continue;
                    }
                    if (!(utr instanceof Utr3prime)) continue;
                    this.cdsEnd = this.isStrandPlus() ? Math.min(this.cdsEnd, utr.getStart() - 1) : Math.max(this.cdsEnd, utr.getEnd() + 1);
                }
            }
        }
    }

    public String cds() {
        if (this.cds != null) {
            return this.cds;
        }
        List exons = this.sortedStrand();
        StringBuilder sequence2 = new StringBuilder();
        int utr5len = 0;
        int utr3len = 0;
        for (Utr utr : this.get5primeUtrs()) {
            utr5len += utr.size();
        }
        for (Exon exon : exons) {
            sequence2.append(exon.getSequence());
        }
        for (Utr utr : this.get3primeUtrs()) {
            utr3len += utr.size();
        }
        int n = sequence2.length() - utr3len;
        this.cds = utr5len > n ? "" : sequence2.substring(utr5len, n);
        return this.cds;
    }

    public int cdsBaseNumber(int pos, boolean usePrevBaseIntron) {
        if (!this.intersects(pos)) {
            return -1;
        }
        if (this.isUtr(pos)) {
            return -1;
        }
        this.calcCdsStartEnd();
        int firstCdsBaseInExon = 0;
        for (Exon eint : this.sortedStrand()) {
            if (eint.intersects(pos)) {
                int cdsBaseInExon = this.strand >= 0 ? pos - Math.max(eint.getStart(), this.cdsStart) : Math.min(eint.getEnd(), this.cdsStart) - pos;
                cdsBaseInExon = Math.max(0, cdsBaseInExon);
                return firstCdsBaseInExon + cdsBaseInExon;
            }
            if (this.isStrandPlus() && pos < eint.getStart() || this.isStrandMinus() && pos > eint.getEnd()) {
                return firstCdsBaseInExon - (usePrevBaseIntron ? 1 : 0);
            }
            if (this.isStrandPlus()) {
                firstCdsBaseInExon += Math.max(0, eint.getEnd() - Math.max(eint.getStart(), this.cdsStart) + 1);
                continue;
            }
            firstCdsBaseInExon += Math.max(0, Math.min(this.cdsStart, eint.getEnd()) - eint.getStart() + 1);
        }
        return firstCdsBaseInExon - 1;
    }

    public int[] cdsBaseNumber2ChrPos() {
        this.calcCdsStartEnd();
        int[] cds2pos = new int[this.cds().length()];
        int i = 0;
        while (i < cds2pos.length) {
            cds2pos[i] = -1;
            ++i;
        }
        int cdsMin = Math.min(this.cdsStart, this.cdsEnd);
        int cdsMax = Math.max(this.cdsStart, this.cdsEnd);
        int cdsBaseNum = 0;
        for (Exon exon : this.sortedStrand()) {
            int min2 = this.isStrandPlus() ? exon.getStart() : exon.getEnd();
            int step2 = this.isStrandPlus() ? 1 : -1;
            int pos = min2;
            while (exon.intersects(pos)) {
                if (cdsMin <= pos && pos <= cdsMax) {
                    cds2pos[cdsBaseNum++] = pos;
                }
                pos += step2;
            }
        }
        return cds2pos;
    }

    public String codonByCdsBaseNumber(int cdsBaseNumber) {
        int codonNum = cdsBaseNumber / 3;
        int min2 = codonNum * 3;
        int max2 = codonNum * 3 + 3;
        if (min2 >= 0 && max2 <= this.cds().length()) {
            return this.cds().substring(min2, max2).toUpperCase();
        }
        return null;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public int cpgExons() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.observed(this);
    }

    public void createUpDownStream(int upDownLength) {
        Chromosome chr = this.getChromosome();
        int min2 = chr.getStart();
        int max2 = chr.getEnd();
        if (this.isStrandPlus()) {
            this.upstream = new Upstream(this, Math.max(this.start - upDownLength, min2), Math.max(this.start - 1, min2), 1, this.id);
            this.downstream = new Downstream(this, Math.min(this.end + 1, max2), Math.min(this.end + upDownLength, max2), 1, this.id);
        } else {
            this.upstream = new Upstream(this, Math.min(this.end + 1, max2), Math.min(this.end + upDownLength, max2), 1, this.id);
            this.downstream = new Downstream(this, Math.max(this.start - upDownLength, min2), Math.max(this.start - 1, min2), 1, this.id);
        }
    }

    public void deleteRedundant() {
        Collection<Marker> toDelete = MarkerUtil.redundant(this.subintervals());
        for (Marker exon : toDelete) {
            this.subIntervals.remove(exon.getId());
        }
        toDelete = MarkerUtil.redundant(this.cdss);
        for (Marker cds : toDelete) {
            this.cdss.remove(cds);
        }
        toDelete = MarkerUtil.redundant(this.utrs);
        for (Marker utr : toDelete) {
            this.utrs.remove(utr);
        }
    }

    public List<SpliceSite> findSpliceSites(boolean createIfMissing) {
        LinkedList<SpliceSite> list2 = new LinkedList<SpliceSite>();
        ArrayList exons = new ArrayList();
        exons.addAll(this.sortedStrand());
        if (exons.size() > 0) {
            int i = 0;
            while (i < exons.size()) {
                SpliceSite ss;
                int dist;
                Exon next2;
                Exon exon = (Exon)exons.get(i);
                Exon prev = i >= 1 ? (Exon)exons.get(i - 1) : null;
                Exon exon2 = next2 = i < exons.size() - 1 ? (Exon)exons.get(i + 1) : null;
                if (prev != null) {
                    dist = 0;
                    dist = this.strand >= 0 ? exon.getStart() - prev.getEnd() - 1 : prev.getStart() - exon.getEnd() - 1;
                    ss = exon.getSpliceSiteAcceptor();
                    if (ss == null && createIfMissing) {
                        ss = exon.createSpliceSiteAcceptor(Math.min(2, dist));
                    }
                    if (ss != null) {
                        list2.add(ss);
                    }
                }
                if (next2 != null) {
                    dist = 0;
                    dist = this.strand >= 0 ? next2.getStart() - exon.getEnd() - 1 : exon.getStart() - next2.getEnd() - 1;
                    ss = exon.getSpliceSiteDonor();
                    if (ss == null && createIfMissing) {
                        ss = exon.createSpliceSiteDonor(Math.min(2, dist));
                    }
                    if (ss != null) {
                        list2.add(ss);
                    }
                }
                int rank = i + 1;
                if (exon.getRank() != rank) {
                    throw new RuntimeException("Rank numbers do not march: " + rank + " != " + exon.getRank());
                }
                ++i;
            }
        }
        return list2;
    }

    public List<Utr3prime> get3primeUtrs() {
        ArrayList<Utr3prime> list2 = new ArrayList<Utr3prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr3prime)) continue;
            list2.add((Utr3prime)utr);
        }
        return list2;
    }

    public List<Utr5prime> get5primeUtrs() {
        ArrayList<Utr5prime> list2 = new ArrayList<Utr5prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr5prime)) continue;
            list2.add((Utr5prime)utr);
        }
        return list2;
    }

    public String getBioType() {
        return this.bioType;
    }

    public List<Cds> getCds() {
        return this.cdss;
    }

    public int getCdsEnd() {
        this.calcCdsStartEnd();
        return this.cdsEnd;
    }

    public int getCdsStart() {
        this.calcCdsStartEnd();
        return this.cdsStart;
    }

    public Downstream getDownstream() {
        return this.downstream;
    }

    public Upstream getUpstream() {
        return this.upstream;
    }

    public List<Utr> getUtrs() {
        return this.utrs;
    }

    public Exon intersectingExon(Marker interval) {
        for (Exon ei : this) {
            if (!ei.intersects(interval)) continue;
            return ei;
        }
        return null;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    boolean isCds(SeqChange seqChange) {
        this.calcCdsStartEnd();
        int cs = this.cdsStart;
        int ce = this.cdsEnd;
        if (this.isStrandMinus()) {
            cs = this.cdsEnd;
            ce = this.cdsStart;
        }
        return seqChange.getEnd() >= cs && seqChange.getStart() <= ce;
    }

    public boolean isProteinCoding() {
        return this.proteinCoding;
    }

    boolean isUtr(int pos) {
        for (Utr utr : this.utrs) {
            if (!utr.intersects(pos)) continue;
            return true;
        }
        return false;
    }

    public String mRna() {
        List exons = this.sortedStrand();
        StringBuilder sequence2 = new StringBuilder();
        for (Exon eint : exons) {
            sequence2.append(eint.getSequence());
        }
        return sequence2.toString();
    }

    public String protein() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return "";
        }
        return this.codonTable().aa(this.cds());
    }

    public boolean rankExons() {
        boolean changed = false;
        int rank = 1;
        for (Exon exon : this.sortedStrand()) {
            if (rank != exon.getRank()) {
                exon.setRank(rank);
                changed = true;
            }
            ++rank;
        }
        return changed;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        ArrayList<ChangeEffect> changeEffectList = new ArrayList<ChangeEffect>();
        boolean includedInUtr = false;
        for (Utr utr : this.utrs) {
            if (!utr.intersects(seqChange)) continue;
            List<ChangeEffect> chEffList = utr.seqChangeEffect(seqChange, changeEffect.clone());
            if (!chEffList.isEmpty()) {
                changeEffectList.addAll(chEffList);
            }
            includedInUtr |= utr.includes(seqChange);
        }
        if (includedInUtr) {
            return changeEffectList;
        }
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding() || seqChange.isInterval()) {
            ChangeEffect cheff;
            if (!this.subintervals().isEmpty()) {
                for (Exon exon : this) {
                    if (!exon.intersects(seqChange)) continue;
                    ChangeEffect cheff2 = changeEffect.clone();
                    cheff2.set(exon, ChangeEffect.EffectType.EXON, "");
                    changeEffectList.add(cheff2);
                }
                if (changeEffectList.isEmpty()) {
                    cheff = changeEffect.clone();
                    cheff.set(this, ChangeEffect.EffectType.INTRON, "");
                    changeEffectList.add(cheff);
                }
            } else {
                cheff = changeEffect.clone();
                cheff.set(this, ChangeEffect.EffectType.TRANSCRIPT, "");
                changeEffectList.add(cheff);
            }
            return changeEffectList;
        }
        if (this.isCds(seqChange)) {
            CodonChange codonChange = new CodonChange(seqChange, this, changeEffect);
            List<ChangeEffect> codonChangesList = codonChange.calculate();
            for (ChangeEffect resCodon : codonChangesList) {
                for (Exon exon : this) {
                    if (!exon.intersects(seqChange)) continue;
                    ChangeEffect chEff = resCodon.clone();
                    changeEffectList.addAll(exon.seqChangeEffect(seqChange, chEff));
                }
            }
        }
        if (changeEffectList.isEmpty()) {
            changeEffect.set(this, ChangeEffect.EffectType.INTRON, "");
            return changeEffect.newList();
        }
        return changeEffectList;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.bioType = markerSerializer.getNextField();
        this.proteinCoding = markerSerializer.getNextFieldBoolean();
        this.upstream = (Upstream)markerSerializer.getNextFieldMarker();
        this.downstream = (Downstream)markerSerializer.getNextFieldMarker();
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.utrs.add((Utr)m);
        }
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.cdss.add((Cds)m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return String.valueOf(super.serializeSave(markerSerializer)) + "\t" + this.bioType + "\t" + this.proteinCoding + "\t" + markerSerializer.save(this.upstream) + "\t" + markerSerializer.save(this.downstream) + "\t" + markerSerializer.save(this.utrs) + "\t" + markerSerializer.save(this.cdss);
    }

    public void setBioType(String bioType) {
        this.bioType = bioType;
    }

    public void setProteinCoding(boolean proteinCoding) {
        this.proteinCoding = proteinCoding;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getChromosomeName()) + ":" + this.start + "-" + this.end);
        sb.append(", strand: " + (this.strand >= 0 ? "+" : "-"));
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.bioType != null && this.bioType.length() > 0) {
            sb.append(", bioType:" + this.bioType);
        }
        if (this.isProteinCoding()) {
            sb.append(", Protein");
        }
        if (this.numChilds() > 0) {
            sb.append("\n");
            for (Utr utr : this.get5primeUtrs()) {
                sb.append("\t\t5'UTR   :\t" + utr + "\n");
            }
            sb.append("\t\tExons:\n");
            for (Exon exon : this.sorted()) {
                sb.append("\t\t" + exon + "\n");
            }
            for (Utr utr : this.get3primeUtrs()) {
                sb.append("\t\t3'UTR   :\t" + utr + "\n");
            }
            if (this.isProteinCoding()) {
                sb.append("\t\tCDS     :\t" + this.cds() + "\n");
                sb.append("\t\tProtein :\t" + this.protein() + "\n");
            }
        }
        return sb.toString();
    }

    public boolean utrFromCds(boolean verbose) {
        if (this.cdss.size() <= 0) {
            return false;
        }
        Markers exons = new Markers();
        Markers minus2 = new Markers();
        for (Exon e : this) {
            exons.add(e);
        }
        for (Utr uint : this.getUtrs()) {
            minus2.add(uint);
        }
        for (Cds cint : this.cdss) {
            minus2.add(cint);
        }
        Markers missingUtrs = exons.minus(minus2);
        if (missingUtrs.size() > 0) {
            return this.addMissingUtrs(missingUtrs, verbose);
        }
        return false;
    }
}

