/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class IntervalAndSubIntervals<T extends Marker>
extends Marker
implements Iterable<T> {
    private static final long serialVersionUID = 1636197649250882952L;
    HashMap<String, T> subIntervals = new HashMap();

    public IntervalAndSubIntervals() {
    }

    public IntervalAndSubIntervals(Marker parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
    }

    public void add(T t2) {
        if (this.subIntervals.put(((Interval)t2).getId(), t2) != null) {
            throw new RuntimeException(String.valueOf(t2.getClass().getSimpleName()) + " '" + ((Interval)t2).getId() + "' is already in " + this.getClass().getSimpleName() + " '" + this.id + "'");
        }
    }

    public T get(String id) {
        return (T)((Marker)this.subIntervals.get(id));
    }

    @Override
    public Iterator<T> iterator() {
        return this.subIntervals.values().iterator();
    }

    public int numChilds() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    public void remove(T t2) {
        this.subIntervals.remove(((Interval)t2).getId());
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        Markers markers = markerSerializer.getNextFieldMarkers();
        for (Marker m : markers) {
            this.add(m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return String.valueOf(super.serializeSave(markerSerializer)) + "\t" + markerSerializer.save(this.subIntervals.values());
    }

    public List<T> sorted() {
        ArrayList<T> list2 = new ArrayList<T>();
        list2.addAll(this.subIntervals.values());
        Collections.sort(list2);
        return list2;
    }

    public List<T> sortedStrand() {
        ArrayList<T> list2 = new ArrayList<T>();
        list2.addAll(this.subIntervals.values());
        if (this.strand >= 0) {
            Collections.sort(list2, new IntervalComparatorByStart());
        } else {
            Collections.sort(list2, new IntervalComparatorByEnd(true));
        }
        return list2;
    }

    public Collection<T> subintervals() {
        return this.subIntervals.values();
    }
}

