/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.binseq.DnaNSequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.List;

public class Exon
extends Marker {
    private static final long serialVersionUID = 5324352193278472543L;
    public static final int SPLICE_SITE_SIZE = 2;
    byte frame = 0;
    int rank;
    DnaSequence sequence;
    SpliceSiteAcceptor spliceSiteAcceptor;
    SpliceSiteDonor spliceSiteDonor;
    ExonSpliceType spliceType;

    protected Exon() {
        this.strand = 0;
        this.rank = 0;
        this.sequence = DnaSequence.empty();
        this.type = ChangeEffect.EffectType.EXON;
    }

    public Exon(Marker parent, int start, int end, int strand, String id, int rank) {
        super(parent, start, end, strand, id);
        this.strand = (byte)strand;
        this.rank = rank;
        this.sequence = DnaSequence.empty();
        this.type = ChangeEffect.EffectType.EXON;
    }

    public String basesAt(int index2, int len) {
        if (this.strand < 0) {
            int idx = this.sequence.length() - index2 - len;
            return GprSeq.reverseWc(this.sequence.getBases(idx, len));
        }
        return this.sequence.getBases(index2, len);
    }

    public void check(SeqChange seqChange, ChangeEffect results) {
        if (seqChange.getChangeType() != SeqChange.ChangeType.SNP && seqChange.getChangeType() != SeqChange.ChangeType.MNP) {
            return;
        }
        int mstart = Math.max(seqChange.getStart(), this.start);
        int idxStart = mstart - this.start;
        if (this.sequence.length() <= 0) {
            results.addWarning("WARNING_SEQUENCE_NOT_AVAILABLE");
        } else if (idxStart >= this.sequence.length()) {
            results.addError("ERROR_OUT_OF_EXON");
        } else {
            String changeReference;
            int mend = Math.min(seqChange.getEnd(), this.end);
            int len = mend - mstart + 1;
            String realReference = this.basesAt(idxStart, len).toUpperCase();
            if (!realReference.equals(changeReference = seqChange.reference().substring(mstart - seqChange.getStart(), mend - seqChange.getStart() + 1))) {
                results.addWarning("WARNING_REF_IS_" + realReference + "_NOT_" + seqChange.getReference());
            }
        }
    }

    public SpliceSiteAcceptor createSpliceSiteAcceptor(int size2) {
        if (--size2 < 0) {
            return null;
        }
        this.spliceSiteAcceptor = this.strand >= 0 ? new SpliceSiteAcceptor(this, this.start - 1 - size2, this.start - 1, (int)this.strand, this.id) : new SpliceSiteAcceptor(this, this.end + 1, this.end + 1 + size2, (int)this.strand, this.id);
        return this.spliceSiteAcceptor;
    }

    public SpliceSiteDonor createSpliceSiteDonor(int size2) {
        if (--size2 < 0) {
            return null;
        }
        this.spliceSiteDonor = this.strand >= 0 ? new SpliceSiteDonor(this, this.end + 1, this.end + 1 + size2, (int)this.strand, this.id) : new SpliceSiteDonor(this, this.start - 1 - size2, this.start - 1, (int)this.strand, this.id);
        return this.spliceSiteDonor;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getRank() {
        return this.rank;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public SpliceSiteAcceptor getSpliceSiteAcceptor() {
        return this.spliceSiteAcceptor;
    }

    public SpliceSiteDonor getSpliceSiteDonor() {
        return this.spliceSiteDonor;
    }

    public ExonSpliceType getSpliceType() {
        return this.spliceType;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        if (seqChange.includes(this) && seqChange.isDel()) {
            changeEffect.setCodons("", "", -1, -1);
            changeEffect.set(this, ChangeEffect.EffectType.EXON_DELETED, "");
            return changeEffect.newList();
        }
        changeEffect.setExon(this);
        this.check(seqChange, changeEffect);
        return changeEffect.newList();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.frame = (byte)markerSerializer.getNextFieldInt();
        this.rank = markerSerializer.getNextFieldInt();
        this.setSequence(markerSerializer.getNextField());
        this.spliceSiteDonor = (SpliceSiteDonor)markerSerializer.getNextFieldMarker();
        this.spliceSiteAcceptor = (SpliceSiteAcceptor)markerSerializer.getNextFieldMarker();
        String exType = markerSerializer.getNextField();
        if (exType != null && !exType.isEmpty()) {
            this.spliceType = ExonSpliceType.valueOf(exType);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        int ssdId = markerSerializer.save(this.spliceSiteDonor);
        int ssaId = markerSerializer.save(this.spliceSiteAcceptor);
        return String.valueOf(super.serializeSave(markerSerializer)) + "\t" + this.frame + "\t" + this.rank + "\t" + this.sequence + "\t" + ssdId + "\t" + ssaId + "\t" + (this.spliceType != null ? this.spliceType.toString() : "");
    }

    public void setFrame(int frame) {
        if (frame > 2 || frame < -1) {
            throw new RuntimeException("Invalid frame value: " + frame);
        }
        this.frame = (byte)frame;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setSequence(String sequence2) {
        if (sequence2 == null || sequence2.length() <= 0) {
            this.sequence = DnaSequence.empty();
        }
        this.sequence = GprSeq.isAmbiguous(sequence2) ? new DnaNSequence(sequence2) : new DnaSequence(sequence2);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getChromosomeName()) + ":" + this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + " rank:" + this.rank + (this.sequence != null ? ", sequence: " + this.sequence : "");
    }

    public static enum ExonSpliceType {
        RETAINED,
        SKIPPED,
        ALTTENATIVE_3SS,
        ALTTENATIVE_5SS,
        MUTUALLY_EXCLUSIVE,
        ALTTENATIVE_PROMOMOTER,
        ALTTENATIVE_POLY_A;

    }
}

