/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.ChromosomeSimpleName;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;

public class Chromosome
extends Marker {
    private static final long serialVersionUID = 1636197649250882952L;
    double chromosomeNum;
    DnaSequence sequence = null;

    public static String simpleName(String chrName) {
        return ChromosomeSimpleName.get(chrName);
    }

    protected Chromosome() {
    }

    public Chromosome(Marker parent, int start, int end, int strand, String id) {
        super(null, start, end, strand, id);
        this.parent = parent;
        this.type = ChangeEffect.EffectType.CHROMOSOME;
        this.setChromosomeName(id);
    }

    public int compareChromoName(Interval interval) {
        Chromosome i2 = (Chromosome)interval;
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum == 0.0) {
            return this.id.compareTo(i2.id);
        }
        if (this.chromosomeNum != 0.0 && i2.chromosomeNum == 0.0) {
            return -1;
        }
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum != 0.0) {
            return 1;
        }
        if (this.chromosomeNum - i2.chromosomeNum < 0.0) {
            return -1;
        }
        if (this.chromosomeNum - i2.chromosomeNum > 0.0) {
            return 1;
        }
        return 0;
    }

    public DnaSequence getDnaSequence() {
        return this.sequence;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.setChromosomeName(this.id);
    }

    private void setChromosomeName(String chromo) {
        this.id = Chromosome.simpleName(chromo);
        this.chromosomeNum = Gpr.parseIntSafe(this.id);
    }

    public void setLength(int len) {
        this.end = len - 1;
    }

    public void setSequence(String sequenceStr) {
        this.sequence = new DnaSequence(sequenceStr, true);
        this.setLength(sequenceStr.length());
    }
}

