/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Features
implements Iterable<Feature> {
    public static final int MAX_LEN_TO_SHOW = 200;
    public static final String COMPLEMENT = "complement";
    public static final String JOIN = "join";
    String locusName;
    String moleculeType;
    String shape;
    String division;
    String date;
    int sequenceLength;
    String definition = "";
    String accession = "";
    String version = "";
    String keywords = "";
    String source = "";
    String organism = "";
    StringBuffer featuresStr;
    StringBuffer sequence;
    ArrayList<Feature> features;
    ArrayList<StringBuffer> references = new ArrayList();

    public Features(String fileName) {
        this.featuresStr = new StringBuffer();
        this.sequence = new StringBuffer();
        this.features = new ArrayList();
        this.readFile(fileName);
    }

    void addFeature(String typeStr, StringBuilder values2) {
        try {
            Feature.Type type = Feature.Type.valueOf(typeStr.toUpperCase());
            Collection<Feature> newFeatures = this.featureFactory(type, values2.toString());
            this.features.addAll(newFeatures);
        }
        catch (Exception e) {
            Gpr.debug("WARNING: Unknown feature '" + typeStr + "', not added.");
        }
    }

    Collection<Feature> featureFactory(Feature.Type type, String def) {
        String[] locs;
        boolean complement = false;
        LinkedList<Feature> features = new LinkedList<Feature>();
        int firstLine = def.indexOf("\n");
        String locStr = def.substring(0, firstLine);
        if (locStr.startsWith(COMPLEMENT)) {
            complement = true;
            locStr = locStr.substring(COMPLEMENT.length() + 1, locStr.length() - 1);
        }
        String[] stringArray = locs = locStr.split(",");
        int n = locs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] startEnd;
            String loc = stringArray[n2];
            if (loc.startsWith(COMPLEMENT)) {
                complement = true;
                loc = loc.substring(COMPLEMENT.length() + 1, loc.length() - 1);
            }
            if (loc.startsWith(JOIN)) {
                complement = true;
                loc = loc.substring(JOIN.length());
            }
            if ((startEnd = (loc = loc.replaceAll("[<>()]", "")).split("[\\.]+")).length <= 1) {
                throw new RuntimeException("Cannot calculate start & end coordinates: '" + loc + "'");
            }
            int start = Gpr.parseIntSafe(startEnd[0]);
            int end = Gpr.parseIntSafe(startEnd[1]);
            Feature feature = new Feature(type, def, start, end, complement);
            features.add(feature);
            ++n2;
        }
        return features;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getDate() {
        return this.date;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDivision() {
        return this.division;
    }

    public ArrayList<Feature> getFeatures() {
        return this.features;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLocusName() {
        return this.locusName;
    }

    public String getMoleculeType() {
        return this.moleculeType;
    }

    public String getOrganism() {
        return this.organism;
    }

    public ArrayList<StringBuffer> getReferences() {
        return this.references;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public int getSequenceLength() {
        return this.sequenceLength;
    }

    public String getShape() {
        return this.shape;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    protected abstract boolean isNewFeature(String var1);

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    protected void parseFeatures() {
        String type = null;
        String value2 = "";
        StringBuilder values2 = new StringBuilder();
        String[] stringArray = this.featuresStr.toString().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (this.isNewFeature(line)) {
                String[] kv = line.trim().split(" ", 2);
                if (kv.length > 1) {
                    if (type != null) {
                        this.addFeature(type, values2);
                        values2 = new StringBuilder();
                    }
                    type = kv[0];
                    value2 = kv[1].trim();
                }
            } else {
                value2 = line.trim();
            }
            if (value2.startsWith("/")) {
                values2.append("\n");
            }
            values2.append(value2);
            ++n2;
        }
        this.addFeature(type, values2);
    }

    public abstract void readFile(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name            : " + this.locusName + "\n");
        sb.append("Sequence length : " + this.sequence.length() + "\n");
        for (StringBuffer refsb : this.references) {
            sb.append("Reference       :\n");
            String[] stringArray = refsb.toString().split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                sb.append("                 " + l + "\n");
                ++n2;
            }
        }
        if (this.sequence.length() <= 200) {
            sb.append("Sequence        : " + this.sequence + "\n");
        } else {
            sb.append("Sequence        : " + this.sequence.substring(0, 200) + "..." + "\n");
        }
        for (Feature f2 : this.features) {
            sb.append(f2);
        }
        return sb.toString();
    }
}

