/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.genBank;

import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Feature {
    static final String FEATURE_REGEX = "/(\\S+?)=(.*)";
    static final Pattern FEATURE_PATTERN = Pattern.compile("/(\\S+?)=(.*)");
    public static final String COMPLEMENT_STRING = "complement";
    Type type;
    int start;
    int end;
    HashMap<String, String> qualifiers;
    boolean complement;

    public Feature(Type type, String def) {
        this.type = type;
        this.qualifiers = new HashMap();
        this.start = -1;
        this.end = -1;
        this.complement = false;
        this.parse(def);
    }

    public Feature(Type type, String def, int start, int end, boolean complement) {
        this.type = type;
        this.qualifiers = new HashMap();
        this.start = start;
        this.end = end;
        this.complement = complement;
        this.parse(def);
    }

    public String get(String name) {
        return this.qualifiers.get(name);
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isComplement() {
        return this.complement;
    }

    void parse(String def) {
        int firstLine = def.indexOf("\n");
        if (this.start < 0 && this.end < 0) {
            String loc = def.substring(0, firstLine);
            this.parseLocation(loc);
        }
        def = def.substring(firstLine + 1);
        Matcher matcher = FEATURE_PATTERN.matcher(def);
        while (matcher.find()) {
            if (matcher.groupCount() < 2) continue;
            String key = matcher.group(1).toLowerCase();
            String value2 = matcher.group(2);
            if (value2.startsWith("\"") && value2.endsWith("\"")) {
                value2 = value2.substring(1, value2.length() - 1);
            }
            this.qualifiers.put(key, value2.trim());
        }
    }

    void parseLocation(String loc) {
        String[] se;
        if ((loc = loc.replaceAll("[<>()]", "")).startsWith(COMPLEMENT_STRING)) {
            this.complement = true;
            loc = loc.substring(COMPLEMENT_STRING.length());
        }
        if ((se = loc.split("[\\.]+")).length > 1) {
            this.start = Gpr.parseIntSafe(se[0]);
            this.end = Gpr.parseIntSafe(se[1]);
        }
    }

    String removeQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String toString() {
        String format2 = "\t%-20s: \"%s\"\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Feature: '" + (Object)((Object)this.type) + "' [ " + this.start + ", " + this.end + " ]\t" + (this.complement ? COMPLEMENT_STRING : "") + "\n");
        for (Map.Entry<String, String> e : this.qualifiers.entrySet()) {
            sb.append(String.format(format2, e.getKey(), e.getValue()));
        }
        return sb.toString();
    }

    public static enum Type {
        SOURCE,
        CDS,
        GENE,
        MRNA,
        TRNA,
        RRNA,
        MISC_RNA,
        REPEAT_UNIT,
        REPEAT_REGION,
        MISC_FEATURE;

    }
}

