/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class SeqChangeFileTxt
extends SeqChangeFileIterator {
    public SeqChangeFileTxt(String fileName, Genome genome, int positionBase) {
        super(fileName, genome, positionBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SeqChange readNext() {
        try {
            String line;
            do {
                if (!this.ready()) {
                    return null;
                }
                line = this.readLine();
                if (line != null) continue;
                return null;
            } while ((line = line.trim()).length() <= 0 || line.startsWith("#"));
            String[] fields = line.split("\t");
            if (fields.length < 4) throw new RuntimeException("Error reading file '" + this.fileName + "' line " + this.lineNum + " (number of fields is " + fields.length + "):\t" + line);
            String chromosome = fields[0].trim();
            Chromosome chromo = this.getChromosome(chromosome);
            this.sanityCheckChromo(chromosome, chromo);
            int start = this.parsePosition(fields[1]);
            String reference = fields[2];
            String change = fields[3];
            int strand = 1;
            if (fields.length >= 5) {
                String strandStr = fields[4];
                if (strandStr.charAt(0) == '+') {
                    strand = 1;
                } else if (strandStr.charAt(0) == '-') {
                    strand = -1;
                }
            }
            double quality = -1.0;
            if (fields.length >= 6) {
                quality = Gpr.parseDoubleSafe(fields[5]);
            }
            int coverage = -1;
            if (fields.length >= 7) {
                coverage = Gpr.parseIntSafe(fields[6]);
            }
            String id = "";
            if (fields.length < 8) return new SeqChange(chromo, start, reference, change, strand, id, quality, coverage);
            id = fields[7];
            return new SeqChange(chromo, start, reference, change, strand, id, quality, coverage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

