/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.NullReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.CharBuffer;

public class SeekableBufferedReader
extends BufferedReader {
    public static int DEFAULT_BUFFER_SIZE = 102400;
    byte[] buffer;
    int next;
    int last;
    int bufferSize;
    String fileName;
    File file;
    RandomAccessFile raf;

    public SeekableBufferedReader(String fileName) throws IOException {
        super(new NullReader());
        this.init(fileName, DEFAULT_BUFFER_SIZE);
    }

    public SeekableBufferedReader(String fileName, int bufferSize) throws IOException {
        super(null);
        this.init(fileName, bufferSize);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            this.file = null;
        }
    }

    public boolean equals(Object arg0) {
        throw new RuntimeException("Unimplemented method!");
    }

    int findNl(int next2, int last2) {
        int i = next2;
        while (i < last2) {
            if (this.buffer[i] == 10) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hashCode() {
        throw new RuntimeException("Unimplemented method!");
    }

    void init(String fileName, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.next = 0;
        this.last = 0;
        this.open(fileName);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void open(String fileName) throws IOException {
        this.fileName = fileName;
        try {
            this.file = new File(fileName);
            this.raf = new RandomAccessFile(fileName, "r");
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    public long position() {
        long pos = -1L;
        try {
            pos = this.raf.getFilePointer() + (long)this.next;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pos;
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public int read(char[] buff) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public int read(CharBuffer arg0) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = null;
        while (true) {
            if (this.last <= this.next) {
                this.next = 0;
                this.last = this.raf.read(this.buffer);
                if (this.last < 0) {
                    return sb == null ? null : sb.toString();
                }
            }
            int nl = this.findNl(this.next, this.last);
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (nl >= 0) {
                sb.append(new String(this.buffer, this.next, nl - this.next));
                this.next = nl + 1;
                return sb.toString();
            }
            sb.append(new String(this.buffer, this.next, this.last - this.next));
            this.last = this.next;
        }
    }

    @Override
    public boolean ready() throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Unimplemented method!");
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
        this.last = 0;
        this.next = 0;
    }

    public long size() {
        return this.file.length();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    public String toString() {
        return String.valueOf(this.fileName) + ":" + this.position();
    }
}

