/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import scala.collection.mutable.StringBuilder;

public class LineClassFileIterator<T>
extends FileIterator<T> {
    public static boolean debug = false;
    public static final char FIELD_NAME_SEPARATOR = ';';
    protected String separator = "\t";
    protected String fieldStr;
    protected String[] fieldNames;
    protected HashMap<String, Field> fieldByName;
    protected Class clazz;

    public LineClassFileIterator(String fileName, Class clazz) {
        super(fileName);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        this.clazz = clazz;
        this.reader = Gpr.reader(fileName);
        this.fieldStr = this.guessFields();
        if (this.fieldStr != null) {
            this.fieldMap();
        }
    }

    public LineClassFileIterator(String fileName, Class clazz, String fieldNames) {
        super(fileName);
        this.line = null;
        this.lineNum = 0;
        this.reader = null;
        this.clazz = clazz;
        this.reader = Gpr.reader(fileName);
        this.fieldStr = fieldNames;
        if (this.fieldStr != null) {
            this.fieldMap();
        }
    }

    protected T createObject(String line) {
        Object tObj;
        String[] vals = line.split(this.separator);
        try {
            tObj = this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int maxFieldNum = Math.min(vals.length, this.fieldNames.length);
        int i = 0;
        while (i < maxFieldNum) {
            block11: {
                if (!this.fieldNames[i].isEmpty()) {
                    Field field2 = this.fieldByName.get(this.fieldNames[i]);
                    String typeName = field2.getType().getCanonicalName();
                    try {
                        String valOri = vals[i];
                        if (typeName.equals("java.lang.String")) {
                            field2.set(tObj, valOri);
                            break block11;
                        }
                        String valTrim = valOri.trim();
                        if (typeName.equals("int")) {
                            field2.setInt(tObj, Gpr.parseIntSafe(valTrim));
                            break block11;
                        }
                        if (typeName.equals("long")) {
                            field2.setLong(tObj, Gpr.parseLongSafe(valTrim));
                            break block11;
                        }
                        if (typeName.equals("double")) {
                            field2.setDouble(tObj, Gpr.parseDoubleSafe(valTrim));
                            break block11;
                        }
                        if (typeName.equals("float")) {
                            field2.setFloat(tObj, Gpr.parseFloatSafe(valTrim));
                            break block11;
                        }
                        throw new RuntimeException("Unsoported parsing for object type '" + typeName + "' cannot be parsed.");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i;
        }
        return tObj;
    }

    protected void fieldMap() {
        this.fieldNames = this.fieldStr.split(";");
        this.fieldByName = new HashMap();
        String[] stringArray = this.fieldNames;
        int n = this.fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            try {
                if (!fname.isEmpty()) {
                    Field field2 = this.clazz.getField(fname);
                    this.fieldByName.put(fname, field2);
                }
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Error: Field '" + fname + "' not found for class '" + this.clazz.getCanonicalName() + "' (may be the fields is not public?)");
            }
            ++n2;
        }
    }

    String guessFields() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        Field[] fieldArray = fields = this.clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f2 = fieldArray[n2];
            sb.append(String.valueOf(f2.getName()) + ';');
            ++n2;
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    protected T readNext() {
        try {
            if (this.reader.ready()) {
                while ((this.line = this.reader.readLine()) != null) {
                    if (this.line.trim().isEmpty()) continue;
                    ++this.lineNum;
                    return this.createObject(this.line);
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

