/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.collections;

public class BitUtil {
    public static final byte[] ntzTable;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 8;
        byArray[2] = 1;
        byArray[4] = 2;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[10] = 1;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[16] = 4;
        byArray[18] = 1;
        byArray[20] = 2;
        byArray[22] = 1;
        byArray[24] = 3;
        byArray[26] = 1;
        byArray[28] = 2;
        byArray[30] = 1;
        byArray[32] = 5;
        byArray[34] = 1;
        byArray[36] = 2;
        byArray[38] = 1;
        byArray[40] = 3;
        byArray[42] = 1;
        byArray[44] = 2;
        byArray[46] = 1;
        byArray[48] = 4;
        byArray[50] = 1;
        byArray[52] = 2;
        byArray[54] = 1;
        byArray[56] = 3;
        byArray[58] = 1;
        byArray[60] = 2;
        byArray[62] = 1;
        byArray[64] = 6;
        byArray[66] = 1;
        byArray[68] = 2;
        byArray[70] = 1;
        byArray[72] = 3;
        byArray[74] = 1;
        byArray[76] = 2;
        byArray[78] = 1;
        byArray[80] = 4;
        byArray[82] = 1;
        byArray[84] = 2;
        byArray[86] = 1;
        byArray[88] = 3;
        byArray[90] = 1;
        byArray[92] = 2;
        byArray[94] = 1;
        byArray[96] = 5;
        byArray[98] = 1;
        byArray[100] = 2;
        byArray[102] = 1;
        byArray[104] = 3;
        byArray[106] = 1;
        byArray[108] = 2;
        byArray[110] = 1;
        byArray[112] = 4;
        byArray[114] = 1;
        byArray[116] = 2;
        byArray[118] = 1;
        byArray[120] = 3;
        byArray[122] = 1;
        byArray[124] = 2;
        byArray[126] = 1;
        byArray[128] = 7;
        byArray[130] = 1;
        byArray[132] = 2;
        byArray[134] = 1;
        byArray[136] = 3;
        byArray[138] = 1;
        byArray[140] = 2;
        byArray[142] = 1;
        byArray[144] = 4;
        byArray[146] = 1;
        byArray[148] = 2;
        byArray[150] = 1;
        byArray[152] = 3;
        byArray[154] = 1;
        byArray[156] = 2;
        byArray[158] = 1;
        byArray[160] = 5;
        byArray[162] = 1;
        byArray[164] = 2;
        byArray[166] = 1;
        byArray[168] = 3;
        byArray[170] = 1;
        byArray[172] = 2;
        byArray[174] = 1;
        byArray[176] = 4;
        byArray[178] = 1;
        byArray[180] = 2;
        byArray[182] = 1;
        byArray[184] = 3;
        byArray[186] = 1;
        byArray[188] = 2;
        byArray[190] = 1;
        byArray[192] = 6;
        byArray[194] = 1;
        byArray[196] = 2;
        byArray[198] = 1;
        byArray[200] = 3;
        byArray[202] = 1;
        byArray[204] = 2;
        byArray[206] = 1;
        byArray[208] = 4;
        byArray[210] = 1;
        byArray[212] = 2;
        byArray[214] = 1;
        byArray[216] = 3;
        byArray[218] = 1;
        byArray[220] = 2;
        byArray[222] = 1;
        byArray[224] = 5;
        byArray[226] = 1;
        byArray[228] = 2;
        byArray[230] = 1;
        byArray[232] = 3;
        byArray[234] = 1;
        byArray[236] = 2;
        byArray[238] = 1;
        byArray[240] = 4;
        byArray[242] = 1;
        byArray[244] = 2;
        byArray[246] = 1;
        byArray[248] = 3;
        byArray[250] = 1;
        byArray[252] = 2;
        byArray[254] = 1;
        ntzTable = byArray;
    }

    public static boolean isPowerOfTwo(int v) {
        return (v & v - 1) == 0;
    }

    public static boolean isPowerOfTwo(long v) {
        return (v & v - 1L) == 0L;
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    public static int ntz(int val) {
        int lowByte = val & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte];
        }
        lowByte = val >>> 8 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 8;
        }
        lowByte = val >>> 16 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 16;
        }
        return ntzTable[val >>> 24] + 24;
    }

    public static int ntz(long val) {
        int lower = (int)val;
        int lowByte = lower & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte];
        }
        if (lower != 0) {
            lowByte = lower >>> 8 & 0xFF;
            if (lowByte != 0) {
                return ntzTable[lowByte] + 8;
            }
            lowByte = lower >>> 16 & 0xFF;
            if (lowByte != 0) {
                return ntzTable[lowByte] + 16;
            }
            return ntzTable[lower >>> 24] + 24;
        }
        int upper = (int)(val >> 32);
        lowByte = upper & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 32;
        }
        lowByte = upper >>> 8 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 40;
        }
        lowByte = upper >>> 16 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 48;
        }
        return ntzTable[upper >>> 24] + 56;
    }

    public static int ntz2(long x2) {
        int n = 0;
        int y = (int)x2;
        if (y == 0) {
            n += 32;
            y = (int)(x2 >>> 32);
        }
        if ((y & 0xFFFF) == 0) {
            n += 16;
            y >>>= 16;
        }
        if ((y & 0xFF) == 0) {
            n += 8;
            y >>>= 8;
        }
        return ntzTable[y & 0xFF] + n;
    }

    public static int ntz3(long x2) {
        int n = 1;
        int y = (int)x2;
        if (y == 0) {
            n += 32;
            y = (int)(x2 >>> 32);
        }
        if ((y & 0xFFFF) == 0) {
            n += 16;
            y >>>= 16;
        }
        if ((y & 0xFF) == 0) {
            n += 8;
            y >>>= 8;
        }
        if ((y & 0xF) == 0) {
            n += 4;
            y >>>= 4;
        }
        if ((y & 3) == 0) {
            n += 2;
            y >>>= 2;
        }
        return n - (y & 1);
    }

    public static int pop(long x2) {
        x2 -= x2 >>> 1 & 0x5555555555555555L;
        x2 = (x2 & 0x3333333333333333L) + (x2 >>> 2 & 0x3333333333333333L);
        x2 = x2 + (x2 >>> 4) & 0xF0F0F0F0F0F0F0FL;
        x2 += x2 >>> 8;
        x2 += x2 >>> 16;
        x2 += x2 >>> 32;
        return (int)x2 & 0x7F;
    }

    public static long pop_andnot(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        int i = wordOffset;
        while (i <= n - 8) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & (B[i + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 3] & (B[i + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] & (B[i + 4] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 5] & (B[i + 5] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] & (B[i + 6] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 7] & (B[i + 7] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
            i += 8;
        }
        if (i <= n - 4) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & (B[i + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 3] & (B[i + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_array(long[] A, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        int i = wordOffset;
        while (i <= n - 8) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2];
            c = A[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4];
            c = A[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6];
            c = A[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
            i += 8;
        }
        if (i <= n - 4) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2];
            c = A[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_intersect(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        int i = wordOffset;
        while (i <= n - 8) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & B[i + 2];
            c = A[i + 3] & B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] & B[i + 4];
            c = A[i + 5] & B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] & B[i + 6];
            c = A[i + 7] & B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
            i += 8;
        }
        if (i <= n - 4) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & B[i + 2];
            c = A[i + 3] & B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] & B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_union(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        int i = wordOffset;
        while (i <= n - 8) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] | B[i + 2];
            c = A[i + 3] | B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] | B[i + 4];
            c = A[i + 5] | B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] | B[i + 6];
            c = A[i + 7] | B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
            i += 8;
        }
        if (i <= n - 4) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] | B[i + 2];
            c = A[i + 3] | B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] | B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_xor(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        int i = wordOffset;
        while (i <= n - 8) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] ^ B[i + 2];
            c = A[i + 3] ^ B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] ^ B[i + 4];
            c = A[i + 5] ^ B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] ^ B[i + 6];
            c = A[i + 7] ^ B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
            i += 8;
        }
        if (i <= n - 4) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] ^ B[i + 2];
            c = A[i + 3] ^ B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] ^ B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }
}

