/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fileIterator.RegulationFileIterator;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class RegulationFileConsensus {
    boolean verbose = false;
    int totalCount = 0;
    long totalLength = 0L;
    int totalLineNum = 0;
    HashMap<String, RegulationConsensus> regConsByName = new HashMap();
    HashMap<String, ArrayList<Regulation>> regByCell = new HashMap();

    public RegulationFileConsensus(boolean verbose) {
        this.verbose = verbose;
    }

    public void consensus(Regulation reg) {
        String name = reg.getName();
        String cell = reg.getCellType();
        String key = String.valueOf(cell) + "_" + name;
        RegulationConsensus regCons = this.regConsByName.get(key);
        if (regCons == null) {
            regCons = new RegulationConsensus();
            this.regConsByName.put(key, regCons);
        }
        regCons.add(reg);
    }

    public Collection<String> getCellTypes() {
        return this.regByCell.keySet();
    }

    public ArrayList<Regulation> getRegulationList(String cellType) {
        ArrayList<Regulation> regs = this.regByCell.get(cellType);
        if (regs == null) {
            regs = new ArrayList();
            this.regByCell.put(cellType, regs);
        }
        return regs;
    }

    public void readFile(RegulationFileIterator regulationFileIterator) {
        String chromo = "";
        int lineNum = 1;
        for (Regulation reg : regulationFileIterator) {
            if (!chromo.equals(reg.getChromosomeName())) {
                if (this.verbose) {
                    Timer.showStdErr("\tChromosome '" + reg.getChromosomeName() + "'\tline: " + regulationFileIterator.getLineNum());
                }
                for (RegulationConsensus regCons : this.regConsByName.values()) {
                    regCons.flush();
                }
                chromo = reg.getChromosomeName();
            }
            this.consensus(reg);
            ++lineNum;
            ++this.totalLineNum;
        }
        for (RegulationConsensus regCons : this.regConsByName.values()) {
            regCons.flush();
        }
        Timer.showStdErr("Done");
        double perc = 100.0 * (double)this.totalCount / (double)this.totalLineNum;
        System.err.println("\tTotal lines                 : " + lineNum);
        System.err.println("\tTotal annotation count      : " + this.totalCount);
        System.err.println("\tPercent                     : " + String.format("%.1f%%", perc));
        System.err.println("\tTotal annotated length      : " + this.totalLength);
        System.err.println("\tNumber of cell/annotations  : " + this.regConsByName.size());
    }

    public void save(String outputDir) {
        for (String cellType : this.regByCell.keySet()) {
            String fileName = String.valueOf(outputDir) + "/regulation_" + cellType + ".bin";
            Timer.showStdErr("Saving database '" + cellType + "' in file '" + fileName + "'");
            Gpr.toFileSerializeGz(fileName, this.regByCell.get(cellType));
        }
    }

    void show(Regulation reg) {
        System.out.println(reg);
    }

    class RegulationConsensus {
        int count = 1;
        Regulation consensus = null;

        RegulationConsensus() {
        }

        void add(Regulation r) {
            if (this.consensus == null) {
                this.consensus = r;
                this.count = 1;
            } else if (this.consensus.intersects(r)) {
                this.consensus.setStart(Math.max(this.consensus.getStart(), r.getStart()));
                this.consensus.setEnd(Math.max(this.consensus.getEnd(), r.getEnd()));
                ++this.count;
            } else {
                this.flush();
                this.consensus = r;
                this.count = 1;
            }
        }

        void flush() {
            if (this.consensus != null) {
                ++RegulationFileConsensus.this.totalCount;
                RegulationFileConsensus.this.totalLength += (long)this.consensus.size();
                ArrayList<Regulation> regs = RegulationFileConsensus.this.getRegulationList(this.consensus.getCellType());
                regs.add(this.consensus);
            }
        }
    }
}

