/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.RegulationFileConsensus;
import ca.mcgill.mcb.pcingola.collections.AutoHashMap;
import ca.mcgill.mcb.pcingola.fileIterator.RegulationBedFileIterator;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RegulationConsensusMultipleBed {
    boolean verbose = false;
    AutoHashMap<String, ArrayList<String>> filesByCellType;
    HashMap<String, String> epiMarkByFile;
    String outDir;
    String inDir;
    String cellType = null;

    public RegulationConsensusMultipleBed(String inDir, String outDir) {
        this.inDir = inDir;
        this.outDir = outDir;
    }

    RegulationFileConsensus consensus(RegulationFileConsensus regCons, String cellType) {
        if (this.verbose) {
            Timer.showStdErr("Creating consensus for cell type: " + cellType);
        }
        ArrayList<Regulation> regs = regCons.getRegulationList(cellType);
        if (this.verbose) {
            Timer.showStdErr("Sorting: " + cellType + "\t, size: " + regs.size());
        }
        Collections.sort(regs);
        if (this.verbose) {
            Timer.showStdErr("Adding to final consensus");
        }
        RegulationFileConsensus consCellType = new RegulationFileConsensus(false);
        for (Regulation reg : regs) {
            consCellType.consensus(reg);
        }
        regs = consCellType.getRegulationList(cellType);
        if (this.verbose) {
            Timer.showStdErr("Final consensus for cell type: " + cellType + "\t, size: " + regs.size());
        }
        return consCellType;
    }

    void consensusByCellType() {
        for (String cellType : this.filesByCellType.keySet()) {
            ArrayList<String> bedFiles = this.filesByCellType.getOrCreate(cellType);
            if (this.verbose) {
                Timer.showStdErr("Creating consensus for cellType '" + cellType + "', files: " + bedFiles);
            }
            RegulationFileConsensus regCons = this.readBeds(bedFiles, cellType);
            regCons = this.consensus(regCons, cellType);
            regCons.save(this.outDir);
        }
    }

    RegulationFileConsensus readBeds(List<String> bedFiles, String cellType) {
        RegulationFileConsensus regCons = new RegulationFileConsensus(true);
        for (String bedFile : bedFiles) {
            if (this.verbose) {
                Timer.showStdErr("Reading file '" + bedFile + "'");
            }
            String epigeneticMark = this.epiMarkByFile.get(bedFile);
            RegulationBedFileIterator regFile = new RegulationBedFileIterator(bedFile, epigeneticMark, cellType);
            regCons.readFile(regFile);
        }
        return regCons;
    }

    void readDir(String dirName) {
        this.filesByCellType = new AutoHashMap(new ArrayList());
        this.epiMarkByFile = new HashMap();
        int countFiles = 0;
        File dir = new File(dirName);
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts;
            String file = stringArray[n2];
            if (file.indexOf(".bed") > 0 && (parts = file.split("\\.")).length > 2) {
                String cellType = parts[1];
                String epigeneticMark = parts[2];
                if (this.cellType == null || this.cellType.equals(cellType)) {
                    String filePath = String.valueOf(dirName) + "/" + file;
                    this.epiMarkByFile.put(filePath, epigeneticMark);
                    ArrayList<String> files = this.filesByCellType.getOrCreate(cellType);
                    files.add(filePath);
                    ++countFiles;
                }
            }
            ++n2;
        }
        if (this.verbose) {
            Timer.showStdErr("Directory has " + countFiles + " bed files and " + this.filesByCellType.size() + " cell types");
        }
    }

    public void run() {
        this.readDir(this.inDir);
        this.consensusByCellType();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

